/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jtstest.geomop;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.io.WKTWriter;
import com.vividsolutions.jts.operation.buffer.validate.BufferResultValidator;
import com.vividsolutions.jts.util.Assert;
import com.vividsolutions.jtstest.geomop.GeometryMethodOperation;
import com.vividsolutions.jtstest.geomop.GeometryOperation;
import com.vividsolutions.jtstest.testrunner.GeometryResult;
import com.vividsolutions.jtstest.testrunner.Result;

public class BufferValidatedGeometryOperation
implements GeometryOperation {
    private boolean returnEmptyGC = false;
    private GeometryMethodOperation chainOp = new GeometryMethodOperation();
    private int argCount = 0;
    private double distance;
    private int quadSegments;
    private int endCapStyle;

    public BufferValidatedGeometryOperation() {
    }

    public Class getReturnType(String string) {
        return this.chainOp.getReturnType(string);
    }

    public BufferValidatedGeometryOperation(GeometryMethodOperation geometryMethodOperation) {
        this.chainOp = geometryMethodOperation;
    }

    public Result invoke(String string, Geometry geometry, Object[] objectArray) throws Exception {
        boolean bl = string.equalsIgnoreCase("buffer");
        if (!bl) {
            return this.chainOp.invoke(string, geometry, objectArray);
        }
        this.parseArgs(objectArray);
        return this.invokeBufferOpValidated(geometry, objectArray);
    }

    private void parseArgs(Object[] objectArray) {
        this.argCount = objectArray.length;
        this.distance = Double.parseDouble((String)objectArray[0]);
        if (this.argCount >= 2) {
            this.quadSegments = Integer.parseInt((String)objectArray[1]);
        }
        if (this.argCount >= 3) {
            this.endCapStyle = Integer.parseInt((String)objectArray[2]);
        }
    }

    private Result invokeBufferOpValidated(Geometry geometry, Object[] objectArray) {
        Geometry geometry2 = null;
        geometry2 = this.invokeBuffer(geometry);
        this.validate(geometry, geometry2);
        if (this.returnEmptyGC) {
            geometry2 = geometry2.getFactory().createGeometryCollection(null);
        }
        return new GeometryResult(geometry2);
    }

    private Geometry invokeBuffer(Geometry geometry) {
        if (this.argCount == 1) {
            return geometry.buffer(this.distance);
        }
        if (this.argCount == 2) {
            return geometry.buffer(this.distance, this.quadSegments);
        }
        Assert.shouldNeverReachHere((String)"Unknown or unhandled buffer method");
        return null;
    }

    private void validate(Geometry geometry, Geometry geometry2) {
        if (this.isEmptyBufferExpected(geometry)) {
            this.checkEmpty(geometry2);
            return;
        }
        this.checkContainment(geometry, geometry2);
        this.checkDistance(geometry, this.distance, geometry2);
    }

    private boolean isEmptyBufferExpected(Geometry geometry) {
        boolean bl = geometry.getDimension() < 2 && this.distance <= 0.0;
        return bl;
    }

    private void checkEmpty(Geometry geometry) {
        if (geometry.isEmpty()) {
            return;
        }
        this.reportError("Expected empty buffer result", null);
    }

    private void checkContainment(Geometry geometry, Geometry geometry2) {
        boolean bl = true;
        String string = "";
        if (this.distance > 0.0) {
            bl = geometry2.covers(geometry);
            string = "Geometry is not contained in (positive) buffer";
        } else if (this.distance < 0.0) {
            string = "Geometry does not contain (negative) buffer";
            bl = geometry2.isEmpty() ? true : geometry.covers(geometry2);
        }
        if (!bl) {
            this.reportError(string, null);
        }
    }

    private void checkDistance(Geometry geometry, double d, Geometry geometry2) {
        BufferResultValidator bufferResultValidator = new BufferResultValidator(geometry, d, geometry2);
        if (!bufferResultValidator.isValid()) {
            String string = bufferResultValidator.getErrorMessage();
            Coordinate coordinate = bufferResultValidator.getErrorLocation();
            this.reportError(string, coordinate);
        }
    }

    private void reportError(String string, Coordinate coordinate) {
        String string2 = "";
        if (coordinate != null) {
            string2 = " at " + WKTWriter.toPoint((Coordinate)coordinate);
        }
        throw new RuntimeException(string + string2);
    }
}

