/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jtstest.geomop;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jtstest.geomop.GeometryOperation;
import com.vividsolutions.jtstest.testrunner.BooleanResult;
import com.vividsolutions.jtstest.testrunner.DoubleResult;
import com.vividsolutions.jtstest.testrunner.GeometryResult;
import com.vividsolutions.jtstest.testrunner.IntegerResult;
import com.vividsolutions.jtstest.testrunner.JTSTestReflectionException;
import com.vividsolutions.jtstest.testrunner.Result;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class GeometryMethodOperation
implements GeometryOperation {
    private Method[] geometryMethods = Geometry.class.getMethods();
    private Object[] convArg = new Object[1];

    public static boolean isBooleanFunction(String string) {
        return GeometryMethodOperation.getGeometryReturnType(string) == Boolean.TYPE;
    }

    public static boolean isIntegerFunction(String string) {
        return GeometryMethodOperation.getGeometryReturnType(string) == Integer.TYPE;
    }

    public static boolean isDoubleFunction(String string) {
        return GeometryMethodOperation.getGeometryReturnType(string) == Double.TYPE;
    }

    public static boolean isGeometryFunction(String string) {
        return Geometry.class.isAssignableFrom(GeometryMethodOperation.getGeometryReturnType(string));
    }

    public static Class getGeometryReturnType(String string) {
        Method[] methodArray = Geometry.class.getMethods();
        for (int i = 0; i < methodArray.length; ++i) {
            Class<?> clazz;
            if (!methodArray[i].getName().equalsIgnoreCase(string) || (clazz = methodArray[i].getReturnType()) != Boolean.TYPE && !Geometry.class.isAssignableFrom(clazz) && clazz != Double.TYPE && clazz != Integer.TYPE) continue;
            return clazz;
        }
        return null;
    }

    public Class getReturnType(String string) {
        return GeometryMethodOperation.getGeometryReturnType(string);
    }

    public Result invoke(String string, Geometry geometry, Object[] objectArray) throws Exception {
        Object[] objectArray2 = new Object[objectArray.length];
        Method method = this.getGeometryMethod(string, objectArray, objectArray2);
        if (method == null) {
            throw new JTSTestReflectionException(string, objectArray);
        }
        return this.invokeMethod(method, geometry, objectArray2);
    }

    private Method getGeometryMethod(String string, Object[] objectArray, Object[] objectArray2) {
        for (int i = 0; i < this.geometryMethods.length; ++i) {
            if (!this.geometryMethods[i].getName().equalsIgnoreCase(string) || !this.convertArgs(this.geometryMethods[i].getParameterTypes(), objectArray, objectArray2)) continue;
            return this.geometryMethods[i];
        }
        return null;
    }

    private static int nonNullItemCount(Object[] objectArray) {
        int n = 0;
        for (int i = 0; i < objectArray.length; ++i) {
            if (objectArray[i] == null) continue;
            ++n;
        }
        return n;
    }

    private boolean convertArgs(Class[] classArray, Object[] objectArray, Object[] objectArray2) {
        if (classArray.length != GeometryMethodOperation.nonNullItemCount(objectArray)) {
            return false;
        }
        for (int i = 0; i < objectArray.length; ++i) {
            boolean bl = this.convertArg(classArray[i], objectArray[i], this.convArg);
            if (!bl) {
                return false;
            }
            objectArray2[i] = this.convArg[0];
        }
        return true;
    }

    private boolean convertArg(Class clazz, Object object, Object[] objectArray) {
        objectArray[0] = null;
        if (object instanceof String) {
            return this.convertArgFromString(clazz, (String)object, objectArray);
        }
        if (clazz.isAssignableFrom(object.getClass())) {
            objectArray[0] = object;
            return true;
        }
        return false;
    }

    private boolean convertArgFromString(Class clazz, String string, Object[] objectArray) {
        objectArray[0] = null;
        if (clazz == Boolean.class || clazz == Boolean.TYPE) {
            if (string.equals("true")) {
                objectArray[0] = new Boolean(true);
                return true;
            }
            if (string.equals("false")) {
                objectArray[0] = new Boolean(false);
                return true;
            }
            return false;
        }
        if (clazz == Integer.class || clazz == Integer.TYPE) {
            try {
                objectArray[0] = new Integer(string);
                return true;
            }
            catch (NumberFormatException numberFormatException) {
                return false;
            }
        }
        if (clazz == Double.class || clazz == Double.TYPE) {
            try {
                objectArray[0] = new Double(string);
                return true;
            }
            catch (NumberFormatException numberFormatException) {
                return false;
            }
        }
        if (clazz == String.class) {
            objectArray[0] = string;
            return true;
        }
        return false;
    }

    private Result invokeMethod(Method method, Geometry geometry, Object[] objectArray) throws Exception {
        try {
            if (method.getReturnType() == Boolean.TYPE) {
                return new BooleanResult((Boolean)method.invoke((Object)geometry, objectArray));
            }
            if (Geometry.class.isAssignableFrom(method.getReturnType())) {
                return new GeometryResult((Geometry)method.invoke((Object)geometry, objectArray));
            }
            if (method.getReturnType() == Double.TYPE) {
                return new DoubleResult((Double)method.invoke((Object)geometry, objectArray));
            }
            if (method.getReturnType() == Integer.TYPE) {
                return new IntegerResult((Integer)method.invoke((Object)geometry, objectArray));
            }
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable = invocationTargetException.getTargetException();
            if (throwable instanceof Exception) {
                throw (Exception)throwable;
            }
            throw (Error)throwable;
        }
        throw new JTSTestReflectionException("Unsupported result type: " + method.getReturnType());
    }
}

