/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jtstest.geomop;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.prep.PreparedGeometry;
import com.vividsolutions.jts.geom.prep.PreparedGeometryFactory;
import com.vividsolutions.jtstest.geomop.GeometryMethodOperation;
import com.vividsolutions.jtstest.geomop.TeeGeometryOperation;

public class PreparedGeometryTeeOperation
extends TeeGeometryOperation {
    private static boolean containsProperly(Geometry geometry, Geometry geometry2) {
        return geometry.relate(geometry2, "T**FF*FF*");
    }

    public PreparedGeometryTeeOperation() {
    }

    public PreparedGeometryTeeOperation(GeometryMethodOperation geometryMethodOperation) {
        super(geometryMethodOperation);
    }

    protected void runTeeOp(String string, Geometry geometry, Object[] objectArray) {
        if (objectArray.length < 1) {
            return;
        }
        if (!(objectArray[0] instanceof Geometry)) {
            return;
        }
        Geometry geometry2 = (Geometry)objectArray[0];
        if (!geometry.isValid()) {
            throw new IllegalStateException("Input geometry A is not valid");
        }
        if (!geometry2.isValid()) {
            throw new IllegalStateException("Input geometry B is not valid");
        }
        this.checkAllPrepOps(geometry, geometry2);
        this.checkAllPrepOps(geometry2, geometry);
    }

    private void checkAllPrepOps(Geometry geometry, Geometry geometry2) {
        PreparedGeometry preparedGeometry = PreparedGeometryFactory.prepare((Geometry)geometry);
        this.checkIntersects(preparedGeometry, geometry2);
        this.checkContains(preparedGeometry, geometry2);
        this.checkContainsProperly(preparedGeometry, geometry2);
        this.checkCovers(preparedGeometry, geometry2);
    }

    private void checkIntersects(PreparedGeometry preparedGeometry, Geometry geometry) {
        boolean bl;
        boolean bl2 = preparedGeometry.intersects(geometry);
        if (bl2 != (bl = preparedGeometry.getGeometry().intersects(geometry))) {
            throw new IllegalStateException("PreparedGeometry.intersects result does not match expected");
        }
    }

    private void checkContains(PreparedGeometry preparedGeometry, Geometry geometry) {
        boolean bl;
        boolean bl2 = preparedGeometry.contains(geometry);
        if (bl2 != (bl = preparedGeometry.getGeometry().contains(geometry))) {
            throw new IllegalStateException("PreparedGeometry.contains result does not match expected");
        }
    }

    private void checkContainsProperly(PreparedGeometry preparedGeometry, Geometry geometry) {
        boolean bl;
        boolean bl2 = preparedGeometry.containsProperly(geometry);
        if (bl2 != (bl = PreparedGeometryTeeOperation.containsProperly(preparedGeometry.getGeometry(), geometry))) {
            throw new IllegalStateException("PreparedGeometry.containsProperly result does not match expected");
        }
    }

    private void checkCovers(PreparedGeometry preparedGeometry, Geometry geometry) {
        boolean bl;
        boolean bl2 = preparedGeometry.covers(geometry);
        if (bl2 != (bl = preparedGeometry.getGeometry().covers(geometry))) {
            throw new IllegalStateException("PreparedGeometry.covers result does not match expected");
        }
    }

    static class PreparedGeometryOp {
        PreparedGeometryOp() {
        }

        public static boolean intersects(Geometry geometry, Geometry geometry2) {
            PreparedGeometryFactory preparedGeometryFactory = new PreparedGeometryFactory();
            PreparedGeometry preparedGeometry = preparedGeometryFactory.create(geometry);
            return preparedGeometry.intersects(geometry2);
        }

        public static boolean contains(Geometry geometry, Geometry geometry2) {
            PreparedGeometryFactory preparedGeometryFactory = new PreparedGeometryFactory();
            PreparedGeometry preparedGeometry = preparedGeometryFactory.create(geometry);
            return preparedGeometry.contains(geometry2);
        }

        public static boolean covers(Geometry geometry, Geometry geometry2) {
            PreparedGeometryFactory preparedGeometryFactory = new PreparedGeometryFactory();
            PreparedGeometry preparedGeometry = preparedGeometryFactory.create(geometry);
            return preparedGeometry.contains(geometry2);
        }
    }
}

