/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jtstest.testbuilder;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jtstest.testbuilder.AppConstants;
import com.vividsolutions.jtstest.testbuilder.GeometryPopupMenu;
import com.vividsolutions.jtstest.testbuilder.Viewport;
import com.vividsolutions.jtstest.testbuilder.model.DrawingGrid;
import com.vividsolutions.jtstest.testbuilder.model.GeometryDepiction;
import com.vividsolutions.jtstest.testbuilder.model.GeometryEditModel;
import com.vividsolutions.jtstest.testbuilder.model.GeometryStretcherView;
import com.vividsolutions.jtstest.testbuilder.model.LayerList;
import com.vividsolutions.jtstest.testbuilder.model.StaticGeometryContainer;
import com.vividsolutions.jtstest.testbuilder.model.TestBuilderModel;
import com.vividsolutions.jtstest.testbuilder.ui.ColorUtil;
import com.vividsolutions.jtstest.testbuilder.ui.GeometryLocationsWriter;
import com.vividsolutions.jtstest.testbuilder.ui.render.GeometryPainter;
import com.vividsolutions.jtstest.testbuilder.ui.render.GridRenderer;
import com.vividsolutions.jtstest.testbuilder.ui.render.LayerRenderer;
import com.vividsolutions.jtstest.testbuilder.ui.render.RenderManager;
import com.vividsolutions.jtstest.testbuilder.ui.render.Renderer;
import com.vividsolutions.jtstest.testbuilder.ui.style.AWTUtil;
import com.vividsolutions.jtstest.testbuilder.ui.tools.Tool;
import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.text.NumberFormat;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class GeometryEditPanel
extends JPanel {
    private TestBuilderModel tbModel;
    private DrawingGrid grid = new DrawingGrid();
    private GridRenderer gridRenderer;
    boolean stateAddingPoints = false;
    Coordinate markPoint;
    Point2D lastPt = new Point2D.Double();
    private Tool currentTool = null;
    private Viewport viewport = new Viewport(this);
    private RenderManager renderMgr;
    BorderLayout borderLayout1 = new BorderLayout();
    GeometryPopupMenu menu = new GeometryPopupMenu();
    private static int VERTEX_SIZE = 5;
    private static double VERTEX_SIZE_OVER_2 = VERTEX_SIZE / 2;
    private static int INNER_SIZE = VERTEX_SIZE - 2;
    private static double INNER_SIZE_OVER_2 = INNER_SIZE / 2;
    private static double VERTEX_SHADOW_SIZE_OVER_2 = AppConstants.VERTEX_SHADOW_SIZE / 2.0;

    public GeometryEditPanel() {
        this.gridRenderer = new GridRenderer(this.viewport, this.grid);
        try {
            this.initUI();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.renderMgr = new RenderManager(this);
    }

    void initUI() throws Exception {
        this.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent componentEvent) {
                GeometryEditPanel.this.this_componentResized(componentEvent);
            }
        });
        this.setBackground(Color.white);
        this.setBorder(BorderFactory.createLoweredBevelBorder());
        this.setLayout(this.borderLayout1);
        this.setToolTipText("");
        this.setBorder(BorderFactory.createEmptyBorder());
    }

    public void setModel(TestBuilderModel testBuilderModel) {
        this.tbModel = testBuilderModel;
    }

    public TestBuilderModel getModel() {
        return this.tbModel;
    }

    public GeometryEditModel getGeomModel() {
        return this.tbModel.getGeometryEditModel();
    }

    public void setGridEnabled(boolean bl) {
        this.gridRenderer.setEnabled(bl);
    }

    public Viewport getViewport() {
        return this.viewport;
    }

    public void updateView() {
        this.forceRepaint();
    }

    public void forceRepaint() {
        this.renderMgr.setDirty(true);
        Container container = SwingUtilities.windowForComponent(this);
        if (container == null) {
            container = this;
        }
        container.repaint();
    }

    private LayerList getLayerList() {
        return this.tbModel.getLayers();
    }

    public void setShowingInput(boolean bl) {
        if (this.tbModel == null) {
            return;
        }
        this.getLayerList().getLayer(0).setEnabled(bl);
        this.getLayerList().getLayer(1).setEnabled(bl);
        this.forceRepaint();
    }

    public void setShowingGeometryA(boolean bl) {
        if (this.tbModel == null) {
            return;
        }
        this.getLayerList().getLayer(0).setEnabled(bl);
        this.forceRepaint();
    }

    public void setShowingGeometryB(boolean bl) {
        if (this.tbModel == null) {
            return;
        }
        this.getLayerList().getLayer(1).setEnabled(bl);
        this.forceRepaint();
    }

    public void setShowingResult(boolean bl) {
        if (this.tbModel == null) {
            return;
        }
        this.getLayerList().getLayer(2).setEnabled(bl);
        this.forceRepaint();
    }

    public void setGridSize(double d) {
        this.grid.setGridSize(d);
        this.forceRepaint();
    }

    public void setHighlightPoint(Coordinate coordinate) {
        this.markPoint = coordinate;
    }

    public boolean isAddingPoints() {
        return this.stateAddingPoints;
    }

    public void updateGeom() {
        this.renderMgr.setDirty(true);
        this.getGeomModel().geomChanged();
    }

    public String getToolTipText(MouseEvent mouseEvent) {
        Coordinate coordinate = this.viewport.toModelCoordinate(mouseEvent.getPoint());
        double d = (double)AppConstants.TOLERANCE_PIXELS / this.getViewport().getScale();
        if (d <= 0.0) {
            return null;
        }
        return GeometryLocationsWriter.writeLocation(this.getLayerList(), coordinate, d);
    }

    public double getToleranceInModel() {
        return (double)AppConstants.TOLERANCE_PIXELS / this.getViewport().getScale();
    }

    public String getInfo(Coordinate coordinate) {
        double d = (double)AppConstants.TOLERANCE_PIXELS / this.getViewport().getScale();
        GeometryLocationsWriter geometryLocationsWriter = new GeometryLocationsWriter();
        geometryLocationsWriter.setHtml(false);
        return geometryLocationsWriter.writeLocationString(this.getLayerList(), coordinate, d);
    }

    public double getGridSize() {
        return this.grid.getGridSize();
    }

    public void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        this.renderMgr.render();
        this.renderMgr.copyImage(graphics);
    }

    private void drawHighlightedVertices(Graphics2D graphics2D, List list, Color color) {
        Rectangle2D.Double double_ = new Rectangle2D.Double();
        for (int i = 0; i < list.size(); ++i) {
            Coordinate coordinate = (Coordinate)list.get(i);
            Point2D point2D = this.viewport.toView(coordinate);
            double_.setFrame(point2D.getX() - VERTEX_SIZE_OVER_2, point2D.getY() - VERTEX_SIZE_OVER_2, VERTEX_SIZE, VERTEX_SIZE);
            graphics2D.setColor(color);
            graphics2D.fill(double_);
            Rectangle2D.Double double_2 = new Rectangle2D.Double(point2D.getX() - INNER_SIZE_OVER_2, point2D.getY() - INNER_SIZE_OVER_2, INNER_SIZE, INNER_SIZE);
            graphics2D.setColor(AppConstants.VERTEX_HIGHLIGHT_CLR);
            graphics2D.fill(double_2);
        }
    }

    private void drawHighlightedVertex(Graphics2D graphics2D, Coordinate coordinate, Color color) {
        Rectangle2D.Double double_ = new Rectangle2D.Double();
        Point2D point2D = this.viewport.toView(coordinate);
        double_.setFrame(point2D.getX() - VERTEX_SIZE_OVER_2, point2D.getY() - VERTEX_SIZE_OVER_2, VERTEX_SIZE, VERTEX_SIZE);
        graphics2D.setColor(color);
        graphics2D.fill(double_);
        Rectangle2D.Double double_2 = new Rectangle2D.Double(point2D.getX() - INNER_SIZE_OVER_2, point2D.getY() - INNER_SIZE_OVER_2, INNER_SIZE, INNER_SIZE);
        graphics2D.setColor(AppConstants.VERTEX_HIGHLIGHT_CLR);
        graphics2D.fill(double_2);
    }

    private void drawVertexShadow(Graphics2D graphics2D, Coordinate coordinate, Color color) {
        Ellipse2D.Double double_ = new Ellipse2D.Double();
        Point2D point2D = this.viewport.toView(coordinate);
        ((RectangularShape)double_).setFrame(point2D.getX() - VERTEX_SHADOW_SIZE_OVER_2, point2D.getY() - VERTEX_SHADOW_SIZE_OVER_2, AppConstants.VERTEX_SHADOW_SIZE, AppConstants.VERTEX_SHADOW_SIZE);
        graphics2D.setColor(color);
        graphics2D.fill(double_);
    }

    private void drawMark(Graphics2D graphics2D) {
        if (this.markPoint == null) {
            return;
        }
        String string = this.markPoint.x + ",  " + this.markPoint.y;
        int n = graphics2D.getFontMetrics().stringWidth(string);
        double d = AppConstants.HIGHLIGHT_SIZE;
        Point2D point2D = this.viewport.toView(this.markPoint);
        double d2 = point2D.getX();
        double d3 = point2D.getY();
        Ellipse2D.Double double_ = new Ellipse2D.Double(d2 - d / 2.0, d3 - d / 2.0, d, d);
        AWTUtil.setStroke(graphics2D, 4.0);
        graphics2D.setColor(AppConstants.HIGHLIGHT_CLR);
        graphics2D.draw(double_);
        Envelope envelope = this.viewport.getViewEnv();
        int n2 = 10;
        int n3 = 20;
        int n4 = 20;
        int n5 = n + 2 * n4;
        int n6 = 10;
        int n7 = 2;
        int n8 = 5;
        int n9 = (int)envelope.getMaxY() - n2;
        int n10 = (int)(envelope.getMinX() + envelope.getMaxX()) / 2;
        int n11 = n10 - n5 / 2;
        int n12 = n10 + n5 / 2;
        int n13 = n9 - n3;
        int n14 = n9;
        int[] nArray = new int[]{n11, n10 - n6 / 2, (int)d2, n10 + n6 / 2, n12, n12, n11};
        int[] nArray2 = new int[]{n13, n13, (int)(d3 + (double)n7), n13, n13, n14, n14};
        Polygon polygon = new Polygon(nArray, nArray2, nArray.length);
        graphics2D.setColor(AppConstants.HIGHLIGHT_FILL_CLR);
        graphics2D.fill(polygon);
        AWTUtil.setStroke(graphics2D, 1.0);
        graphics2D.setColor(ColorUtil.opaque(AppConstants.HIGHLIGHT_CLR));
        graphics2D.draw(polygon);
        graphics2D.setColor(Color.BLACK);
        graphics2D.drawString(string, n10 - n / 2, n14 - n8);
    }

    private void drawMagnifyMask(Graphics2D graphics2D) {
        double d = this.viewport.getWidthInView();
        double d2 = this.viewport.getHeightInView();
        float f = (float)Math.min(d, d2);
        float f2 = (float)((double)f * AppConstants.MASK_WIDTH_FRAC / 2.0);
        Area area = new Area(new Rectangle2D.Float(0.0f, 0.0f, (float)d, (float)d2));
        Area area2 = new Area(new Rectangle2D.Float(f2, f2, (float)d - 2.0f * f2, (float)d2 - 2.0f * f2));
        area.subtract(area2);
        graphics2D.setColor(AppConstants.MASK_CLR);
        graphics2D.fill(area);
    }

    public void flash(Geometry geometry) {
        Graphics2D graphics2D = (Graphics2D)this.getGraphics();
        graphics2D.setXORMode(Color.white);
        BasicStroke basicStroke = new BasicStroke(5.0f);
        Geometry geometry2 = geometry;
        if (geometry instanceof Point) {
            geometry2 = this.flashPointGeom(geometry);
        }
        try {
            GeometryPainter.paint(geometry2, this.viewport, graphics2D, Color.RED, null, (Stroke)basicStroke);
            Thread.sleep(200L);
            GeometryPainter.paint(geometry2, this.viewport, graphics2D, Color.RED, null, (Stroke)basicStroke);
        }
        catch (Exception exception) {
            // empty catch block
        }
        graphics2D.setPaintMode();
    }

    private Geometry flashPointGeom(Geometry geometry) {
        double d = this.viewport.toModel(4.0);
        return geometry.buffer(d);
    }

    public Point2D snapToGrid(Point2D point2D) {
        return this.grid.snapToGrid(point2D);
    }

    void this_componentResized(ComponentEvent componentEvent) {
        this.renderMgr.componentResized();
        this.viewport.update();
    }

    public void setCurrentTool(Tool tool) {
        this.removeMouseListener(this.currentTool);
        this.removeMouseMotionListener(this.currentTool);
        this.currentTool = tool;
        this.currentTool.activate();
        this.setCursor(this.currentTool.getCursor());
        this.addMouseListener(this.currentTool);
        this.addMouseMotionListener(this.currentTool);
    }

    public void zoomToGeometry(int n) {
        Geometry geometry = this.getGeomModel().getGeometry(n);
        if (geometry == null) {
            return;
        }
        this.zoom(geometry.getEnvelopeInternal());
    }

    public void zoomToInput() {
        this.zoom(this.getGeomModel().getEnvelope());
    }

    public void zoomToResult() {
        this.zoom(this.getGeomModel().getEnvelopeResult());
    }

    public void zoomToFullExtent() {
        this.zoom(this.getGeomModel().getEnvelopeAll());
    }

    public void zoom(Geometry geometry) {
        if (geometry == null) {
            return;
        }
        this.zoom(geometry.getEnvelopeInternal());
    }

    public void zoom(Envelope envelope) {
        if (envelope == null) {
            return;
        }
        this.renderMgr.setDirty(true);
        if (envelope.isNull()) {
            this.viewport.zoomToInitialExtent();
            return;
        }
        double d = (envelope.getWidth() + envelope.getHeight()) / 2.0;
        if (d == 0.0) {
            d = 1.0;
        }
        double d2 = d * 0.03;
        envelope.expandToInclude(envelope.getMaxX() + d2, envelope.getMaxY() + d2);
        envelope.expandToInclude(envelope.getMinX() - d2, envelope.getMinY() - d2);
        this.viewport.zoom(envelope);
    }

    public void zoom(java.awt.Point point, double d) {
        this.renderMgr.setDirty(true);
        double d2 = (double)this.getSize().width / d;
        double d3 = (double)this.getSize().height / d;
        double d4 = (double)point.y + d3 / 2.0;
        double d5 = (double)point.x - d2 / 2.0;
        java.awt.Point point2 = new java.awt.Point((int)d5, (int)d4);
        Point2D point2D = this.viewport.toModel(point2);
        this.viewport.setScale(this.getViewport().getScale() * d);
        this.viewport.setViewOrigin(point2D.getX(), point2D.getY());
    }

    public void zoomPan(double d, double d2) {
        this.renderMgr.setDirty(true);
        this.getViewport().setViewOrigin(this.getViewport().getViewOriginX() - d, this.getViewport().getViewOriginY() - d2);
    }

    public String cursorLocationString(Point2D point2D) {
        Point2D point2D2 = this.getViewport().toModel(point2D);
        NumberFormat numberFormat = this.getViewport().getScaleFormat();
        return numberFormat.format(point2D2.getX()) + ", " + numberFormat.format(point2D2.getY());
    }

    public Renderer getRenderer() {
        return new GeometryEditPanelRenderer();
    }

    class GeometryEditPanelRenderer
    implements Renderer {
        private GeometryStretcherView stretchView = null;
        private Renderer currentRenderer = null;
        private boolean isMagnifyingTopology = false;
        private boolean isRenderingStretchVertices = false;

        public GeometryEditPanelRenderer() {
            if (GeometryEditPanel.this.tbModel.isMagnifyingTopology()) {
                this.stretchView = new GeometryStretcherView(GeometryEditPanel.this.getGeomModel());
                this.stretchView.setStretchSize(GeometryEditPanel.this.viewport.toModel(GeometryEditPanel.this.tbModel.getTopologyStretchSize()));
                this.stretchView.setNearnessTolerance(GeometryEditPanel.this.viewport.toModel(1.0));
                this.stretchView.setEnvelope(GeometryEditPanel.this.viewport.getModelEnv());
                this.isMagnifyingTopology = GeometryEditPanel.this.tbModel.isMagnifyingTopology();
                this.isRenderingStretchVertices = this.stretchView.isViewPerformant();
            }
        }

        public void render(Graphics2D graphics2D) {
            Graphics2D graphics2D2 = graphics2D;
            graphics2D2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            if (this.isMagnifyingTopology) {
                if (this.isRenderingStretchVertices) {
                    this.renderMagnifiedVertexMask(graphics2D2);
                } else {
                    this.renderMagnifyWarning(graphics2D2);
                }
            }
            GeometryEditPanel.this.gridRenderer.paint(graphics2D2);
            this.renderLayers(graphics2D2);
            if (this.isMagnifyingTopology && this.isRenderingStretchVertices) {
                this.renderMagnifiedVertices(graphics2D2);
            }
            GeometryEditPanel.this.drawMark(graphics2D2);
        }

        public void renderLayers(Graphics2D graphics2D) {
            LayerList layerList = GeometryEditPanel.this.getLayerList();
            int n = layerList.size();
            for (int i = 0; i < n; ++i) {
                this.currentRenderer = this.isMagnifyingTopology && this.isRenderingStretchVertices && this.stretchView != null && i < 2 ? new LayerRenderer(layerList.getLayer(i), new StaticGeometryContainer(this.stretchView.getStretchedGeometry(i)), GeometryEditPanel.this.viewport) : new LayerRenderer(layerList.getLayer(i), GeometryEditPanel.this.viewport);
                this.currentRenderer.render(graphics2D);
            }
            this.currentRenderer = null;
        }

        public void renderMagnifiedVertices(Graphics2D graphics2D) {
            LayerList layerList = GeometryEditPanel.this.getLayerList();
            for (int i = 0; i < 2; ++i) {
                List list;
                if (!layerList.getLayer(i).isEnabled() || (list = this.stretchView.getStretchedVertices(i)) == null) continue;
                for (int j = 0; j < list.size(); ++j) {
                    Coordinate coordinate = (Coordinate)list.get(j);
                    GeometryEditPanel.this.drawHighlightedVertex(graphics2D, coordinate, i == 0 ? GeometryDepiction.GEOM_A_HIGHLIGHT_CLR : GeometryDepiction.GEOM_B_HIGHLIGHT_CLR);
                }
            }
        }

        public void renderMagnifiedVertexShadows(Graphics2D graphics2D) {
            if (this.stretchView == null) {
                return;
            }
            for (int i = 0; i < 2; ++i) {
                List list = this.stretchView.getStretchedVertices(i);
                if (list == null) continue;
                for (int j = 0; j < list.size(); ++j) {
                    Coordinate coordinate = (Coordinate)list.get(j);
                    GeometryEditPanel.this.drawVertexShadow(graphics2D, coordinate, AppConstants.VERTEX_SHADOW_CLR);
                }
            }
        }

        public void renderMagnifiedVertexMask(Graphics2D graphics2D) {
            if (this.stretchView == null) {
                return;
            }
            Rectangle2D.Float float_ = new Rectangle2D.Float();
            float_.setFrame(0.0, 0.0, GeometryEditPanel.this.viewport.getWidthInView(), GeometryEditPanel.this.viewport.getHeightInView());
            graphics2D.setColor(AppConstants.MASK_CLR);
            graphics2D.fill(float_);
            for (int i = 0; i < 2; ++i) {
                List list = this.stretchView.getStretchedVertices(i);
                if (list == null) continue;
                for (int j = 0; j < list.size(); ++j) {
                    Coordinate coordinate = (Coordinate)list.get(j);
                    GeometryEditPanel.this.drawVertexShadow(graphics2D, coordinate, Color.WHITE);
                }
            }
        }

        public void renderMagnifyWarning(Graphics2D graphics2D) {
            if (this.stretchView == null) {
                return;
            }
            float f = (float)GeometryEditPanel.this.viewport.getWidthInView();
            float f2 = (float)GeometryEditPanel.this.viewport.getHeightInView();
            GeneralPath generalPath = new GeneralPath();
            generalPath.moveTo(0.0f, 0.0f);
            generalPath.lineTo(f, f2);
            generalPath.moveTo(0.0f, f2);
            generalPath.lineTo(f, 0.0f);
            graphics2D.setColor(AppConstants.MASK_CLR);
            graphics2D.setStroke(new BasicStroke(30.0f));
            graphics2D.draw(generalPath);
        }

        public synchronized void cancel() {
            if (this.currentRenderer != null) {
                this.currentRenderer.cancel();
            }
        }
    }

    class PopupClickListener
    extends MouseAdapter {
        PopupClickListener() {
        }

        public void mousePressed(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger()) {
                this.doPopUp(mouseEvent);
            }
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger()) {
                this.doPopUp(mouseEvent);
            }
        }

        private void doPopUp(MouseEvent mouseEvent) {
            GeometryEditPanel.this.menu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
        }
    }
}

