/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jtstest.testbuilder;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jtstest.testbuilder.GeometryTreePanel;
import com.vividsolutions.jtstest.testbuilder.JTSTestBuilderFrame;
import com.vividsolutions.jtstest.testbuilder.model.TestBuilderModel;
import com.vividsolutions.jtstest.testbuilder.ui.SwingUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSplitPane;

public class GeometryInspectorDialog
extends JDialog {
    JTSTestBuilderFrame tbFrame;
    TestBuilderModel tbModel;
    JPanel dialogPanel = new JPanel();
    BorderLayout borderLayout1 = new BorderLayout();
    GeometryTreePanel geomTreePanel = new GeometryTreePanel();
    JPanel cmdBtnSurroundPanel = new JPanel();
    JPanel cmdButtonPanel = new JPanel();
    BorderLayout borderLayout2 = new BorderLayout();
    BorderLayout borderLayout3 = new BorderLayout();
    JPanel aPanel = new JPanel();
    BorderLayout aPanelLayout = new BorderLayout();
    JPanel bPanel = new JPanel();
    BorderLayout bPanelLayout = new BorderLayout();
    JLabel geomLabel = new JLabel();
    JButton btnZoom = new JButton();
    JButton btnCopy = new JButton();
    JButton btnClose = new JButton();
    JSplitPane jSplitPane1 = new JSplitPane();

    public GeometryInspectorDialog(Frame frame, String string, boolean bl) {
        super(frame, string, bl);
        try {
            this.jbInit();
            this.pack();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public GeometryInspectorDialog() {
        this((Frame)null, "", false);
    }

    public GeometryInspectorDialog(Frame frame) {
        this((Frame)null, "Geometry Inspector", false);
    }

    void jbInit() throws Exception {
        this.cmdBtnSurroundPanel.setLayout(this.borderLayout2);
        this.btnZoom.setEnabled(true);
        this.btnZoom.setText("Zoom");
        this.btnZoom.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                GeometryInspectorDialog.this.btnZoom_actionPerformed(actionEvent);
            }
        });
        this.btnCopy.setEnabled(true);
        this.btnCopy.setText("Copy");
        this.btnCopy.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                GeometryInspectorDialog.this.btnCopy_actionPerformed(actionEvent);
            }
        });
        this.btnClose.setToolTipText("");
        this.btnClose.setText("Close");
        this.btnClose.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                GeometryInspectorDialog.this.btnOk_actionPerformed(actionEvent);
            }
        });
        this.cmdButtonPanel.add((Component)this.btnZoom, null);
        this.cmdButtonPanel.add((Component)this.btnCopy, null);
        this.cmdBtnSurroundPanel.add((Component)this.cmdButtonPanel, "South");
        this.dialogPanel.setLayout(this.borderLayout1);
        this.geomTreePanel.setPreferredSize(new Dimension(300, 500));
        this.aPanel.setLayout(this.aPanelLayout);
        this.geomLabel.setText("A");
        this.geomLabel.setHorizontalAlignment(0);
        this.aPanel.add((Component)this.geomTreePanel, "Center");
        this.dialogPanel.add((Component)this.aPanel, "Center");
        this.dialogPanel.add((Component)this.cmdBtnSurroundPanel, "North");
        this.getContentPane().add(this.dialogPanel);
    }

    public void setModel(TestBuilderModel testBuilderModel) {
        this.tbModel = testBuilderModel;
    }

    public void setGeometry(String string, Geometry geometry) {
        this.geomLabel.setText(string);
        this.geomTreePanel.populate(geometry);
    }

    void btnOk_actionPerformed(ActionEvent actionEvent) {
        this.setVisible(false);
    }

    void btnCopy_actionPerformed(ActionEvent actionEvent) {
        boolean bl = 0 != (actionEvent.getModifiers() & 2);
        Geometry geometry = this.geomTreePanel.getSelectedGeometry();
        if (geometry == null) {
            return;
        }
        SwingUtil.copyToClipboard(geometry, bl);
    }

    void btnZoom_actionPerformed(ActionEvent actionEvent) {
        JTSTestBuilderFrame.getGeometryEditPanel().zoom(this.geomTreePanel.getSelectedGeometry());
    }
}

