/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jtstest.testbuilder;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.util.Stopwatch;
import com.vividsolutions.jtstest.function.GeometryFunction;
import com.vividsolutions.jtstest.testbuilder.GeometryFunctionListPanel;
import com.vividsolutions.jtstest.testbuilder.JTSTestBuilder;
import com.vividsolutions.jtstest.testbuilder.SpatialFunctionPanelEvent;
import com.vividsolutions.jtstest.testbuilder.SpatialFunctionPanelListener;
import com.vividsolutions.jtstest.testbuilder.ui.SwingUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class ScalarFunctionPanel
extends JPanel {
    JPanel panelRB = new JPanel();
    GeometryFunctionListPanel funcListPanel = new GeometryFunctionListPanel();
    GridLayout gridLayout1 = new GridLayout();
    GridLayout gridLayout2 = new GridLayout();
    BorderLayout borderLayout1 = new BorderLayout();
    BorderLayout borderLayout2 = new BorderLayout();
    JPanel panelParam = new JPanel();
    JPanel panelExec = new JPanel();
    JPanel panelExecParam = new JPanel();
    FlowLayout flowLayout = new FlowLayout();
    FlowLayout flowLayout1 = new FlowLayout();
    JButton execButton = new JButton();
    private transient Vector spatialFunctionPanelListeners;
    private JLabel lblDistance = new JLabel();
    private JTextField txtDistance = new JTextField();
    private GeometryFunction currentFunc = null;
    private Stopwatch timer;

    public ScalarFunctionPanel() {
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    void jbInit() throws Exception {
        this.funcListPanel.populate(JTSTestBuilder.getFunctionRegistry().getScalarFunctions());
        this.setLayout(this.borderLayout1);
        this.panelParam.setLayout(this.gridLayout2);
        this.panelExec.setLayout(this.flowLayout);
        this.panelExecParam.setLayout(this.borderLayout2);
        this.panelRB.setLayout(this.gridLayout1);
        this.gridLayout2.setRows(1);
        this.gridLayout2.setColumns(2);
        this.lblDistance.setText("Distance");
        this.txtDistance.setMaximumSize(new Dimension(25, Integer.MAX_VALUE));
        this.txtDistance.setMinimumSize(new Dimension(25, 21));
        this.txtDistance.setPreferredSize(new Dimension(25, 17));
        this.txtDistance.setText("10");
        this.txtDistance.setHorizontalAlignment(4);
        this.panelParam.add(this.lblDistance);
        this.panelParam.add(this.txtDistance);
        this.execButton.setText("Compute");
        this.execButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ScalarFunctionPanel.this.execButton_actionPerformed(actionEvent);
            }
        });
        this.panelExec.add(this.execButton);
        this.panelExecParam.add((Component)this.panelExec, "North");
        this.panelExecParam.add((Component)this.panelParam, "Center");
        this.add((Component)this.funcListPanel, "Center");
        this.add((Component)this.panelExecParam, "South");
        MouseAdapter mouseAdapter = new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() == 2) {
                    ScalarFunctionPanel.this.execFunction();
                }
            }
        };
        this.funcListPanel.registerMouseListener(mouseAdapter);
        ListSelectionListener listSelectionListener = new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                ScalarFunctionPanel.this.functionListValueChanged();
            }
        };
        this.funcListPanel.registerListSelectionListener(listSelectionListener);
    }

    void execButton_actionPerformed(ActionEvent actionEvent) {
        this.execFunction();
    }

    public void execFunction() {
        this.currentFunc = this.funcListPanel.getFunction();
        if (this.currentFunc == null) {
            return;
        }
        this.fireFunctionExecuted(new SpatialFunctionPanelEvent(this));
    }

    private void setCurrentFunction(GeometryFunction geometryFunction) {
        this.currentFunc = geometryFunction;
        this.fireFunctionExecuted(new SpatialFunctionPanelEvent(this));
    }

    private void functionListValueChanged() {
        this.currentFunc = this.funcListPanel.getFunction();
        this.updateParameterControls();
    }

    private void updateParameterControls() {
        int n = ScalarFunctionPanel.numNonGeomParams(this.currentFunc);
        ScalarFunctionPanel.setEnabled(this.txtDistance, n >= 1);
    }

    private static int numNonGeomParams(GeometryFunction geometryFunction) {
        int n = 0;
        Class[] classArray = geometryFunction.getParameterTypes();
        for (int i = 0; i < classArray.length; ++i) {
            if (classArray[i] == Geometry.class) continue;
            ++n;
        }
        return n;
    }

    private static void setEnabled(Component component, boolean bl) {
        component.setEnabled(bl);
        if (bl) {
            component.setBackground(SystemColor.text);
        } else {
            component.setBackground(SystemColor.control);
        }
    }

    public Object getResult() {
        Object object = null;
        if (this.currentFunc == null || JTSTestBuilder.getGeometryA() == null) {
            return null;
        }
        try {
            this.timer = new Stopwatch();
            object = this.currentFunc.invoke(JTSTestBuilder.getGeometryA(), this.getFunctionParams());
            this.timer.stop();
        }
        catch (Exception exception) {
            exception.printStackTrace(System.out);
            object = exception;
        }
        return object;
    }

    private Object[] getFunctionParams() {
        Class[] classArray = this.currentFunc.getParameterTypes();
        if (classArray.length == 1 && classArray[0] == Geometry.class) {
            return new Object[]{JTSTestBuilder.getGeometryB()};
        }
        if (classArray.length == 1 && (classArray[0] == Double.class || classArray[0] == Double.TYPE)) {
            return new Object[]{SwingUtil.getDouble(this.txtDistance, null)};
        }
        if (classArray.length == 2 && classArray[0] == Geometry.class && (classArray[1] == Double.class || classArray[1] == Double.TYPE)) {
            return new Object[]{JTSTestBuilder.getGeometryB(), SwingUtil.getDouble(this.txtDistance, null)};
        }
        if (classArray.length >= 2) {
            return new Object[]{SwingUtil.getDouble(this.txtDistance, null)};
        }
        return null;
    }

    public String getOpName() {
        if (this.currentFunc == null) {
            return "";
        }
        return this.currentFunc.getName();
    }

    public Stopwatch getTimer() {
        return this.timer;
    }

    public synchronized void removeSpatialFunctionPanelListener(SpatialFunctionPanelListener spatialFunctionPanelListener) {
        if (this.spatialFunctionPanelListeners != null && this.spatialFunctionPanelListeners.contains(spatialFunctionPanelListener)) {
            Vector vector = (Vector)this.spatialFunctionPanelListeners.clone();
            vector.removeElement(spatialFunctionPanelListener);
            this.spatialFunctionPanelListeners = vector;
        }
    }

    public synchronized void addSpatialFunctionPanelListener(SpatialFunctionPanelListener spatialFunctionPanelListener) {
        Vector vector;
        Vector vector2 = vector = this.spatialFunctionPanelListeners == null ? new Vector(2) : (Vector)this.spatialFunctionPanelListeners.clone();
        if (!vector.contains(spatialFunctionPanelListener)) {
            vector.addElement(spatialFunctionPanelListener);
            this.spatialFunctionPanelListeners = vector;
        }
    }

    protected void fireFunctionExecuted(SpatialFunctionPanelEvent spatialFunctionPanelEvent) {
        if (this.spatialFunctionPanelListeners != null) {
            Vector vector = this.spatialFunctionPanelListeners;
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                ((SpatialFunctionPanelListener)vector.elementAt(i)).functionExecuted(spatialFunctionPanelEvent);
            }
        }
    }
}

