/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jtstest.testbuilder;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jtstest.testbuilder.geom.GeometryUtil;
import com.vividsolutions.jtstest.testbuilder.model.TestBuilderModel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.SystemColor;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class StatsPanel
extends JPanel {
    TestBuilderModel tbModel = null;
    JScrollPane jScrollPane1 = new JScrollPane();
    JTextArea txtStats = new JTextArea();
    BorderLayout tabPanelLayout = new BorderLayout();

    public StatsPanel() {
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    void jbInit() throws Exception {
        this.setLayout(this.tabPanelLayout);
        this.txtStats.setWrapStyleWord(true);
        this.txtStats.setLineWrap(true);
        this.txtStats.setBackground(SystemColor.control);
        this.add((Component)this.jScrollPane1, "Center");
        this.jScrollPane1.setBorder(BorderFactory.createLoweredBevelBorder());
        this.jScrollPane1.getViewport().add((Component)this.txtStats, null);
    }

    public void setModel(TestBuilderModel testBuilderModel) {
        this.tbModel = testBuilderModel;
    }

    public void refresh() {
        StringBuffer stringBuffer = new StringBuffer();
        this.writeGeomStats("A", this.tbModel.getCurrentTestCaseEdit().getGeometry(0), stringBuffer);
        this.writeGeomStats("B", this.tbModel.getCurrentTestCaseEdit().getGeometry(1), stringBuffer);
        this.writeGeomStats("Result", this.tbModel.getCurrentTestCaseEdit().getResult(), stringBuffer);
        this.setString(stringBuffer.toString());
    }

    private void writeGeomStats(String string, Geometry geometry, StringBuffer stringBuffer) {
        if (geometry == null) {
            return;
        }
        stringBuffer.append(string + " : ");
        stringBuffer.append(GeometryUtil.structureSummary(geometry));
        stringBuffer.append("\n");
        stringBuffer.append("    Length = " + geometry.getLength() + "    Area = " + geometry.getArea() + "\n");
        stringBuffer.append("\n");
    }

    private void setString(String string) {
        this.txtStats.setText(string);
    }
}

