/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jtstest.testbuilder;

import com.vividsolutions.jts.awt.PointTransformation;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.PrecisionModel;
import com.vividsolutions.jts.math.MathUtil;
import com.vividsolutions.jtstest.testbuilder.GeometryEditPanel;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.text.NumberFormat;

public class Viewport
implements PointTransformation {
    private static int INITIAL_VIEW_ORIGIN_X = -10;
    private static int INITIAL_VIEW_ORIGIN_Y = -10;
    private GeometryEditPanel panel;
    private Point2D viewOriginInModel = new Point2D.Double(INITIAL_VIEW_ORIGIN_X, INITIAL_VIEW_ORIGIN_Y);
    private double scale = 1.0;
    private PrecisionModel scalePM = new PrecisionModel(this.scale);
    private NumberFormat scaleFormat;
    private Envelope viewEnvInModel;
    private AffineTransform modelToViewTransform;
    private Point2D.Double srcPt = new Point2D.Double(0.0, 0.0);
    private Point2D.Double destPt = new Point2D.Double(0.0, 0.0);
    private static final double ROUND_ERROR_REMOVAL = 1.0E-8;
    private static final int MIN_GRID_RESOLUTION_PIXELS = 2;

    public Viewport(GeometryEditPanel geometryEditPanel) {
        this.panel = geometryEditPanel;
        this.setScaleNoUpdate(1.0);
    }

    public Envelope getModelEnv() {
        return this.viewEnvInModel;
    }

    public Envelope getViewEnv() {
        return new Envelope(0.0, this.getWidthInView(), 0.0, this.getHeightInView());
    }

    public double getScale() {
        return this.scale;
    }

    public void setScaleNoUpdate(double d) {
        this.scale = Viewport.snapScale(d);
        this.scalePM = new PrecisionModel(this.scale);
        this.scaleFormat = NumberFormat.getInstance();
        int n = (int)MathUtil.log10((double)this.scale);
        if (n < 0) {
            n = 0;
        }
        this.scaleFormat.setMaximumFractionDigits(n);
        this.scaleFormat.setGroupingUsed(false);
    }

    public void setScale(double d) {
        this.setScaleNoUpdate(d);
        this.update();
    }

    public NumberFormat getScaleFormat() {
        return this.scaleFormat;
    }

    private static double snapScale(double d) {
        double d2 = Viewport.snapScaleToSingleDigitPrecision(d);
        return d2;
    }

    private static double snapScaleToSingleDigitPrecision(double d) {
        double d2 = Math.floor(MathUtil.log10((double)d) + 1.0E-8);
        double d3 = Math.pow(10.0, d2);
        int n = (int)(d / d3);
        double d4 = (double)n * d3;
        return d4;
    }

    private static double snapScaleTo_10_2_5(double d) {
        double d2;
        double d3 = Math.floor(MathUtil.log10((double)d) + 1.0E-8);
        double d4 = d2 = Math.pow(10.0, d3);
        if (3.5 * d2 <= d) {
            d4 = 5.0 * d2;
        } else if (2.0 * d2 <= d) {
            d4 = 2.0 * d2;
        }
        return d4;
    }

    public double getViewOriginX() {
        return this.viewOriginInModel.getX();
    }

    public double getViewOriginY() {
        return this.viewOriginInModel.getY();
    }

    public void setViewOrigin(double d, double d2) {
        this.viewOriginInModel = new Point2D.Double(d, d2);
        this.update();
    }

    public boolean intersectsInModel(Envelope envelope) {
        return this.viewEnvInModel.intersects(envelope);
    }

    public Point2D toModel(Point2D point2D) {
        this.srcPt.x = point2D.getX();
        this.srcPt.y = point2D.getY();
        try {
            this.getModelToViewTransform().inverseTransform(this.srcPt, this.destPt);
        }
        catch (NoninvertibleTransformException noninvertibleTransformException) {
            return new Point2D.Double(0.0, 0.0);
        }
        double d = this.scalePM.makePrecise(this.destPt.x);
        double d2 = this.scalePM.makePrecise(this.destPt.y);
        return new Point2D.Double(d, d2);
    }

    public Coordinate toModelCoordinate(Point2D point2D) {
        Point2D point2D2 = this.toModel(point2D);
        return new Coordinate(point2D2.getX(), point2D2.getY());
    }

    public void transform(Coordinate coordinate, Point2D point2D) {
        point2D.setLocation(coordinate.x, coordinate.y);
        this.getModelToViewTransform().transform(point2D, point2D);
    }

    public Point2D toView(Coordinate coordinate) {
        Point2D.Double double_ = new Point2D.Double();
        this.transform(coordinate, double_);
        return double_;
    }

    public Point2D toView(Point2D point2D) {
        return this.toView(point2D, new Point2D.Double());
    }

    public Point2D toView(Point2D point2D, Point2D point2D2) {
        return this.getModelToViewTransform().transform(point2D, point2D2);
    }

    public void update() {
        this.updateModelToViewTransform();
        this.viewEnvInModel = this.computeEnvelopeInModel();
        this.panel.forceRepaint();
    }

    private void updateModelToViewTransform() {
        this.modelToViewTransform = new AffineTransform();
        this.modelToViewTransform.translate(0.0, this.panel.getSize().height);
        this.modelToViewTransform.scale(1.0, -1.0);
        this.modelToViewTransform.scale(this.scale, this.scale);
        this.modelToViewTransform.translate(-this.viewOriginInModel.getX(), -this.viewOriginInModel.getY());
    }

    public AffineTransform getModelToViewTransform() {
        if (this.modelToViewTransform == null) {
            this.updateModelToViewTransform();
        }
        return this.modelToViewTransform;
    }

    public void zoomToInitialExtent() {
        this.setScale(1.0);
        this.setViewOrigin(INITIAL_VIEW_ORIGIN_X, INITIAL_VIEW_ORIGIN_Y);
    }

    public void zoom(Envelope envelope) {
        this.zoomToInitialExtent();
        double d = this.getWidthInModel() / envelope.getWidth();
        double d2 = this.getHeightInModel() / envelope.getHeight();
        this.setScale(Math.min(d, d2));
        double d3 = (this.getWidthInModel() - envelope.getWidth()) / 2.0;
        double d4 = (this.getHeightInModel() - envelope.getHeight()) / 2.0;
        this.setViewOrigin(envelope.getMinX() - d3, envelope.getMinY() - d4);
    }

    public double getWidthInModel() {
        return this.getUpperRightCornerInModel().getX() - this.getLowerLeftCornerInModel().getX();
    }

    public double getHeightInModel() {
        return this.getUpperRightCornerInModel().getY() - this.getLowerLeftCornerInModel().getY();
    }

    public Point2D getLowerLeftCornerInModel() {
        Dimension dimension = this.panel.getSize();
        return this.toModel(new Point(0, dimension.height));
    }

    public Point2D getUpperRightCornerInModel() {
        Dimension dimension = this.panel.getSize();
        return this.toModel(new Point(dimension.width, 0));
    }

    public double getHeightInView() {
        return this.panel.getSize().height;
    }

    public double getWidthInView() {
        return this.panel.getSize().getWidth();
    }

    public double toModel(double d) {
        return d / this.scale;
    }

    public double toView(double d) {
        return d * this.scale;
    }

    private Envelope computeEnvelopeInModel() {
        double d = (double)this.panel.getWidth() / this.scale;
        double d2 = (double)this.panel.getHeight() / this.scale;
        return new Envelope(this.viewOriginInModel.getX(), this.viewOriginInModel.getX() + d, this.viewOriginInModel.getY(), this.viewOriginInModel.getY() + d2);
    }

    public boolean containsInModel(Coordinate coordinate) {
        return this.viewEnvInModel.contains(coordinate);
    }

    public int gridMagnitudeModel() {
        double d = this.toModel(1.0);
        double d2 = MathUtil.log10((double)d);
        int n = (int)Math.ceil(d2);
        double d3 = Math.pow(10.0, n);
        double d4 = this.toView(d3);
        if (d4 <= 2.0) {
            ++n;
        }
        return n;
    }

    public PrecisionModel getGridPrecisionModel() {
        double d = this.getGridSizeModel();
        return new PrecisionModel(1.0 / d);
    }

    public double getGridSizeModel() {
        return Math.pow(10.0, this.gridMagnitudeModel());
    }
}

