/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jtstest.testbuilder.controller;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jtstest.testbuilder.JTSTestBuilderFrame;
import com.vividsolutions.jtstest.testbuilder.model.LayerList;
import com.vividsolutions.jtstest.testbuilder.ui.SwingUtil;

public class JTSTestBuilderController {
    public static void geometryViewChanged() {
        JTSTestBuilderFrame.getGeometryEditPanel().updateView();
    }

    public static void extractComponentsToTestCase(Coordinate coordinate) {
        double d = JTSTestBuilderFrame.getGeometryEditPanel().getToleranceInModel();
        LayerList layerList = JTSTestBuilderFrame.instance().getModel().getLayers();
        Geometry geometry = layerList.getComponent(coordinate, d);
        if (geometry == null) {
            return;
        }
        JTSTestBuilderFrame.instance().getModel().addCase(new Geometry[]{geometry, null});
        JTSTestBuilderFrame.instance().updateTestCases();
    }

    public static void extractComponentsToTestCase(Geometry geometry) {
        LayerList layerList = JTSTestBuilderFrame.instance().getModel().getLayers();
        Geometry[] geometryArray = layerList.getComponents(geometry);
        if (geometryArray == null) {
            return;
        }
        JTSTestBuilderFrame.instance().getModel().addCase(geometryArray);
        JTSTestBuilderFrame.instance().updateTestCases();
    }

    public static void copyComponentToClipboard(Coordinate coordinate) {
        double d = JTSTestBuilderFrame.getGeometryEditPanel().getToleranceInModel();
        LayerList layerList = JTSTestBuilderFrame.instance().getModel().getLayers();
        Geometry geometry = layerList.getComponent(coordinate, d);
        if (geometry == null) {
            return;
        }
        SwingUtil.copyToClipboard(geometry, false);
    }
}

