/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jtstest.testbuilder.geom;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.CoordinateArrays;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LinearRing;
import com.vividsolutions.jts.geom.util.GeometryEditor;

public class GeometryBoxDeleter {
    public static Geometry delete(Geometry geometry, Envelope envelope) {
        Geometry geometry2 = GeometryBoxDeleter.deleteComponents(geometry, envelope);
        if (geometry2 != null) {
            return geometry2;
        }
        Geometry geometry3 = GeometryBoxDeleter.deleteVertices(geometry, envelope);
        if (geometry3 != null) {
            return geometry3;
        }
        return geometry;
    }

    private static Geometry deleteComponents(Geometry geometry, Envelope envelope) {
        GeometryEditor geometryEditor = new GeometryEditor();
        BoxDeleteComponentOperation boxDeleteComponentOperation = new BoxDeleteComponentOperation(envelope);
        Geometry geometry2 = geometryEditor.edit(geometry, (GeometryEditor.GeometryEditorOperation)boxDeleteComponentOperation);
        if (boxDeleteComponentOperation.isEdited()) {
            return geometry2;
        }
        return null;
    }

    private static Geometry deleteVertices(Geometry geometry, Envelope envelope) {
        GeometryEditor geometryEditor = new GeometryEditor();
        BoxDeleteVertexOperation boxDeleteVertexOperation = new BoxDeleteVertexOperation(envelope);
        Geometry geometry2 = geometryEditor.edit(geometry, (GeometryEditor.GeometryEditorOperation)boxDeleteVertexOperation);
        if (boxDeleteVertexOperation.isEdited()) {
            return geometry2;
        }
        return null;
    }

    private static class BoxDeleteVertexOperation
    extends GeometryEditor.CoordinateOperation {
        private Envelope env;
        private boolean isEdited = false;

        public BoxDeleteVertexOperation(Envelope envelope) {
            this.env = envelope;
        }

        public boolean isEdited() {
            return this.isEdited;
        }

        public Coordinate[] edit(Coordinate[] coordinateArray, Geometry geometry) {
            Coordinate[] coordinateArray2;
            if (this.isEdited) {
                return coordinateArray;
            }
            if (!this.hasVertexInBox(coordinateArray)) {
                return coordinateArray;
            }
            int n = 2;
            if (geometry instanceof LinearRing) {
                n = 4;
            }
            Coordinate[] coordinateArray3 = new Coordinate[coordinateArray.length];
            int n2 = 0;
            for (int i = 0; i < coordinateArray.length; ++i) {
                if (this.env.contains(coordinateArray[i])) continue;
                coordinateArray3[n2++] = coordinateArray[i];
            }
            Coordinate[] coordinateArray4 = coordinateArray2 = CoordinateArrays.removeNull((Coordinate[])coordinateArray3);
            if (geometry instanceof LinearRing && coordinateArray2.length > 1 && !coordinateArray2[coordinateArray2.length - 1].equals2D(coordinateArray2[0])) {
                Coordinate[] coordinateArray5 = new Coordinate[coordinateArray2.length + 1];
                CoordinateArrays.copyDeep((Coordinate[])coordinateArray2, (int)0, (Coordinate[])coordinateArray5, (int)0, (int)coordinateArray2.length);
                coordinateArray5[coordinateArray5.length - 1] = new Coordinate(coordinateArray5[0]);
                coordinateArray4 = coordinateArray5;
            }
            if (coordinateArray4.length < n) {
                return coordinateArray;
            }
            this.isEdited = true;
            return coordinateArray4;
        }

        private boolean hasVertexInBox(Coordinate[] coordinateArray) {
            for (int i = 0; i < coordinateArray.length; ++i) {
                if (!this.env.contains(coordinateArray[i])) continue;
                return true;
            }
            return false;
        }
    }

    private static class BoxDeleteComponentOperation
    implements GeometryEditor.GeometryEditorOperation {
        private Envelope env;
        private boolean isEdited = false;

        public BoxDeleteComponentOperation(Envelope envelope) {
            this.env = envelope;
        }

        public boolean isEdited() {
            return this.isEdited;
        }

        public Geometry edit(Geometry geometry, GeometryFactory geometryFactory) {
            if (this.env.contains(geometry.getEnvelopeInternal())) {
                this.isEdited = true;
                return null;
            }
            return geometry;
        }
    }
}

