/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jtstest.testbuilder.io.shapefile;

import com.vividsolutions.jts.algorithm.CGAlgorithms;
import com.vividsolutions.jts.algorithm.RobustCGAlgorithms;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LinearRing;
import com.vividsolutions.jts.geom.MultiPolygon;
import com.vividsolutions.jts.geom.Polygon;
import com.vividsolutions.jts.geom.PrecisionModel;
import com.vividsolutions.jtstest.testbuilder.io.shapefile.EndianDataInputStream;
import com.vividsolutions.jtstest.testbuilder.io.shapefile.InvalidShapefileException;
import com.vividsolutions.jtstest.testbuilder.io.shapefile.ShapeHandler;
import java.io.IOException;
import java.lang.reflect.Array;
import java.util.ArrayList;

public class PolygonHandler
implements ShapeHandler {
    protected static CGAlgorithms cga = new RobustCGAlgorithms();
    int myShapeType;

    public PolygonHandler() {
        this.myShapeType = 5;
    }

    public PolygonHandler(int n) throws InvalidShapefileException {
        if (n != 5 && n != 15 && n != 25) {
            throw new InvalidShapefileException("PolygonHandler constructor - expected type to be 5, 15, or 25.");
        }
        this.myShapeType = n;
    }

    boolean pointInList(Coordinate coordinate, Coordinate[] coordinateArray) {
        int n = Array.getLength(coordinateArray);
        for (int i = 0; i < n; ++i) {
            Coordinate coordinate2 = coordinateArray[i];
            if (coordinate.x != coordinate2.x || coordinate.y != coordinate2.y || coordinate.z != coordinate2.z && coordinate.z == coordinate.z) continue;
            return true;
        }
        return false;
    }

    public Geometry read(EndianDataInputStream endianDataInputStream, GeometryFactory geometryFactory, int n) throws IOException, InvalidShapefileException {
        Polygon[] polygonArray;
        int n2;
        int n3;
        int n4 = 0;
        int n5 = endianDataInputStream.readIntLE();
        n4 += 2;
        if (n5 == 0) {
            return new MultiPolygon(null, new PrecisionModel(), 0);
        }
        if (n5 != this.myShapeType) {
            throw new InvalidShapefileException("PolygonHandler.read() - got shape type " + n5 + " but was expecting " + this.myShapeType);
        }
        endianDataInputStream.readDoubleLE();
        endianDataInputStream.readDoubleLE();
        endianDataInputStream.readDoubleLE();
        endianDataInputStream.readDoubleLE();
        n4 += 16;
        int n6 = endianDataInputStream.readIntLE();
        int n7 = endianDataInputStream.readIntLE();
        n4 += 4;
        int[] nArray = new int[n6];
        for (int i = 0; i < n6; ++i) {
            nArray[i] = endianDataInputStream.readIntLE();
            n4 += 2;
        }
        ArrayList<LinearRing> arrayList = new ArrayList<LinearRing>();
        ArrayList<LinearRing> arrayList2 = new ArrayList<LinearRing>();
        Coordinate[] coordinateArray = new Coordinate[n7];
        for (n3 = 0; n3 < n7; ++n3) {
            coordinateArray[n3] = new Coordinate(endianDataInputStream.readDoubleLE(), endianDataInputStream.readDoubleLE());
            n4 += 8;
        }
        if (this.myShapeType == 15) {
            endianDataInputStream.readDoubleLE();
            endianDataInputStream.readDoubleLE();
            n4 += 8;
            for (n3 = 0; n3 < n7; ++n3) {
                coordinateArray[n3].z = endianDataInputStream.readDoubleLE();
                n4 += 4;
            }
        }
        if (this.myShapeType >= 15 && n >= (n3 = this.myShapeType == 15 ? 22 + 2 * n6 + 8 * n7 + 8 + 4 * n7 + 8 + 4 * n7 : 22 + 2 * n6 + 8 * n7 + 8 + 4 * n7)) {
            endianDataInputStream.readDoubleLE();
            endianDataInputStream.readDoubleLE();
            n4 += 8;
            for (n2 = 0; n2 < n7; ++n2) {
                endianDataInputStream.readDoubleLE();
                n4 += 4;
            }
        }
        while (n4 < n) {
            n3 = endianDataInputStream.readShortBE();
            ++n4;
        }
        n3 = 0;
        for (int i = 0; i < n6; ++i) {
            n2 = nArray[i];
            int n8 = i == n6 - 1 ? n7 : nArray[i + 1];
            int n9 = n8 - n2;
            polygonArray = new Coordinate[n9];
            for (int j = 0; j < n9; ++j) {
                polygonArray[j] = coordinateArray[n3];
                ++n3;
            }
            LinearRing linearRing = geometryFactory.createLinearRing((Coordinate[])polygonArray);
            if (CGAlgorithms.isCCW((Coordinate[])polygonArray)) {
                arrayList2.add(linearRing);
                continue;
            }
            arrayList.add(linearRing);
        }
        ArrayList arrayList3 = this.assignHolesToShells(arrayList, arrayList2);
        polygonArray = new Polygon[arrayList.size()];
        for (int i = 0; i < arrayList.size(); ++i) {
            polygonArray[i] = geometryFactory.createPolygon((LinearRing)arrayList.get(i), ((ArrayList)arrayList3.get(i)).toArray(new LinearRing[0]));
        }
        if (polygonArray.length == 1) {
            return polygonArray[0];
        }
        arrayList3 = null;
        arrayList = null;
        arrayList2 = null;
        MultiPolygon multiPolygon = geometryFactory.createMultiPolygon(polygonArray);
        return multiPolygon;
    }

    private ArrayList assignHolesToShells(ArrayList arrayList, ArrayList arrayList2) {
        int n;
        ArrayList arrayList3 = new ArrayList(arrayList.size());
        for (n = 0; n < arrayList.size(); ++n) {
            arrayList3.add(new ArrayList());
        }
        for (n = 0; n < arrayList2.size(); ++n) {
            LinearRing linearRing = (LinearRing)arrayList2.get(n);
            LinearRing linearRing2 = null;
            Envelope envelope = null;
            Envelope envelope2 = linearRing.getEnvelopeInternal();
            Coordinate coordinate = linearRing.getCoordinateN(0);
            int n2 = arrayList.size();
            for (int i = 0; i < n2; ++i) {
                LinearRing linearRing3 = (LinearRing)arrayList.get(i);
                Envelope envelope3 = linearRing3.getEnvelopeInternal();
                if (!envelope3.contains(envelope2)) continue;
                boolean bl = false;
                Coordinate[] coordinateArray = linearRing3.getCoordinates();
                if (n2 <= 1 || CGAlgorithms.isPointInRing((Coordinate)coordinate, (Coordinate[])coordinateArray) || this.pointInList(coordinate, coordinateArray)) {
                    bl = true;
                }
                if (linearRing2 != null) {
                    envelope = linearRing2.getEnvelopeInternal();
                }
                if (!bl || linearRing2 != null && !envelope.contains(envelope3)) continue;
                linearRing2 = linearRing3;
            }
            if (linearRing2 == null) {
                System.err.println("Found polygon with a hole not inside a shell");
                continue;
            }
            ((ArrayList)arrayList3.get(PolygonHandler.findIndex(arrayList, linearRing2))).add(linearRing);
        }
        return arrayList3;
    }

    private static int findIndex(ArrayList arrayList, Object object) {
        int n = arrayList.size();
        for (int i = 0; i < n; ++i) {
            if (arrayList.get(i) != object) continue;
            return i;
        }
        return -1;
    }

    public int getShapeType() {
        return this.myShapeType;
    }

    public int getLength(Geometry geometry) {
        int n;
        MultiPolygon multiPolygon = geometry instanceof MultiPolygon ? (MultiPolygon)geometry : new MultiPolygon(new Polygon[]{(Polygon)geometry}, geometry.getPrecisionModel(), geometry.getSRID());
        int n2 = 0;
        for (n = 0; n < multiPolygon.getNumGeometries(); ++n) {
            Polygon polygon = (Polygon)multiPolygon.getGeometryN(n);
            n2 = n2 + 1 + polygon.getNumInteriorRing();
        }
        n = multiPolygon.getNumPoints();
        if (this.myShapeType == 15) {
            return 22 + 2 * n2 + 8 * n + 4 * n + 8 + 4 * n + 8;
        }
        if (this.myShapeType == 25) {
            return 22 + 2 * n2 + 8 * n + 4 * n + 8;
        }
        return 22 + 2 * n2 + 8 * n;
    }

    double[] zMinMax(Geometry geometry) {
        boolean bl = false;
        Coordinate[] coordinateArray = geometry.getCoordinates();
        double[] dArray = new double[2];
        double d = Double.NaN;
        double d2 = Double.NaN;
        for (int i = 0; i < coordinateArray.length; ++i) {
            double d3 = coordinateArray[i].z;
            if (Double.isNaN(d3)) continue;
            if (bl) {
                if (d3 < d) {
                    d = d3;
                }
                if (!(d3 > d2)) continue;
                d2 = d3;
                continue;
            }
            bl = true;
            d = d3;
            d2 = d3;
        }
        dArray[0] = d;
        dArray[1] = d2;
        return dArray;
    }
}

