/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jtstest.testbuilder.model;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.io.WKTWriter;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;

public class GeometryTransferable
implements Transferable {
    public static final DataFlavor GEOMETRY_FLAVOR = new DataFlavor(Geometry.class, "Geometry");
    private Geometry geom;
    private boolean isFormatted;
    private static final DataFlavor[] flavors = new DataFlavor[]{DataFlavor.stringFlavor, GEOMETRY_FLAVOR};

    public GeometryTransferable(Geometry geometry) {
        this.geom = geometry;
    }

    public GeometryTransferable(Geometry geometry, boolean bl) {
        this.geom = geometry;
        this.isFormatted = bl;
    }

    public DataFlavor[] getTransferDataFlavors() {
        return flavors;
    }

    public boolean isDataFlavorSupported(DataFlavor dataFlavor) {
        for (int i = 0; i < flavors.length; ++i) {
            if (!dataFlavor.equals(flavors[i])) continue;
            return true;
        }
        return false;
    }

    public Object getTransferData(DataFlavor dataFlavor) throws UnsupportedFlavorException, IOException {
        if (dataFlavor.equals(GEOMETRY_FLAVOR)) {
            return this.geom;
        }
        if (dataFlavor.equals(DataFlavor.stringFlavor)) {
            if (this.isFormatted) {
                WKTWriter wKTWriter = new WKTWriter();
                wKTWriter.setFormatted(true);
                wKTWriter.setMaxCoordinatesPerLine(5);
                String string = wKTWriter.writeFormatted(this.geom);
                return string;
            }
            return this.geom.toString();
        }
        throw new UnsupportedFlavorException(dataFlavor);
    }
}

