/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jtstest.testbuilder.model;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jtstest.testbuilder.Viewport;
import com.vividsolutions.jtstest.testbuilder.model.GeometryContainer;
import com.vividsolutions.jtstest.testbuilder.model.TestBuilderModel;
import com.vividsolutions.jtstest.testbuilder.ui.ColorUtil;
import com.vividsolutions.jtstest.testbuilder.ui.render.GeometryPainter;
import com.vividsolutions.jtstest.testbuilder.ui.style.ArrowEndpointStyle;
import com.vividsolutions.jtstest.testbuilder.ui.style.ArrowLineStyle;
import com.vividsolutions.jtstest.testbuilder.ui.style.BasicStyle;
import com.vividsolutions.jtstest.testbuilder.ui.style.CircleEndpointStyle;
import com.vividsolutions.jtstest.testbuilder.ui.style.PolygonStructureStyle;
import com.vividsolutions.jtstest.testbuilder.ui.style.SegmentIndexStyle;
import com.vividsolutions.jtstest.testbuilder.ui.style.Style;
import com.vividsolutions.jtstest.testbuilder.ui.style.StyleList;
import com.vividsolutions.jtstest.testbuilder.ui.style.VertexStyle;
import java.awt.Graphics2D;

public class Layer {
    private String name = "";
    private GeometryContainer geomCont;
    private boolean isEnabled = true;
    private BasicStyle style = new BasicStyle();
    private StyleList styleList;
    private StyleList.StyleFilter vertexFilter = new StyleList.StyleFilter(){

        public boolean isFiltered(Style style) {
            return !TestBuilderModel.isShowingVertices();
        }
    };
    private StyleList.StyleFilter decorationFilter = new StyleList.StyleFilter(){

        public boolean isFiltered(Style style) {
            return !TestBuilderModel.isShowingOrientation();
        }
    };
    private StyleList.StyleFilter structureFilter = new StyleList.StyleFilter(){

        public boolean isFiltered(Style style) {
            return !TestBuilderModel.isShowingStructure();
        }
    };

    public Layer(String string) {
        this.name = string;
    }

    public String getName() {
        return this.name;
    }

    public void setEnabled(boolean bl) {
        this.isEnabled = bl;
    }

    public void setSource(GeometryContainer geometryContainer) {
        this.geomCont = geometryContainer;
    }

    public GeometryContainer getSource() {
        return this.geomCont;
    }

    public boolean isEnabled() {
        return this.isEnabled;
    }

    public StyleList getStyles() {
        return this.styleList;
    }

    public void setStyle(BasicStyle basicStyle) {
        this.style = basicStyle;
        VertexStyle vertexStyle = new VertexStyle(basicStyle.getLineColor());
        ArrowLineStyle arrowLineStyle = new ArrowLineStyle(ColorUtil.lighter(basicStyle.getLineColor(), 0.8));
        ArrowEndpointStyle arrowEndpointStyle = new ArrowEndpointStyle(ColorUtil.lighter(basicStyle.getLineColor()), false, true);
        CircleEndpointStyle circleEndpointStyle = new CircleEndpointStyle(basicStyle.getLineColor(), true, false);
        PolygonStructureStyle polygonStructureStyle = new PolygonStructureStyle(ColorUtil.opaque(basicStyle.getLineColor()));
        SegmentIndexStyle segmentIndexStyle = new SegmentIndexStyle(ColorUtil.opaque(basicStyle.getLineColor().darker()));
        this.styleList = new StyleList();
        this.styleList.add(vertexStyle, this.vertexFilter);
        this.styleList.add(arrowLineStyle, this.decorationFilter);
        this.styleList.add(arrowEndpointStyle, this.decorationFilter);
        this.styleList.add(circleEndpointStyle, this.decorationFilter);
        this.styleList.add(basicStyle);
        this.styleList.add(polygonStructureStyle, this.structureFilter);
        this.styleList.add(segmentIndexStyle, this.structureFilter);
    }

    public Geometry getGeometry() {
        if (this.geomCont == null) {
            return null;
        }
        return this.geomCont.getGeometry();
    }

    public void paint(Graphics2D graphics2D, Viewport viewport) {
        if (!this.isEnabled) {
            return;
        }
        if (this.geomCont == null) {
            return;
        }
        try {
            Geometry geometry = this.geomCont.getGeometry();
            if (geometry == null) {
                return;
            }
            if (!viewport.intersectsInModel(geometry.getEnvelopeInternal())) {
                return;
            }
            GeometryPainter.paint(graphics2D, viewport, geometry, this.styleList);
        }
        catch (Exception exception) {
            System.out.println("Exception in Layer.paint(): " + exception);
        }
    }
}

