/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jtstest.testbuilder.model;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jtstest.testbuilder.geom.ComponentLocater;
import com.vividsolutions.jtstest.testbuilder.geom.GeometryLocation;
import com.vividsolutions.jtstest.testbuilder.model.Layer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class LayerList {
    public static final int LYR_A = 0;
    public static final int LYR_B = 1;
    public static final int LYR_RESULT = 2;
    private Layer[] layer = new Layer[3];

    public LayerList() {
        this.layer[0] = new Layer("A");
        this.layer[1] = new Layer("B");
        this.layer[2] = new Layer("Result");
    }

    public int size() {
        return this.layer.length;
    }

    public Layer getLayer(int n) {
        return this.layer[n];
    }

    public Geometry getComponent(Coordinate coordinate, double d) {
        for (int i = 0; i < this.size(); ++i) {
            ComponentLocater componentLocater;
            List list;
            Layer layer = this.getLayer(i);
            Geometry geometry = layer.getGeometry();
            if (geometry == null || (list = (componentLocater = new ComponentLocater(geometry)).getComponents(coordinate, d)).size() <= 0) continue;
            GeometryLocation geometryLocation = (GeometryLocation)list.get(0);
            return geometryLocation.getComponent();
        }
        return null;
    }

    public Geometry[] getComponents(Geometry geometry) {
        Geometry[] geometryArray = new Geometry[2];
        for (int i = 0; i < 2; ++i) {
            Layer layer = this.getLayer(i);
            Geometry geometry2 = layer.getGeometry();
            if (geometry2 == null) continue;
            geometryArray[i] = this.extractComponents(geometry2, geometry);
        }
        return geometryArray;
    }

    private Geometry extractComponents(Geometry geometry, Geometry geometry2) {
        ComponentLocater componentLocater = new ComponentLocater(geometry);
        List list = componentLocater.getComponents(geometry2);
        List list2 = this.extractLocationGeometry(list);
        if (list2.size() <= 0) {
            return null;
        }
        if (list2.size() == 1) {
            return (Geometry)list2.get(0);
        }
        if (geometry.getGeometryType().equals("GeometryCollection")) {
            return geometry.getFactory().createGeometryCollection(GeometryFactory.toGeometryArray((Collection)list2));
        }
        return geometry.getFactory().buildGeometry((Collection)list2);
    }

    private List extractLocationGeometry(List list) {
        ArrayList<Geometry> arrayList = new ArrayList<Geometry>();
        for (GeometryLocation geometryLocation : list) {
            arrayList.add(geometryLocation.getComponent());
        }
        return arrayList;
    }
}

