/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jtstest.testbuilder.topostretch;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.CoordinateFilter;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryComponentFilter;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.util.LinearComponentExtracter;
import com.vividsolutions.jtstest.testbuilder.topostretch.GeometryVerticesMover;
import com.vividsolutions.jtstest.testbuilder.topostretch.StretchedVertex;
import com.vividsolutions.jtstest.testbuilder.topostretch.StretchedVertexFinder;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class TopologyStretcher {
    private double stretchDistance = 0.1;
    private Geometry[] inputGeoms;
    private List linestrings;
    private List[] modifiedCoords;

    public TopologyStretcher(Geometry geometry) {
        this.inputGeoms = new Geometry[1];
        this.inputGeoms[0] = geometry;
    }

    public TopologyStretcher(Geometry geometry, Geometry geometry2) {
        this.inputGeoms = new Geometry[2];
        this.inputGeoms[0] = geometry;
        this.inputGeoms[1] = geometry2;
    }

    public int numVerticesInMask(Envelope envelope) {
        VertexInMaskCountCoordinateFilter vertexInMaskCountCoordinateFilter = new VertexInMaskCountCoordinateFilter(envelope);
        if (this.inputGeoms[0] != null) {
            this.inputGeoms[0].apply((CoordinateFilter)vertexInMaskCountCoordinateFilter);
        }
        if (this.inputGeoms[1] != null) {
            this.inputGeoms[1].apply((CoordinateFilter)vertexInMaskCountCoordinateFilter);
        }
        return vertexInMaskCountCoordinateFilter.getCount();
    }

    public Geometry[] stretch(double d, double d2) {
        return this.stretch(d, d2, null);
    }

    public Geometry[] stretch(double d, double d2, Envelope envelope) {
        this.stretchDistance = d2;
        this.linestrings = this.extractLineStrings(this.inputGeoms, envelope);
        List list = StretchedVertexFinder.findNear(this.linestrings, d, envelope);
        Map map = this.getCoordinateMoves(list);
        Geometry[] geometryArray = new Geometry[this.inputGeoms.length];
        this.modifiedCoords = new List[this.inputGeoms.length];
        for (int i = 0; i < this.inputGeoms.length; ++i) {
            Geometry geometry;
            Geometry geometry2 = this.inputGeoms[i];
            if (geometry2 == null) continue;
            GeometryVerticesMover geometryVerticesMover = new GeometryVerticesMover(geometry2, map);
            geometryArray[i] = geometry = geometryVerticesMover.move();
            this.modifiedCoords[i] = geometryVerticesMover.getModifiedCoordinates();
        }
        return geometryArray;
    }

    public List[] getModifiedCoordinates() {
        return this.modifiedCoords;
    }

    private List extractLineStrings(Geometry[] geometryArray, Envelope envelope) {
        ArrayList arrayList = new ArrayList();
        LinearComponentExtracter linearComponentExtracter = new LinearComponentExtracter(arrayList);
        for (int i = 0; i < geometryArray.length; ++i) {
            if (geometryArray[i] == null || envelope != null && !envelope.intersects(geometryArray[i].getEnvelopeInternal())) continue;
            geometryArray[i].apply((GeometryComponentFilter)linearComponentExtracter);
        }
        if (envelope != null) {
            ArrayList<LineString> arrayList2 = new ArrayList<LineString>();
            for (LineString lineString : arrayList) {
                if (!envelope.intersects(lineString.getEnvelopeInternal())) continue;
                arrayList2.add(lineString);
            }
            return arrayList2;
        }
        return arrayList;
    }

    private Map getCoordinateMoves(List list) {
        TreeMap<Coordinate, Coordinate> treeMap = new TreeMap<Coordinate, Coordinate>();
        for (StretchedVertex stretchedVertex : list) {
            Coordinate coordinate = stretchedVertex.getVertexCoordinate();
            Coordinate coordinate2 = stretchedVertex.getStretchedVertex(this.stretchDistance);
            if (coordinate2.equals2D(coordinate)) continue;
            treeMap.put(coordinate, coordinate2);
        }
        return treeMap;
    }

    private static class VertexInMaskCountCoordinateFilter
    implements CoordinateFilter {
        private Envelope mask;
        private int count = 0;

        public VertexInMaskCountCoordinateFilter(Envelope envelope) {
            this.mask = envelope;
        }

        public void filter(Coordinate coordinate) {
            if (this.mask.contains(coordinate)) {
                ++this.count;
            }
        }

        public int getCount() {
            return this.count;
        }
    }
}

