/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jtstest.testbuilder.ui.tools;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.PrecisionModel;
import com.vividsolutions.jtstest.testbuilder.AppConstants;
import com.vividsolutions.jtstest.testbuilder.GeometryEditPanel;
import com.vividsolutions.jtstest.testbuilder.JTSTestBuilder;
import com.vividsolutions.jtstest.testbuilder.JTSTestBuilderFrame;
import com.vividsolutions.jtstest.testbuilder.Viewport;
import com.vividsolutions.jtstest.testbuilder.model.GeometryEditModel;
import com.vividsolutions.jtstest.testbuilder.ui.tools.Tool;
import java.awt.Cursor;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;

public abstract class BasicTool
implements Tool {
    protected Cursor cursor = Cursor.getDefaultCursor();
    private PrecisionModel gridPM;

    protected Graphics2D getGraphics2D() {
        Graphics2D graphics2D = (Graphics2D)this.panel().getGraphics();
        if (graphics2D != null) {
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        }
        return graphics2D;
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mouseDragged(MouseEvent mouseEvent) {
    }

    public void mouseMoved(MouseEvent mouseEvent) {
    }

    public Cursor getCursor() {
        return this.cursor;
    }

    public void activate() {
        this.gridPM = this.getViewport().getGridPrecisionModel();
    }

    protected GeometryEditPanel panel() {
        return JTSTestBuilderFrame.instance().getTestCasePanel().getGeometryEditPanel();
    }

    protected GeometryEditModel geomModel() {
        return JTSTestBuilder.model().getGeometryEditModel();
    }

    private Viewport getViewport() {
        return this.panel().getViewport();
    }

    Point2D toView(Coordinate coordinate) {
        return this.getViewport().toView(coordinate);
    }

    double toView(double d) {
        return this.getViewport().toView(d);
    }

    Point2D toModel(Point point) {
        return this.getViewport().toModel(point);
    }

    Coordinate toModelCoordinate(Point point) {
        return this.getViewport().toModelCoordinate(point);
    }

    double toModel(double d) {
        return d / this.getViewport().getScale();
    }

    double getModelSnapTolerance() {
        return this.toModel(AppConstants.TOLERANCE_PIXELS);
    }

    protected Coordinate toModelSnapped(Point2D point2D) {
        return this.toModelSnappedIfCloseToViewGrid(point2D);
    }

    protected Coordinate toModelSnappedToViewGrid(Point2D point2D) {
        Coordinate coordinate = this.getViewport().toModelCoordinate(point2D);
        this.gridPM.makePrecise(coordinate);
        return coordinate;
    }

    protected Coordinate toModelSnappedIfCloseToViewGrid(Point2D point2D) {
        Coordinate coordinate = this.getViewport().toModelCoordinate(point2D);
        Coordinate coordinate2 = new Coordinate(coordinate);
        this.gridPM.makePrecise(coordinate2);
        double d = this.getModelSnapTolerance();
        if (coordinate.distance(coordinate2) <= d) {
            return coordinate2;
        }
        return coordinate;
    }

    protected double gridSize() {
        return this.getViewport().getGridSizeModel();
    }
}

