/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jtstest.testbuilder.ui.tools;

import com.vividsolutions.jts.awt.GeometryCollectionShape;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jtstest.testbuilder.AppCursors;
import com.vividsolutions.jtstest.testbuilder.geom.GeometryLocation;
import com.vividsolutions.jtstest.testbuilder.ui.tools.IndicatorTool;
import java.awt.Shape;
import java.awt.event.MouseEvent;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import javax.swing.SwingUtilities;

public class EditVertexTool
extends IndicatorTool {
    private static EditVertexTool instance = null;
    Coordinate currentVertexLoc = null;
    private Coordinate selectedVertexLocation = null;
    private Coordinate[] adjVertices = null;
    private static final double IND_CIRCLE_RADIUS = 10.0;

    public static EditVertexTool getInstance() {
        if (instance == null) {
            instance = new EditVertexTool();
        }
        return instance;
    }

    private EditVertexTool() {
        this.cursor = AppCursors.EDIT_VERTEX;
    }

    public void mousePressed(MouseEvent mouseEvent) {
        this.currentVertexLoc = null;
        if (SwingUtilities.isRightMouseButton(mouseEvent)) {
            return;
        }
        Coordinate coordinate = this.toModelCoordinate(mouseEvent.getPoint());
        double d = this.getModelSnapTolerance();
        this.selectedVertexLocation = this.geomModel().locateVertexPt(coordinate, d);
        if (this.selectedVertexLocation != null) {
            this.adjVertices = this.geomModel().findAdjacentVertices(this.selectedVertexLocation);
            this.currentVertexLoc = this.selectedVertexLocation;
            this.redrawIndicator();
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        if (SwingUtilities.isRightMouseButton(mouseEvent)) {
            return;
        }
        this.clearIndicator();
        if (this.selectedVertexLocation != null) {
            Coordinate coordinate = this.toModelSnapped(mouseEvent.getPoint());
            this.geomModel().moveVertex(this.selectedVertexLocation, coordinate);
        }
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        this.currentVertexLoc = this.toModelSnapped(mouseEvent.getPoint());
        if (this.selectedVertexLocation != null) {
            this.redrawIndicator();
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        boolean bl;
        if (!SwingUtilities.isRightMouseButton(mouseEvent)) {
            return;
        }
        Coordinate coordinate = this.toModelCoordinate(mouseEvent.getPoint());
        double d = this.getModelSnapTolerance();
        boolean bl2 = bl = !mouseEvent.isControlDown();
        if (bl) {
            GeometryLocation geometryLocation = this.geomModel().locateNonVertexPoint(coordinate, d);
            if (geometryLocation != null) {
                this.geomModel().setGeometry(geometryLocation.insert());
            }
        } else {
            GeometryLocation geometryLocation = this.geomModel().locateVertex(coordinate, d);
            if (geometryLocation != null) {
                this.geomModel().setGeometry(geometryLocation.delete());
            }
        }
    }

    protected Shape getShape() {
        GeometryCollectionShape geometryCollectionShape = new GeometryCollectionShape();
        Point2D point2D = this.toView(this.currentVertexLoc);
        geometryCollectionShape.add(this.getIndicatorCircle(point2D));
        if (this.adjVertices != null) {
            for (int i = 0; i < this.adjVertices.length; ++i) {
                GeneralPath generalPath = new GeneralPath();
                generalPath.moveTo((float)point2D.getX(), (float)point2D.getY());
                Point2D point2D2 = this.toView(this.adjVertices[i]);
                generalPath.lineTo((float)point2D2.getX(), (float)point2D2.getY());
                geometryCollectionShape.add((Shape)generalPath);
            }
        }
        return geometryCollectionShape;
    }

    protected Shape getIndicatorCircle(Point2D point2D) {
        return new Ellipse2D.Double(point2D.getX() - 5.0, point2D.getY() - 5.0, 10.0, 10.0);
    }
}

