/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jtstest.testrunner;

import com.vividsolutions.jtstest.testrunner.Test;
import com.vividsolutions.jtstest.testrunner.TestCase;
import com.vividsolutions.jtstest.testrunner.TestReader;
import com.vividsolutions.jtstest.testrunner.TestRun;
import java.io.File;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Vector;

public class TestEngine
implements Runnable {
    private List testFiles;
    private int testCaseIndexToRun = -1;
    private boolean running = false;
    private List testRuns = new Vector();
    private TestReader testReader = new TestReader();
    private Date start = null;
    private Date end = null;

    public void setTestFiles(List list) {
        this.testFiles = list;
    }

    public void setTestCaseIndexToRun(int n) {
        this.testCaseIndexToRun = n;
    }

    public int getExceptionCount() {
        int n = 0;
        for (Test test : this.getTests()) {
            if (test.getException() == null) continue;
            ++n;
        }
        return n;
    }

    public int getFailedCount() {
        int n = 0;
        for (Test test : this.getTests()) {
            if (test.getException() != null || test.isPassed()) continue;
            ++n;
        }
        return n;
    }

    public int getPassedCount() {
        int n = 0;
        for (Test test : this.getTests()) {
            if (!test.isPassed()) continue;
            ++n;
        }
        return n;
    }

    public int getParseExceptionCount() {
        return this.testReader.getParsingProblems().size();
    }

    public boolean isRunning() {
        return this.running;
    }

    public int getTestCount() {
        int n = 0;
        for (TestRun testRun : this.testRuns) {
            n += testRun.getTestCount();
        }
        return n;
    }

    public int getTestCaseCount() {
        int n = 0;
        for (TestRun testRun : this.testRuns) {
            n += testRun.getTestCases().size();
        }
        return n;
    }

    public List getParsingProblems() {
        return Collections.unmodifiableList(this.testReader.getParsingProblems());
    }

    public List getTestRuns() {
        return this.testRuns;
    }

    public Date getStart() {
        return this.start;
    }

    public Date getEnd() {
        return this.end;
    }

    public void clearParsingProblems() {
        this.testReader.clearParsingProblems();
    }

    public void run() {
        this.running = true;
        this.start = new Date();
        this.clearParsingProblems();
        this.testRuns = this.createTestRuns();
        System.out.println("Running tests...");
        for (TestRun testRun : this.testRuns) {
            if (this.testCaseIndexToRun >= 0) {
                testRun.setTestCaseIndexToRun(this.testCaseIndexToRun);
            }
            testRun.run();
        }
        this.end = new Date();
        this.running = false;
    }

    private List getTests(TestRun testRun) {
        Vector vector = new Vector();
        for (TestCase testCase : testRun.getTestCases()) {
            vector.addAll(testCase.getTests());
        }
        return vector;
    }

    private List getTests() {
        Vector vector = new Vector();
        for (TestRun testRun : this.testRuns) {
            vector.addAll(this.getTests(testRun));
        }
        return vector;
    }

    private List createTestRuns() {
        Vector<TestRun> vector = new Vector<TestRun>();
        int n = 0;
        for (File file : this.testFiles) {
            TestRun testRun;
            System.out.println("Reading test file " + file.getAbsolutePath());
            if ((testRun = this.testReader.createTestRun(file, ++n)) == null) continue;
            vector.add(testRun);
        }
        return vector;
    }
}

