/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jtstest.util;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.RandomAccessFile;
import java.util.List;
import java.util.Vector;

public class FileUtil {
    public static final String EXTENSION_SEPARATOR = ".";

    public static String name(String string) {
        File file = new File(string);
        return file.getName();
    }

    public static String extension(String string) {
        String string2 = FileUtil.name(string);
        int n = string2.lastIndexOf(EXTENSION_SEPARATOR.charAt(0));
        if (n < 0) {
            return "";
        }
        return string2.substring(n, string2.length());
    }

    public static void deleteFiles(String string) {
        File file = new File(string);
        File[] fileArray = file.listFiles();
        for (int i = 0; i < fileArray.length; ++i) {
            fileArray[i].delete();
        }
    }

    public static boolean directoryExists(String string) {
        File file = new File(string);
        return file.exists();
    }

    public static List getContents(String string) throws FileNotFoundException, IOException {
        Vector<String> vector = new Vector<String>();
        FileReader fileReader = new FileReader(string);
        BufferedReader bufferedReader = new BufferedReader(fileReader);
        String string2 = bufferedReader.readLine();
        while (string2 != null) {
            vector.add(string2);
            string2 = bufferedReader.readLine();
        }
        return vector;
    }

    public static String readText(String string) throws IOException {
        return FileUtil.readText(new File(string));
    }

    public static String readText(File file) throws IOException {
        String string;
        StringBuffer stringBuffer = new StringBuffer("");
        FileInputStream fileInputStream = new FileInputStream(file);
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(fileInputStream));
        while ((string = bufferedReader.readLine()) != null) {
            stringBuffer.append(string + "\r\n");
        }
        String string2 = stringBuffer.toString();
        return string2;
    }

    public static void setContents(String string, String string2) throws IOException {
        FileWriter fileWriter = new FileWriter(string, false);
        BufferedWriter bufferedWriter = new BufferedWriter(fileWriter);
        bufferedWriter.write(string2);
        bufferedWriter.flush();
        bufferedWriter.close();
        fileWriter.close();
    }

    public static void copyFile(File file, File file2) throws IOException {
        int n;
        RandomAccessFile randomAccessFile = new RandomAccessFile(file2, "rw");
        randomAccessFile.setLength(file.length());
        FileInputStream fileInputStream = new FileInputStream(file);
        byte[] byArray = new byte[16384];
        while ((n = fileInputStream.read(byArray)) != -1) {
            randomAccessFile.write(byArray, 0, n);
        }
        fileInputStream.close();
        randomAccessFile.close();
    }
}

