/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jtstest.util;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.io.ParseException;
import com.vividsolutions.jts.io.WKBReader;
import com.vividsolutions.jts.io.WKTReader;

public class WKTOrWKBReader {
    private static final int MAX_CHARS_TO_CHECK = 6;
    private GeometryFactory geomFactory;
    private WKTReader wktReader;
    private WKBReader wkbReader;

    private static boolean isHex(String string, int n) {
        for (int i = 0; i < n && i < string.length(); ++i) {
            char c = string.charAt(i);
            if (WKTOrWKBReader.isHexDigit(c)) continue;
            return false;
        }
        return true;
    }

    private static boolean isHexDigit(char c) {
        if (Character.isDigit(c)) {
            return true;
        }
        char c2 = Character.toLowerCase(c);
        return c >= 'a' && c <= 'f';
    }

    public WKTOrWKBReader() {
        this(new GeometryFactory());
    }

    public WKTOrWKBReader(GeometryFactory geometryFactory) {
        this.wktReader = new WKTReader(geometryFactory);
        this.wkbReader = new WKBReader(geometryFactory);
    }

    public Geometry read(String string) throws ParseException {
        String string2 = string.trim();
        if (WKTOrWKBReader.isHex(string2, 6)) {
            return this.wkbReader.read(WKBReader.hexToBytes((String)string2));
        }
        return this.wktReader.read(string2);
    }
}

