/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jtsexample.technique;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.CoordinateArrays;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.MultiLineString;
import com.vividsolutions.jts.io.WKTReader;
import java.util.ArrayList;

public class LineStringSelfIntersections {
    public static void main(String[] stringArray) throws Exception {
        WKTReader wKTReader = new WKTReader();
        LineString lineString = (LineString)wKTReader.read("LINESTRING (0 0, 10 10, 20 20)");
        LineStringSelfIntersections.showSelfIntersections(lineString);
        LineString lineString2 = (LineString)wKTReader.read("LINESTRING (0 40, 60 40, 60 0, 20 0, 20 60)");
        LineStringSelfIntersections.showSelfIntersections(lineString2);
    }

    public static void showSelfIntersections(LineString lineString) {
        System.out.println("Line: " + lineString);
        System.out.println("Self Intersections: " + LineStringSelfIntersections.lineStringSelfIntersections(lineString));
    }

    public static Geometry lineStringSelfIntersections(LineString lineString) {
        Geometry geometry = LineStringSelfIntersections.getEndPoints((Geometry)lineString);
        Geometry geometry2 = lineString.union(geometry);
        Geometry geometry3 = LineStringSelfIntersections.getEndPoints(geometry2);
        Geometry geometry4 = geometry3.difference(geometry);
        return geometry4;
    }

    public static Geometry getEndPoints(Geometry geometry) {
        Coordinate[] coordinateArray;
        ArrayList<Coordinate> arrayList = new ArrayList<Coordinate>();
        if (geometry instanceof LineString) {
            coordinateArray = (Coordinate[])geometry;
            arrayList.add(coordinateArray.getCoordinateN(0));
            arrayList.add(coordinateArray.getCoordinateN(coordinateArray.getNumPoints() - 1));
        } else if (geometry instanceof MultiLineString) {
            coordinateArray = (MultiLineString)geometry;
            for (int i = 0; i < coordinateArray.getNumGeometries(); ++i) {
                LineString lineString = (LineString)coordinateArray.getGeometryN(i);
                arrayList.add(lineString.getCoordinateN(0));
                arrayList.add(lineString.getCoordinateN(lineString.getNumPoints() - 1));
            }
        }
        coordinateArray = CoordinateArrays.toCoordinateArray(arrayList);
        return new GeometryFactory().createMultiPoint(coordinateArray);
    }
}

