/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jtstest.clean;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryCollection;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.Polygon;
import java.util.ArrayList;
import java.util.List;

public class LineStringExtracter {
    private GeometryFactory fact;

    public Geometry extract(Geometry geometry) {
        this.fact = geometry.getFactory();
        ArrayList arrayList = new ArrayList();
        this.addLines(geometry, arrayList);
        return this.fact.buildGeometry(arrayList);
    }

    private void addLines(Geometry geometry, List list) {
        if (geometry.isEmpty()) {
            return;
        }
        if (geometry instanceof LineString) {
            list.add(geometry);
        } else if (geometry instanceof Polygon) {
            this.addLines((Polygon)geometry, list);
        } else if (geometry instanceof GeometryCollection) {
            this.addLines((GeometryCollection)geometry, list);
        }
    }

    private void addLines(Polygon polygon, List list) {
        list.add(this.fact.createLineString(polygon.getExteriorRing().getCoordinates()));
        for (int i = 0; i < polygon.getNumInteriorRing(); ++i) {
            list.add(this.fact.createLineString(polygon.getInteriorRingN(i).getCoordinates()));
        }
    }

    private void addLines(GeometryCollection geometryCollection, List list) {
        for (int i = 0; i < geometryCollection.getNumGeometries(); ++i) {
            Geometry geometry = geometryCollection.getGeometryN(i);
            this.addLines(geometry, list);
        }
    }
}

