/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jtstest.testbuilder;

import com.vividsolutions.jtstest.testbuilder.ValidPanelEvent;
import com.vividsolutions.jtstest.testbuilder.ValidPanelListener;
import com.vividsolutions.jtstest.testbuilder.model.TestCaseEdit;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class ScalarFunctionPanel
extends JPanel {
    TestCaseEdit testCase;
    private transient Vector validPanelListeners;
    private JButton btnDistance = new JButton();
    private JTextField txtDistance = new JTextField();
    private GridBagLayout gridBagLayout1 = new GridBagLayout();
    private JButton btnWithinDistance = new JButton();
    private JTextField txtWithinDistanceArg = new JTextField();
    private JTextField txtIsWithinDistance = new JTextField();
    private JButton btnLength = new JButton();
    private JTextField txtLength = new JTextField();
    private JButton btnArea = new JButton();
    private JTextField txtArea = new JTextField();
    private JLabel jLabel1 = new JLabel();
    private JLabel jLabel2 = new JLabel();
    private JLabel aSimpleLabel = new JLabel();
    private JLabel bSimpleLabel = new JLabel();
    private JLabel jLabel4 = new JLabel();
    private JLabel jLabel3 = new JLabel();
    private JPanel jPanel5 = new JPanel();

    public ScalarFunctionPanel() {
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    void jbInit() throws Exception {
        this.btnDistance.setPreferredSize(new Dimension(59, 21));
        this.btnDistance.setMargin(new Insets(2, 2, 2, 2));
        this.btnDistance.setText("Distance");
        this.btnDistance.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ScalarFunctionPanel.this.btnDistance_actionPerformed(actionEvent);
            }
        });
        this.setLayout(this.gridBagLayout1);
        this.txtDistance.setBackground(SystemColor.inactiveCaptionBorder);
        this.txtDistance.setToolTipText("");
        this.txtDistance.setEditable(false);
        this.txtDistance.setHorizontalAlignment(11);
        this.btnWithinDistance.setPreferredSize(new Dimension(97, 21));
        this.btnWithinDistance.setMargin(new Insets(2, 2, 2, 2));
        this.btnWithinDistance.setText("Within Distance");
        this.btnWithinDistance.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ScalarFunctionPanel.this.btnWithinDistance_actionPerformed(actionEvent);
            }
        });
        this.txtIsWithinDistance.setBackground(SystemColor.menu);
        this.txtIsWithinDistance.setPreferredSize(new Dimension(20, 21));
        this.txtIsWithinDistance.setEditable(false);
        this.txtIsWithinDistance.setHorizontalAlignment(0);
        this.btnLength.setPreferredSize(new Dimension(95, 21));
        this.btnLength.setText("Length of A");
        this.btnLength.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ScalarFunctionPanel.this.btnLength_actionPerformed(actionEvent);
            }
        });
        this.txtLength.setHorizontalAlignment(11);
        this.txtLength.setEditable(false);
        this.txtLength.setToolTipText("");
        this.txtLength.setBackground(SystemColor.inactiveCaptionBorder);
        this.btnArea.setMaximumSize(new Dimension(59, 21));
        this.btnArea.setPreferredSize(new Dimension(59, 21));
        this.btnArea.setToolTipText("");
        this.btnArea.setMargin(new Insets(2, 2, 2, 2));
        this.btnArea.setText("Area of A");
        this.btnArea.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ScalarFunctionPanel.this.btnArea_actionPerformed(actionEvent);
            }
        });
        this.txtArea.setBackground(SystemColor.inactiveCaptionBorder);
        this.txtArea.setToolTipText("");
        this.txtArea.setEditable(false);
        this.txtArea.setHorizontalAlignment(11);
        this.jLabel1.setFont(new Font("Dialog", 1, 12));
        this.jLabel1.setForeground(SystemColor.desktop);
        this.jLabel1.setHorizontalAlignment(2);
        this.jLabel1.setText("Binary");
        this.jLabel2.setFont(new Font("Dialog", 1, 12));
        this.jLabel2.setForeground(SystemColor.desktop);
        this.jLabel2.setText("Unary");
        this.txtWithinDistanceArg.setHorizontalAlignment(4);
        this.aSimpleLabel.setText("N");
        this.aSimpleLabel.setHorizontalAlignment(0);
        this.aSimpleLabel.setPreferredSize(new Dimension(30, 21));
        this.aSimpleLabel.setMinimumSize(new Dimension(30, 21));
        this.aSimpleLabel.setMaximumSize(new Dimension(30, 21));
        this.aSimpleLabel.setBorder(BorderFactory.createLoweredBevelBorder());
        this.bSimpleLabel.setText("N");
        this.bSimpleLabel.setHorizontalAlignment(0);
        this.bSimpleLabel.setPreferredSize(new Dimension(30, 21));
        this.bSimpleLabel.setMinimumSize(new Dimension(30, 21));
        this.bSimpleLabel.setMaximumSize(new Dimension(30, 21));
        this.bSimpleLabel.setBorder(BorderFactory.createLoweredBevelBorder());
        this.jLabel4.setText("A simple:");
        this.jLabel3.setToolTipText("");
        this.jLabel3.setIconTextGap(10);
        this.jLabel3.setText("B simple:");
        this.add((Component)this.btnDistance, new GridBagConstraints(0, 5, 2, 1, 0.0, 0.0, 17, 2, new Insets(0, 5, 5, 5), 0, 0));
        this.add((Component)this.txtDistance, new GridBagConstraints(2, 5, 2, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.btnWithinDistance, new GridBagConstraints(0, 6, 2, 1, 0.0, 0.0, 10, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.add((Component)this.txtWithinDistanceArg, new GridBagConstraints(2, 6, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.txtIsWithinDistance, new GridBagConstraints(3, 6, 1, 1, 0.1, 0.0, 10, 2, new Insets(0, 5, 0, 0), 0, 0));
        this.add((Component)this.btnLength, new GridBagConstraints(0, 3, 2, 1, 0.0, 0.0, 10, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.add((Component)this.txtLength, new GridBagConstraints(2, 3, 2, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.btnArea, new GridBagConstraints(0, 2, 2, 1, 0.0, 0.0, 10, 2, new Insets(20, 5, 5, 5), 0, 0));
        this.add((Component)this.txtArea, new GridBagConstraints(2, 2, 2, 1, 0.0, 0.0, 15, 2, new Insets(0, 0, 5, 0), 0, 0));
        this.add((Component)this.jLabel1, new GridBagConstraints(0, 4, 2, 1, 0.0, 0.0, 17, 0, new Insets(20, 5, 5, 0), 0, 0));
        this.add((Component)this.jPanel5, new GridBagConstraints(1, 1, 2, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.jPanel5.add((Component)this.jLabel4, null);
        this.jPanel5.add((Component)this.aSimpleLabel, null);
        this.jPanel5.add((Component)this.jLabel3, null);
        this.jPanel5.add((Component)this.bSimpleLabel, null);
        this.add((Component)this.jLabel2, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 5, 5, 0), 0, 0));
    }

    public void setTestCase(TestCaseEdit testCaseEdit) {
        this.testCase = testCaseEdit;
    }

    public synchronized void removeValidPanelListener(ValidPanelListener validPanelListener) {
        if (this.validPanelListeners != null && this.validPanelListeners.contains(validPanelListener)) {
            Vector vector = (Vector)this.validPanelListeners.clone();
            vector.removeElement(validPanelListener);
            this.validPanelListeners = vector;
        }
    }

    public synchronized void addValidPanelListener(ValidPanelListener validPanelListener) {
        Vector vector;
        Vector vector2 = vector = this.validPanelListeners == null ? new Vector(2) : (Vector)this.validPanelListeners.clone();
        if (!vector.contains(validPanelListener)) {
            vector.addElement(validPanelListener);
            this.validPanelListeners = vector;
        }
    }

    protected void fireSetHighlightPerformed(ValidPanelEvent validPanelEvent) {
        if (this.validPanelListeners != null) {
            Vector vector = this.validPanelListeners;
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                ((ValidPanelListener)vector.elementAt(i)).setHighlightPerformed(validPanelEvent);
            }
        }
    }

    public void clearResults() {
        this.txtArea.setText("");
        this.txtLength.setText("");
        this.txtDistance.setText("");
        this.txtIsWithinDistance.setText("");
        this.refreshIsSimpleDisplay();
    }

    void btnDistance_actionPerformed(ActionEvent actionEvent) {
        this.txtDistance.setText("");
        if (this.testCase == null) {
            return;
        }
        if (this.testCase.getGeometry(0) == null || this.testCase.getGeometry(1) == null) {
            return;
        }
        double d = this.testCase.getGeometry(0).distance(this.testCase.getGeometry(1));
        this.txtDistance.setText(d + "");
    }

    void btnLength_actionPerformed(ActionEvent actionEvent) {
        this.txtLength.setText("");
        if (this.testCase == null) {
            return;
        }
        if (this.testCase.getGeometry(0) == null) {
            return;
        }
        this.txtLength.setText(this.testCase.getGeometry(0).getLength() + "");
    }

    void btnArea_actionPerformed(ActionEvent actionEvent) {
        this.txtArea.setText("");
        if (this.testCase == null) {
            return;
        }
        if (this.testCase.getGeometry(0) == null) {
            return;
        }
        this.txtArea.setText(this.testCase.getGeometry(0).getArea() + "");
    }

    void btnWithinDistance_actionPerformed(ActionEvent actionEvent) {
        this.txtIsWithinDistance.setText("");
        if (this.testCase == null) {
            return;
        }
        if (this.testCase.getGeometry(0) == null) {
            return;
        }
        double d = 0.0;
        try {
            d = Double.parseDouble(this.txtWithinDistanceArg.getText());
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        boolean bl = this.testCase.getGeometry(0).isWithinDistance(this.testCase.getGeometry(1), d);
        this.txtIsWithinDistance.setText(bl ? "Y" : "N");
    }

    private void refreshIsSimpleDisplay() {
        try {
            this.aSimpleLabel.setText(this.testCase.getGeometry(0) == null ? "" : (this.testCase.getGeometry(0).isSimple() ? "Y" : "N"));
        }
        catch (Exception exception) {
            this.aSimpleLabel.setText("");
        }
        try {
            this.bSimpleLabel.setText(this.testCase.getGeometry(1) == null ? "" : (this.testCase.getGeometry(1).isSimple() ? "Y" : "N"));
        }
        catch (Exception exception) {
            this.bSimpleLabel.setText("");
        }
    }
}

