/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jtstest.testbuilder;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jtstest.function.GeometryFunction;
import com.vividsolutions.jtstest.testbuilder.GeometryEditPanel;
import com.vividsolutions.jtstest.testbuilder.GeometryFunctionListPanel;
import com.vividsolutions.jtstest.testbuilder.JTSTestBuilder;
import com.vividsolutions.jtstest.testbuilder.JTSTestBuilderFrame;
import com.vividsolutions.jtstest.testbuilder.SpatialFunctionPanelEvent;
import com.vividsolutions.jtstest.testbuilder.SpatialFunctionPanelListener;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Vector;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class SpatialFunctionPanel
extends JPanel {
    private static String[] capStyleItems = new String[]{"", "Round", "Flat", "Square"};
    private static Object[] capStyleValues = new Object[]{null, new Integer(1), new Integer(2), new Integer(3)};
    private static String[] joinStyleItems = new String[]{"", "Round", "Mitre", "Bevel"};
    private static Object[] joinStyleValues = new Object[]{null, new Integer(1), new Integer(2), new Integer(3)};
    JPanel panelRB = new JPanel();
    GeometryFunctionListPanel geomFuncPanel = new GeometryFunctionListPanel();
    GridLayout gridLayout1 = new GridLayout();
    GridLayout gridLayout2 = new GridLayout();
    BorderLayout borderLayout1 = new BorderLayout();
    BorderLayout borderLayout2 = new BorderLayout();
    JPanel panelParam = new JPanel();
    JPanel panelExec = new JPanel();
    JPanel panelExecParam = new JPanel();
    FlowLayout flowLayout = new FlowLayout();
    FlowLayout flowLayout1 = new FlowLayout();
    JButton execButton = new JButton();
    private final ImageIcon clearIcon = new ImageIcon(this.getClass().getResource("clear.gif"));
    private transient Vector spatialFunctionPanelListeners;
    private JPanel panelControl = new JPanel();
    private JCheckBox displayAAndBCheckBox = new JCheckBox();
    private JButton btnClearResult = new JButton();
    private JLabel lblDistance = new JLabel();
    private JTextField txtDistance = new JTextField();
    private JLabel lblQuadSegs = new JLabel();
    private JTextField txtQuadrantSegs = new JTextField();
    private JLabel lblCapStyle = new JLabel();
    private JComboBox cbCapStyle = new JComboBox();
    private JLabel lblJoinStyle = new JLabel();
    private JComboBox cbJoinStyle = new JComboBox();
    private JLabel lblMitreLimit = new JLabel();
    private JTextField txtMitreLimit = new JTextField();
    private GeometryFunction currentFunc = null;
    static /* synthetic */ Class class$com$vividsolutions$jts$geom$Geometry;
    static /* synthetic */ Class class$java$lang$Double;

    public SpatialFunctionPanel() {
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    void jbInit() throws Exception {
        this.setLayout(this.borderLayout1);
        this.panelParam.setLayout(this.gridLayout2);
        this.panelExec.setLayout(this.flowLayout);
        this.panelExecParam.setLayout(this.borderLayout2);
        this.panelRB.setLayout(this.gridLayout1);
        this.gridLayout2.setRows(5);
        this.gridLayout2.setColumns(2);
        this.displayAAndBCheckBox.setSelected(true);
        this.displayAAndBCheckBox.setToolTipText("");
        this.displayAAndBCheckBox.setText("Display Input Geometries");
        this.displayAAndBCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SpatialFunctionPanel.this.displayAAndBCheckBox_actionPerformed(actionEvent);
            }
        });
        this.lblDistance.setText("Distance");
        this.txtDistance.setMaximumSize(new Dimension(25, Integer.MAX_VALUE));
        this.txtDistance.setMinimumSize(new Dimension(25, 21));
        this.txtDistance.setPreferredSize(new Dimension(25, 17));
        this.txtDistance.setText("10");
        this.txtDistance.setHorizontalAlignment(4);
        this.lblQuadSegs.setText("Quadrant Segs");
        this.txtQuadrantSegs.setHorizontalAlignment(4);
        this.lblCapStyle.setText("Cap Style");
        DefaultComboBoxModel<String> defaultComboBoxModel = new DefaultComboBoxModel<String>(capStyleItems);
        this.cbCapStyle.setModel(defaultComboBoxModel);
        this.lblJoinStyle.setText("Join Style");
        DefaultComboBoxModel<String> defaultComboBoxModel2 = new DefaultComboBoxModel<String>(joinStyleItems);
        this.cbJoinStyle.setModel(defaultComboBoxModel2);
        this.lblMitreLimit.setText("Mitre Limit");
        this.txtMitreLimit.setHorizontalAlignment(4);
        this.panelControl.setLayout(this.flowLayout1);
        this.btnClearResult.setToolTipText("");
        this.btnClearResult.setMargin(new Insets(0, 10, 0, 10));
        this.btnClearResult.setSelected(true);
        this.btnClearResult.setText("Clear Result");
        this.btnClearResult.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SpatialFunctionPanel.this.noneButton_actionPerformed(actionEvent);
            }
        });
        this.panelParam.add(this.lblDistance);
        this.panelParam.add(this.txtDistance);
        this.panelParam.add(this.lblQuadSegs);
        this.panelParam.add(this.txtQuadrantSegs);
        this.panelParam.add(this.lblCapStyle);
        this.panelParam.add(this.cbCapStyle);
        this.panelParam.add(this.lblJoinStyle);
        this.panelParam.add(this.cbJoinStyle);
        this.panelParam.add(this.lblMitreLimit);
        this.panelParam.add(this.txtMitreLimit);
        this.panelControl.add((Component)this.displayAAndBCheckBox, null);
        this.panelControl.add((Component)this.btnClearResult, null);
        this.execButton.setText("Compute");
        this.execButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SpatialFunctionPanel.this.execButton_actionPerformed(actionEvent);
            }
        });
        this.panelExec.add(this.execButton);
        this.panelExecParam.add((Component)this.panelExec, "North");
        this.panelExecParam.add((Component)this.panelParam, "Center");
        this.panelExecParam.add((Component)this.panelControl, "South");
        this.add((Component)this.geomFuncPanel, "Center");
        this.add((Component)this.panelExecParam, "South");
        MouseAdapter mouseAdapter = new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() == 2) {
                    SpatialFunctionPanel.this.execFunction();
                }
            }
        };
        this.geomFuncPanel.registerMouseListener(mouseAdapter);
        ListSelectionListener listSelectionListener = new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                SpatialFunctionPanel.this.functionListValueChanged();
            }
        };
        this.geomFuncPanel.registerListSelectionListener(listSelectionListener);
    }

    void noneButton_actionPerformed(ActionEvent actionEvent) {
        this.clearFunction();
    }

    void execButton_actionPerformed(ActionEvent actionEvent) {
        this.execFunction();
    }

    void displayAAndBCheckBox_actionPerformed(ActionEvent actionEvent) {
        this.getGeometryEditPanel().setShowingInput(this.displayAAndBCheckBox.isSelected());
    }

    private Geometry getGeometryA() {
        return JTSTestBuilder.getInstance().getModel().getGeometryEditModel().getGeometry(0);
    }

    private Geometry getGeometryB() {
        return JTSTestBuilder.getInstance().getModel().getGeometryEditModel().getGeometry(1);
    }

    private GeometryEditPanel getGeometryEditPanel() {
        return JTSTestBuilderFrame.getInstance().getTestCasePanel().getGeometryEditPanel();
    }

    public void execFunction() {
        this.currentFunc = this.geomFuncPanel.getFunction();
        this.fireFunctionChanged(new SpatialFunctionPanelEvent(this));
    }

    public void setCurrentFunction(GeometryFunction geometryFunction) {
        this.currentFunc = geometryFunction;
        this.fireFunctionChanged(new SpatialFunctionPanelEvent(this));
    }

    private void functionListValueChanged() {
        this.currentFunc = this.geomFuncPanel.getFunction();
        this.updateParameterControls();
    }

    private void updateParameterControls() {
        int n = SpatialFunctionPanel.numNonGeomParams(this.currentFunc);
        SpatialFunctionPanel.setEnabled(this.txtDistance, n >= 1);
        SpatialFunctionPanel.setEnabled(this.txtQuadrantSegs, n >= 2);
        SpatialFunctionPanel.setEnabled(this.cbCapStyle, n >= 3);
        SpatialFunctionPanel.setEnabled(this.cbJoinStyle, n >= 4);
        SpatialFunctionPanel.setEnabled(this.txtMitreLimit, n >= 5);
    }

    private static int numNonGeomParams(GeometryFunction geometryFunction) {
        int n = 0;
        Class[] classArray = geometryFunction.getParameterTypes();
        for (int i = 0; i < classArray.length; ++i) {
            if (classArray[i] == (class$com$vividsolutions$jts$geom$Geometry == null ? SpatialFunctionPanel.class$("com.vividsolutions.jts.geom.Geometry") : class$com$vividsolutions$jts$geom$Geometry)) continue;
            ++n;
        }
        return n;
    }

    private static void setEnabled(Component component, boolean bl) {
        component.setEnabled(bl);
        if (bl) {
            component.setBackground(SystemColor.text);
        } else {
            component.setBackground(SystemColor.control);
        }
    }

    public boolean shouldShowGeometryA() {
        return this.displayAAndBCheckBox.isSelected();
    }

    public boolean shouldShowGeometryB() {
        return this.displayAAndBCheckBox.isSelected();
    }

    public void clearFunction() {
        this.setCurrentFunction(null);
    }

    public Object getResult() {
        Object object = null;
        if (this.currentFunc == null) {
            return null;
        }
        try {
            object = this.currentFunc.invoke(this.getGeometryA(), this.getFunctionParams());
        }
        catch (Exception exception) {
            exception.printStackTrace(System.out);
            object = exception;
        }
        return object;
    }

    private Object[] getFunctionParams() {
        Class[] classArray = this.currentFunc.getParameterTypes();
        if (classArray.length == 1 && classArray[0] == (class$com$vividsolutions$jts$geom$Geometry == null ? (class$com$vividsolutions$jts$geom$Geometry = SpatialFunctionPanel.class$("com.vividsolutions.jts.geom.Geometry")) : class$com$vividsolutions$jts$geom$Geometry)) {
            return new Object[]{this.getGeometryB()};
        }
        if (classArray.length == 1 && classArray[0] == (class$java$lang$Double == null ? (class$java$lang$Double = SpatialFunctionPanel.class$("java.lang.Double")) : class$java$lang$Double)) {
            return new Object[]{this.getDistance()};
        }
        if (classArray.length >= 2) {
            return new Object[]{this.getDistance(), SpatialFunctionPanel.getInteger(this.txtQuadrantSegs, null), SpatialFunctionPanel.getSelectedValue(this.cbCapStyle, capStyleValues), SpatialFunctionPanel.getSelectedValue(this.cbJoinStyle, joinStyleValues), SpatialFunctionPanel.getDouble(this.txtMitreLimit, null)};
        }
        return null;
    }

    private Double getDistance() {
        if (this.txtDistance.getText().trim().length() == 0) {
            return null;
        }
        return new Double(Double.parseDouble(this.txtDistance.getText()));
    }

    private static Integer getInteger(JTextField jTextField, Integer n) {
        String string = jTextField.getText();
        if (string.trim().length() <= 0) {
            return n;
        }
        int n2 = 0;
        try {
            n2 = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return new Integer(n2);
    }

    private static Double getDouble(JTextField jTextField, Double d) {
        String string = jTextField.getText();
        if (string.trim().length() <= 0) {
            return d;
        }
        double d2 = 0.0;
        try {
            d2 = Double.parseDouble(string);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return new Double(d2);
    }

    private static Object getSelectedValue(JComboBox jComboBox, Object[] objectArray) {
        int n = jComboBox.getSelectedIndex();
        if (n == -1) {
            return null;
        }
        return objectArray[n];
    }

    public String getOpName() {
        if (this.currentFunc == null) {
            return "";
        }
        return this.currentFunc.getName();
    }

    public synchronized void removeSpatialFunctionPanelListener(SpatialFunctionPanelListener spatialFunctionPanelListener) {
        if (this.spatialFunctionPanelListeners != null && this.spatialFunctionPanelListeners.contains(spatialFunctionPanelListener)) {
            Vector vector = (Vector)this.spatialFunctionPanelListeners.clone();
            vector.removeElement(spatialFunctionPanelListener);
            this.spatialFunctionPanelListeners = vector;
        }
    }

    public synchronized void addSpatialFunctionPanelListener(SpatialFunctionPanelListener spatialFunctionPanelListener) {
        Vector vector;
        Vector vector2 = vector = this.spatialFunctionPanelListeners == null ? new Vector(2) : (Vector)this.spatialFunctionPanelListeners.clone();
        if (!vector.contains(spatialFunctionPanelListener)) {
            vector.addElement(spatialFunctionPanelListener);
            this.spatialFunctionPanelListeners = vector;
        }
    }

    protected void fireFunctionChanged(SpatialFunctionPanelEvent spatialFunctionPanelEvent) {
        if (this.spatialFunctionPanelListeners != null) {
            Vector vector = this.spatialFunctionPanelListeners;
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                ((SpatialFunctionPanelListener)vector.elementAt(i)).functionChanged(spatialFunctionPanelEvent);
            }
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

