/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jtstest.testbuilder;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.util.Assert;
import com.vividsolutions.jtstest.testbuilder.GeometryEditPanel;
import com.vividsolutions.jtstest.testbuilder.java2D.Java2DConverter;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;

public class Viewport
implements Java2DConverter.PointConverter {
    private static int INITIAL_VIEW_ORIGIN_X = -10;
    private static int INITIAL_VIEW_ORIGIN_Y = -10;
    private GeometryEditPanel panel;
    private Point2D viewOriginInModel = new Point2D.Double(INITIAL_VIEW_ORIGIN_X, INITIAL_VIEW_ORIGIN_Y);
    private double scale = 1.0;
    private Envelope viewEnvInModel;
    private AffineTransform modelToViewTransform;
    private Point2D.Double srcPt = new Point2D.Double(0.0, 0.0);
    private Point2D.Double destPt = new Point2D.Double(0.0, 0.0);

    public Viewport(GeometryEditPanel geometryEditPanel) {
        this.panel = geometryEditPanel;
    }

    public double getScale() {
        return this.scale;
    }

    public void setScale(double d) {
        this.scale = d;
        this.update();
    }

    public double getViewOriginX() {
        return this.viewOriginInModel.getX();
    }

    public double getViewOriginY() {
        return this.viewOriginInModel.getY();
    }

    public void setViewOrigin(double d, double d2) {
        this.viewOriginInModel = new Point2D.Double(d, d2);
        this.update();
    }

    public Point2D toModel(Point2D point2D) {
        this.srcPt.x = point2D.getX();
        this.srcPt.y = point2D.getY();
        try {
            this.modelToViewTransform.inverseTransform(this.srcPt, this.destPt);
        }
        catch (NoninvertibleTransformException noninvertibleTransformException) {
            Assert.shouldNeverReachHere();
        }
        return new Point2D.Double(this.destPt.x, this.destPt.y);
    }

    public Coordinate toModelCoordinate(Point2D point2D) {
        Point2D point2D2 = this.toModel(point2D);
        return new Coordinate(point2D2.getX(), point2D2.getY());
    }

    public Point2D toView(Coordinate coordinate) {
        Point2D.Double double_ = new Point2D.Double(coordinate.x, coordinate.y);
        return this.getModelToViewTransform().transform(double_, double_);
    }

    public Point2D toView(Point2D point2D) {
        Point2D.Double double_ = new Point2D.Double();
        return this.getModelToViewTransform().transform(point2D, double_);
    }

    public void update() {
        this.updateModelToViewTransform();
        this.viewEnvInModel = this.computeEnvelopeInModel();
        this.panel.forceRepaint();
    }

    private void updateModelToViewTransform() {
        this.modelToViewTransform = new AffineTransform();
        this.modelToViewTransform.translate(0.0, this.panel.getSize().height);
        this.modelToViewTransform.scale(1.0, -1.0);
        this.modelToViewTransform.scale(this.scale, this.scale);
        this.modelToViewTransform.translate(-this.viewOriginInModel.getX(), -this.viewOriginInModel.getY());
    }

    public AffineTransform getModelToViewTransform() {
        if (this.modelToViewTransform == null) {
            this.updateModelToViewTransform();
        }
        return this.modelToViewTransform;
    }

    public void zoomToInitialExtent() {
        this.setScale(1.0);
        this.setViewOrigin(INITIAL_VIEW_ORIGIN_X, INITIAL_VIEW_ORIGIN_Y);
    }

    public void zoom(Envelope envelope) {
        this.zoomToInitialExtent();
        double d = this.getWidthInModel() / envelope.getWidth();
        double d2 = this.getHeightInModel() / envelope.getHeight();
        this.setScale(Math.min(d, d2));
        double d3 = (this.getWidthInModel() - envelope.getWidth()) / 2.0;
        double d4 = (this.getHeightInModel() - envelope.getHeight()) / 2.0;
        this.setViewOrigin(envelope.getMinX() - d3, envelope.getMinY() - d4);
    }

    private double getWidthInModel() {
        return this.getUpperRightCornerInModel().getX() - this.getLowerLeftCornerInModel().getX();
    }

    private double getHeightInModel() {
        return this.getUpperRightCornerInModel().getY() - this.getLowerLeftCornerInModel().getY();
    }

    public Point2D getLowerLeftCornerInModel() {
        Dimension dimension = this.panel.getSize();
        return this.toModel(new Point(0, dimension.height));
    }

    public Point2D getUpperRightCornerInModel() {
        Dimension dimension = this.panel.getSize();
        return this.toModel(new Point(dimension.width, 0));
    }

    public double getHeightInView() {
        return this.panel.getSize().height;
    }

    public double getWidthInView() {
        return this.panel.getSize().getWidth();
    }

    private Envelope computeEnvelopeInModel() {
        double d = (double)this.panel.getWidth() / this.scale;
        double d2 = (double)this.panel.getHeight() / this.scale;
        return new Envelope(this.viewOriginInModel.getX(), this.viewOriginInModel.getX() + d, this.viewOriginInModel.getY(), this.viewOriginInModel.getY() + d2);
    }

    public boolean containsInModel(Coordinate coordinate) {
        return this.viewEnvInModel.contains(coordinate);
    }
}

