/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jtstest.testbuilder.geom;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.CoordinateSequence;
import com.vividsolutions.jts.geom.CoordinateSequenceFilter;
import com.vividsolutions.jts.geom.Geometry;

public class NearestPointFinder {
    private Geometry geom;

    public static Coordinate findNearestPoint(Geometry geometry, Coordinate coordinate, double d) {
        NearestPointFinder nearestPointFinder = new NearestPointFinder(geometry);
        return nearestPointFinder.getNearestPoint(coordinate, d);
    }

    public NearestPointFinder(Geometry geometry) {
        this.geom = geometry;
    }

    public Coordinate getNearestPoint(Coordinate coordinate, double d) {
        NearestPointFilter nearestPointFilter = new NearestPointFilter(coordinate, d);
        this.geom.apply((CoordinateSequenceFilter)nearestPointFilter);
        return nearestPointFilter.getNearestPoint();
    }

    static class NearestPointFilter
    implements CoordinateSequenceFilter {
        private double tolerance = 0.0;
        private Coordinate basePt;
        private Coordinate nearestPt = null;
        private double dist = Double.MAX_VALUE;

        public NearestPointFilter(Coordinate coordinate, double d) {
            this.basePt = coordinate;
            this.tolerance = d;
        }

        public void filter(CoordinateSequence coordinateSequence, int n) {
            Coordinate coordinate = coordinateSequence.getCoordinate(n);
            double d = coordinate.distance(this.basePt);
            if (d > this.tolerance) {
                return;
            }
            if (this.nearestPt == null || this.basePt.distance(coordinate) < d) {
                this.nearestPt = coordinate;
                d = this.basePt.distance(this.nearestPt);
                return;
            }
        }

        public Coordinate getNearestPoint() {
            return this.nearestPt;
        }

        public boolean isDone() {
            return false;
        }

        public boolean isGeometryChanged() {
            return false;
        }
    }
}

