/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jtstest.testbuilder.geom;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.CoordinateSequence;
import com.vividsolutions.jts.geom.CoordinateSequenceFilter;
import com.vividsolutions.jts.geom.Geometry;

public class VertexLocater {
    private Geometry geom;
    private Coordinate vertexPt;
    private int vertexIndex = -1;

    public static Coordinate locateVertex(Geometry geometry, Coordinate coordinate, double d) {
        VertexLocater vertexLocater = new VertexLocater(geometry);
        return vertexLocater.getVertex(coordinate, d);
    }

    public VertexLocater(Geometry geometry) {
        this.geom = geometry;
    }

    public Coordinate getVertex(Coordinate coordinate, double d) {
        NearestVertexFilter nearestVertexFilter = new NearestVertexFilter(coordinate, d);
        this.geom.apply((CoordinateSequenceFilter)nearestVertexFilter);
        this.vertexPt = nearestVertexFilter.getVertex();
        this.vertexIndex = nearestVertexFilter.getIndex();
        return this.vertexPt;
    }

    public int getIndex() {
        return this.vertexIndex;
    }

    static class NearestVertexFilter
    implements CoordinateSequenceFilter {
        private double tolerance = 0.0;
        private Coordinate basePt;
        private Coordinate nearestPt = null;
        private int vertexIndex = -1;

        public NearestVertexFilter(Coordinate coordinate, double d) {
            this.basePt = coordinate;
            this.tolerance = d;
        }

        public void filter(CoordinateSequence coordinateSequence, int n) {
            Coordinate coordinate = coordinateSequence.getCoordinate(n);
            double d = coordinate.distance(this.basePt);
            if (d > this.tolerance) {
                return;
            }
            this.nearestPt = coordinate;
            this.vertexIndex = n;
        }

        public Coordinate getVertex() {
            return this.nearestPt;
        }

        public int getIndex() {
            return this.vertexIndex;
        }

        public boolean isDone() {
            return this.nearestPt != null;
        }

        public boolean isGeometryChanged() {
            return false;
        }
    }
}

