/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jtstest.testbuilder.model;

import Acme.JPM.Encoders.GifEncoder;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.PrecisionModel;
import com.vividsolutions.jts.util.Assert;
import com.vividsolutions.jtstest.test.TestCaseList;
import com.vividsolutions.jtstest.test.Testable;
import com.vividsolutions.jtstest.testbuilder.BusyDialog;
import com.vividsolutions.jtstest.testbuilder.GeometryEditPanel;
import com.vividsolutions.jtstest.testbuilder.model.TestBuilderModel;
import com.vividsolutions.jtstest.testbuilder.model.TestCaseEdit;
import com.vividsolutions.jtstest.testbuilder.model.TestRunnerTestCaseAdapter;
import com.vividsolutions.jtstest.testrunner.BooleanResult;
import com.vividsolutions.jtstest.testrunner.FileUtil;
import com.vividsolutions.jtstest.testrunner.StringUtil;
import com.vividsolutions.jtstest.testrunner.Test;
import com.vividsolutions.jtstest.testrunner.TestCase;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.BorderFactory;
import javax.swing.JFrame;

public class HtmlWriter {
    private static final int IMAGE_WIDTH = 200;
    private static final int IMAGE_HEIGHT = 200;
    private static final int STACK_TRACE_DEPTH = 1;
    private boolean showingABwithSpatialFunction = true;
    private GeometryEditPanel geometryEditPanel = new GeometryEditPanel();
    private JFrame frame = new JFrame();
    private File outputDirectory;
    private BusyDialog busyDialog = null;

    public HtmlWriter() {
        this.geometryEditPanel.setSize(200, 200);
        this.geometryEditPanel.setGridEnabled(false);
        this.geometryEditPanel.setBorder(BorderFactory.createEmptyBorder());
        this.frame.getContentPane().add(this.geometryEditPanel);
    }

    public void setShowingABwithSpatialFunction(boolean bl) {
        this.showingABwithSpatialFunction = bl;
    }

    public void setBusyDialog(BusyDialog busyDialog) {
        this.busyDialog = busyDialog;
    }

    public void write(File file, TestCaseList testCaseList, PrecisionModel precisionModel) throws IOException {
        if (this.busyDialog != null) {
            this.busyDialog.setDescription("Saving .html and .gif files");
        }
        Assert.isTrue((boolean)file.isDirectory());
        this.outputDirectory = file;
        MapAndList mapAndList = this.runMapAndRuns(testCaseList);
        Map map = mapAndList.map;
        List list = mapAndList.list;
        this.createHtmlFile("contents-frame.html", this.indexHtml(list, map, precisionModel));
        this.createHtmlFile("index.html", this.testTopHtml());
        int n = 0;
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            ++n;
            List list2 = (List)map.get(string);
            int n2 = 0;
            Iterator iterator2 = list2.iterator();
            while (iterator2.hasNext()) {
                Testable testable = (Testable)iterator2.next();
                ++n2;
                if (this.busyDialog != null) {
                    this.busyDialog.setDescription("Saving .html and .gif files: " + n2 + " of " + testCaseList.getList().size() + " tests");
                }
                this.createHtmlFile("Run" + n + "Case" + n2 + ".html", this.html(testable, n, n2));
            }
        }
    }

    private String html(Testable testable, int n, int n2) throws IOException {
        TestCaseEdit testCaseEdit = (TestCaseEdit)testable;
        String string = "<HTML>" + StringUtil.newLine + "<HEAD>" + StringUtil.newLine + "<TITLE>" + StringUtil.escapeHTML(this.testName(testCaseEdit, n2)) + "</TITLE>" + StringUtil.newLine + "<link REL='STYLESHEET' HREF='../jts.css' TYPE='Text/css'>" + StringUtil.newLine + "</HEAD>" + StringUtil.newLine + "<BODY>" + StringUtil.newLine + "<div class='testTitle'>" + StringUtil.escapeHTML(this.testName(testCaseEdit, n2)) + "</div>" + StringUtil.newLine + "<P>" + StringUtil.newLine;
        string = string + this.htmlForAB(testCaseEdit, n, n2);
        string = string + this.htmlForTests(testCaseEdit, n, n2);
        string = string + "</BODY>" + StringUtil.newLine + "</HTML>";
        return string;
    }

    private String deleteLastTag(String string) {
        if (string.lastIndexOf("<") == -1) {
            return string;
        }
        return string.substring(0, string.lastIndexOf("<"));
    }

    private String deleteFirstTag(String string) {
        if (string.lastIndexOf(">") == -1) {
            return string;
        }
        return string.substring(string.indexOf(">") + 1);
    }

    private String htmlForTests(TestCaseEdit testCaseEdit, int n, int n2) throws IOException {
        String string = this.htmlForBinaryPredicates(testCaseEdit, n2);
        string = string + this.htmlForSpatialFunctions(testCaseEdit, n, n2);
        string = string + this.htmlForTopologyMethods(testCaseEdit, n, n2);
        return string;
    }

    private String htmlForSpatialFunctionTest(TestCaseEdit testCaseEdit, int n, int n2, String string, String string2, String string3) {
        Object object;
        String string4 = "&nbsp;";
        try {
            object = (Geometry)this.actualResult(testCaseEdit, string, string2, string3);
            String string5 = "Run" + n + "Case" + n2 + string + "Actual";
            if (string2 != null) {
                string5 = string5 + string2;
            }
            if (string3 != null) {
                string5 = string5 + string3;
            }
            string5 = string5 + ".gif";
            string4 = this.htmlImageHtmlTextTable(string5, "<SPAN class=wktR>" + object.toText() + "</SPAN>", 0);
            this.createGifFile(string5, testCaseEdit.getGeometry(0), testCaseEdit.getGeometry(1), (Geometry)object, this.showingABwithSpatialFunction, 200, 200);
        }
        catch (Exception exception) {
            string4 = "<TD>" + StringUtil.replace(StringUtil.getStackTrace(exception, 1), "\n", "<BR>", true) + "</TD>";
            exception.printStackTrace(System.out);
        }
        object = "  <TR>" + StringUtil.newLine + "    <TD class=methodTitle>" + string + "</TD>" + StringUtil.newLine + string4 + StringUtil.newLine + "  </TR>" + StringUtil.newLine;
        return object;
    }

    private String htmlForRelateTest(TestCaseEdit testCaseEdit, int n) {
        String string;
        try {
            string = this.insertParagraphs(testCaseEdit.getGeometry(0).relate(testCaseEdit.getGeometry(1)).toString());
        }
        catch (Exception exception) {
            string = StringUtil.replace(StringUtil.getStackTrace(exception, 1), "\n", "<BR>", true);
            exception.printStackTrace(System.out);
        }
        String string2 = "  <TR>" + StringUtil.newLine + "    <TD class=methodTitle rowspan=9>relate</TD>" + StringUtil.newLine + "    <TD rowspan=9>" + string + "</TD>" + StringUtil.newLine + "  </TR>" + StringUtil.newLine;
        return string2;
    }

    private String insertParagraphs(String string) {
        StringBuffer stringBuffer = new StringBuffer(string);
        stringBuffer.insert(6, "<BR>");
        stringBuffer.insert(3, "<BR>");
        return stringBuffer.toString();
    }

    private String htmlForPredicateTest(TestCaseEdit testCaseEdit, int n, String string, String string2, String string3) {
        String string4;
        try {
            string4 = this.actualResult(testCaseEdit, string, string2, string3).toString();
        }
        catch (Exception exception) {
            string4 = StringUtil.replace(StringUtil.getStackTrace(exception, 1), "\n", "<BR>", true);
            exception.printStackTrace(System.out);
        }
        String string5 = "  <TR>" + StringUtil.newLine + "    <TD class=methodTitle>" + string + "</TD>" + StringUtil.newLine + "    <TD class=resultFalse>" + string4 + "</TD>" + StringUtil.newLine + "  </TR>" + StringUtil.newLine;
        return string5;
    }

    private Object actualResult(TestCaseEdit testCaseEdit, String string, String string2, String string3) throws Exception {
        try {
            Class[] classArray;
            Object[] objectArray;
            Assert.isTrue((string2.equalsIgnoreCase("A") || string2.equalsIgnoreCase("B") ? 1 : 0) != 0);
            Class<?> clazz = Class.forName("com.vividsolutions.jts.geom.Geometry");
            Geometry geometry = testCaseEdit.getGeometry(string2.equalsIgnoreCase("A") ? 0 : 1);
            if (string3 == null) {
                objectArray = new Object[]{};
                classArray = new Class[]{};
            } else {
                objectArray = new Object[]{testCaseEdit.getGeometry(string3.equalsIgnoreCase("A") ? 0 : 1)};
                classArray = new Class[]{clazz};
            }
            Method method = clazz.getMethod(string, classArray);
            return method.invoke((Object)geometry, objectArray);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw (Exception)invocationTargetException.getTargetException();
        }
    }

    private BooleanResult expectedPredicateResult(TestCaseEdit testCaseEdit, String string, String string2, String string3) {
        if (!(testCaseEdit.getTestable() instanceof TestRunnerTestCaseAdapter)) {
            return null;
        }
        TestRunnerTestCaseAdapter testRunnerTestCaseAdapter = (TestRunnerTestCaseAdapter)testCaseEdit.getTestable();
        TestCase testCase = testRunnerTestCaseAdapter.getTestRunnerTestCase();
        Iterator iterator = testCase.getTests().iterator();
        while (iterator.hasNext()) {
            Test test = (Test)iterator.next();
            if (!test.getOperation().equalsIgnoreCase(string) || !test.getGeometryIndex().equalsIgnoreCase(string2) || test.getArgumentCount() != 0 && (test.getArgument(0) == null || !test.getArgument(0).equalsIgnoreCase(string3)) && (test.getArgument(0) != null || !string3.equalsIgnoreCase("null"))) continue;
            return (BooleanResult)test.getExpectedResult();
        }
        return null;
    }

    private String htmlForAB(TestCaseEdit testCaseEdit, int n, int n2) throws IOException {
        String string = "<span class=wktA>" + (testCaseEdit.getGeometry(0) == null ? " " : testCaseEdit.getGeometry(0).toText()) + "</span>" + "<P>" + "<span class=wktB>" + (testCaseEdit.getGeometry(1) == null ? " " : testCaseEdit.getGeometry(1).toText()) + "</span>";
        String string2 = StringUtil.newLine + "<TABLE BORDER=0>" + StringUtil.newLine + "  <TR>" + StringUtil.newLine + this.htmlImageHtmlTextTable("Run" + n + "Case" + n2 + ".gif", string, 0) + "  </TR>" + StringUtil.newLine + "</TABLE>" + StringUtil.newLine;
        this.createGifFile("Run" + n + "Case" + n2 + ".gif", testCaseEdit.getGeometry(0), testCaseEdit.getGeometry(1), null, true, 200, 200, true);
        return string2;
    }

    private String htmlImageTextTable(String string, String string2, int n) {
        return this.htmlImageHtmlTextTable(string, StringUtil.escapeHTML(string2), n);
    }

    private String htmlImageHtmlTextTable(String string, String string2, int n) {
        return "    <TD>" + StringUtil.newLine + "      <IMG BORDER=\"1\" SRC=\"" + string + "\" WIDTH=" + 200 + " HEIGHT=" + 200 + ">" + StringUtil.newLine + "    </TD>" + StringUtil.newLine + "    <TD>" + StringUtil.newLine + string2 + StringUtil.newLine + "    </TD>" + StringUtil.newLine;
    }

    private String testName(Testable testable, int n) {
        String string = testable.getName();
        if ((string == null || string.length() == 0) && testable instanceof TestCaseEdit) {
            string = ((TestCaseEdit)testable).getDescription();
        }
        string = string == null || string.length() == 0 ? "Case " + n : "Case " + n + ": " + string;
        return string;
    }

    private String runName(String string, int n) {
        return "Run " + n + ": " + string;
    }

    private String htmlTitle(PrecisionModel precisionModel) {
        String string = "Precision Model: scale=" + precisionModel.getScale() + StringUtil.newLine;
        string = "<div class='precisionModel'>" + string + "</div>";
        return string;
    }

    private void createGifFile(String string, Geometry geometry, Geometry geometry2, Geometry geometry3, boolean bl, int n, int n2) throws FileNotFoundException, IOException {
        this.createGifFile(string, geometry, geometry2, geometry3, bl, n, n2, false);
    }

    private void createGifFile(String string, Geometry geometry, Geometry geometry2, Geometry geometry3, boolean bl, int n, int n2, boolean bl2) throws FileNotFoundException, IOException {
        TestBuilderModel testBuilderModel = new TestBuilderModel();
        TestCaseEdit testCaseEdit = new TestCaseEdit(new Geometry[]{geometry, geometry2});
        testCaseEdit.setResult(geometry3);
        testBuilderModel.getGeometryEditModel().setTestCase(testCaseEdit);
        this.geometryEditPanel.setModel(testBuilderModel);
        if (bl2) {
            this.geometryEditPanel.zoomToFullExtent();
        }
        this.geometryEditPanel.setShowingResult(geometry3 != null);
        this.geometryEditPanel.setShowingGeometryA(geometry != null && bl);
        this.geometryEditPanel.setShowingGeometryB(geometry2 != null && bl);
        String string2 = this.outputDirectory.getPath() + "\\" + string;
        BufferedImage bufferedImage = new BufferedImage(n, n2, 6);
        this.geometryEditPanel.paint(((Image)bufferedImage).getGraphics());
        FileOutputStream fileOutputStream = new FileOutputStream(string2, false);
        GifEncoder gifEncoder = new GifEncoder((Image)bufferedImage, (OutputStream)fileOutputStream);
        gifEncoder.setDimensions(n, n2);
        gifEncoder.encode();
        fileOutputStream.flush();
        fileOutputStream.close();
    }

    private void createHtmlFile(String string, String string2) throws IOException {
        String string3 = this.outputDirectory.getPath() + "\\" + string;
        FileUtil.setContents(string3, string2);
    }

    private MapAndList runMapAndRuns(TestCaseList testCaseList) {
        TreeMap treeMap = new TreeMap();
        ArrayList arrayList = new ArrayList();
        Object object = testCaseList.getList().iterator();
        while (object.hasNext()) {
            TestCaseEdit testCaseEdit = (TestCaseEdit)object.next();
            Testable testable = testCaseEdit.getTestable();
            if (testable instanceof TestRunnerTestCaseAdapter) {
                TestCase testCase = ((TestRunnerTestCaseAdapter)testable).getTestRunnerTestCase();
                String string = testCase.getTestRun().getTestFile().getName();
                string = string.indexOf(".") > -1 ? string.substring(0, string.indexOf(".")) : string;
                this.addToListMapAndList(string, testCaseEdit, treeMap, arrayList);
                continue;
            }
            this.addToListMapAndList("Other", testCaseEdit, treeMap, arrayList);
        }
        object = new MapAndList();
        ((MapAndList)object).map = treeMap;
        ((MapAndList)object).list = arrayList;
        return object;
    }

    private void addToListMapAndList(String string, Object object, Map map, List list) {
        if (map.containsKey(string)) {
            List list2 = (List)map.get(string);
            list2.add(object);
        } else {
            ArrayList<Object> arrayList = new ArrayList<Object>();
            arrayList.add(object);
            map.put(string, arrayList);
            list.add(string);
        }
    }

    private String indexHtml(List list, Map map, PrecisionModel precisionModel) {
        Object object;
        Object object2;
        String string = "<HTML>" + StringUtil.newLine + "<HEAD>" + StringUtil.newLine + "<TITLE>JTS Test Suite Index</TITLE>" + StringUtil.newLine + "<link REL='STYLESHEET' HREF='../jts.css' TYPE='Text/css'>" + StringUtil.newLine + "<script LANGUAGE=\"JavaScript\">" + StringUtil.newLine + "  function LoadDetailFrame() {" + StringUtil.newLine + "        testNumber = document.main_form.test_combo.selectedIndex;" + StringUtil.newLine + "        testHtmlFile = document.main_form.test_combo.options[testNumber].value;" + StringUtil.newLine + "        parent.detail.location.href=testHtmlFile;" + StringUtil.newLine + "        document.main_form.test_combo.blur();" + StringUtil.newLine + "  }" + StringUtil.newLine + "  function onRunChange() {" + StringUtil.newLine + "        selectedIndex = document.main_form.run_combo.selectedIndex;" + StringUtil.newLine + "        selectedCode  = document.main_form.run_combo.options[selectedIndex].value;" + StringUtil.newLine;
        int n = 0;
        Object object3 = list.iterator();
        while (object3.hasNext()) {
            object2 = (String)object3.next();
            string = string + "        if (selectedCode == 'Run" + ++n + "') {" + StringUtil.newLine;
            List list2 = (List)map.get(object2);
            int n2 = 0;
            object = list2.iterator();
            while (object.hasNext()) {
                Testable testable = (Testable)object.next();
                string = string + "              document.main_form.test_combo.length = " + ++n2 + ";" + StringUtil.newLine;
                string = string + "              document.main_form.test_combo.options[" + (n2 - 1) + "].text  = \"" + StringUtil.escapeHTML(this.testName(testable, n2)) + "\";" + StringUtil.newLine;
                string = string + "              document.main_form.test_combo.options[" + (n2 - 1) + "].value  = 'Run" + n + "Case" + n2 + ".html';" + StringUtil.newLine;
            }
            string = string + "        LoadDetailFrame();";
            string = string + "  }";
        }
        string = string + "  }" + StringUtil.newLine + "</script>" + StringUtil.newLine + "</HEAD>" + StringUtil.newLine + "<BODY>" + StringUtil.newLine + "<h1>JTS Validation Suite</h1>" + StringUtil.newLine + this.htmlTitle(precisionModel) + "<p>" + StringUtil.newLine + "<FORM id=\"main_form\" name=\"main_form\">" + StringUtil.newLine;
        string = string + "<select id=run_combo name=run_combo size='1' style='width:30%' onChange='onRunChange()'>" + StringUtil.newLine;
        n = 0;
        object3 = list.iterator();
        while (object3.hasNext()) {
            object2 = (String)object3.next();
            string = string + "<OPTION VALUE='Run" + ++n + "'>" + StringUtil.escapeHTML(this.runName((String)object2, n)) + "</OPTION>" + StringUtil.newLine;
        }
        string = string + "</select>" + StringUtil.newLine;
        string = string + "<select id=test_combo name=test_combo size='1' style='width:60%' onChange='LoadDetailFrame()'>" + StringUtil.newLine;
        object3 = (String)list.iterator().next();
        object2 = (List)map.get(object3);
        int n3 = 0;
        Iterator iterator = object2.iterator();
        while (iterator.hasNext()) {
            object = (Testable)iterator.next();
            string = string + "<OPTION VALUE='Run1Case" + ++n3 + ".html'>" + StringUtil.escapeHTML(this.testName((Testable)object, n3)) + "</OPTION>" + StringUtil.newLine;
        }
        string = string + "</select>" + StringUtil.newLine;
        string = string + "</FORM>" + StringUtil.newLine + "</BODY>" + StringUtil.newLine + "</HTML>" + StringUtil.newLine + "" + StringUtil.newLine;
        return string;
    }

    private String testTopHtml() {
        return "<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.0 Frameset//EN\"\"http://www.w3.org/TR/REC-html40/frameset.dtd\">" + StringUtil.newLine + "<HTML>" + StringUtil.newLine + "<HEAD>" + StringUtil.newLine + "<TITLE>" + StringUtil.newLine + "JTS Validation Suite" + StringUtil.newLine + "</TITLE>" + StringUtil.newLine + "</HEAD>" + StringUtil.newLine + "<FRAMESET rows=\"120px,*\" framespacing=0 frameborder=0>" + StringUtil.newLine + "<FRAME id=contents name=\"contents\"  FRAMEBORDER=0 src=\"contents-frame.html\" scrolling=no>" + StringUtil.newLine + "<FRAME id=detail name=\"detail\"\tFRAMEBORDER=0 src=\"Run1Case1.html\" >" + StringUtil.newLine + "</FRAMESET>" + StringUtil.newLine + "<NOFRAMES>" + StringUtil.newLine + "<H2>" + StringUtil.newLine + "Frame Alert</H2>" + StringUtil.newLine + "" + StringUtil.newLine + "<P>" + StringUtil.newLine + "This site is designed to be viewed using frames. " + StringUtil.newLine + "If you see this message, you are using a non-frame-capable web client." + StringUtil.newLine + "</HTML>" + StringUtil.newLine;
    }

    private String htmlForBinaryPredicates(TestCaseEdit testCaseEdit, int n) {
        String string = "";
        if (testCaseEdit.getGeometry(1) != null) {
            string = string + this.htmlForRelateTest(testCaseEdit, n);
            string = string + this.htmlForPredicateTest(testCaseEdit, n, "equals", "A", "B");
            string = string + this.htmlForPredicateTest(testCaseEdit, n, "disjoint", "A", "B");
            string = string + this.htmlForPredicateTest(testCaseEdit, n, "intersects", "A", "B");
            string = string + this.htmlForPredicateTest(testCaseEdit, n, "touches", "A", "B");
            string = string + this.htmlForPredicateTest(testCaseEdit, n, "crosses", "A", "B");
            string = string + this.htmlForPredicateTest(testCaseEdit, n, "within", "A", "B");
            string = string + this.htmlForPredicateTest(testCaseEdit, n, "contains", "A", "B");
            string = string + this.htmlForPredicateTest(testCaseEdit, n, "overlaps", "A", "B");
            string = "<h2>Binary Predicates</h2>" + StringUtil.newLine + "<TABLE WIDTH=50% BORDER=1>" + StringUtil.newLine + string + "</TABLE>" + StringUtil.newLine;
        }
        return string;
    }

    private String htmlForSpatialFunctions(TestCaseEdit testCaseEdit, int n, int n2) {
        if (testCaseEdit.getExpectedConvexHull() == null && testCaseEdit.getExpectedIntersection() == null && testCaseEdit.getExpectedUnion() == null && testCaseEdit.getExpectedDifference() == null && testCaseEdit.getExpectedSymDifference() == null) {
            return "";
        }
        String string = "";
        string = string + this.htmlForSpatialFunctionTest(testCaseEdit, n, n2, "convexHull", "A", null);
        if (testCaseEdit.getGeometry(1) != null) {
            string = string + this.htmlForSpatialFunctionTest(testCaseEdit, n, n2, "intersection", "A", "B");
            string = string + this.htmlForSpatialFunctionTest(testCaseEdit, n, n2, "union", "A", "B");
            string = string + this.htmlForSpatialFunctionTest(testCaseEdit, n, n2, "difference", "A", "B");
            string = string + this.htmlForSpatialFunctionTest(testCaseEdit, n, n2, "symDifference", "A", "B");
        }
        string = "<h2>Spatial Analysis Methods</h2>" + StringUtil.newLine + "<TABLE BORDER=1>" + StringUtil.newLine + string + "</TABLE>" + StringUtil.newLine;
        return string;
    }

    private String htmlForTopologyMethods(TestCaseEdit testCaseEdit, int n, int n2) {
        boolean bl;
        boolean bl2 = this.expectedPredicateResult(testCaseEdit, "isSimple", "A", null) != null;
        boolean bl3 = testCaseEdit.getExpectedBoundary() != null;
        boolean bl4 = bl = this.expectedPredicateResult(testCaseEdit, "isValid", "A", null) != null;
        if (!(bl2 || bl3 || bl)) {
            return "";
        }
        String string = "";
        if (bl2) {
            string = string + this.htmlForPredicateTest(testCaseEdit, n2, "isSimple", "A", null);
        }
        if (bl) {
            string = string + this.htmlForPredicateTest(testCaseEdit, n2, "isValid", "A", null);
        }
        if (bl3) {
            string = string + this.htmlForSpatialFunctionTest(testCaseEdit, n, n2, "getBoundary", "A", null);
        }
        string = "<h2>Topology Methods (on A)</h2>" + StringUtil.newLine + "<TABLE BORDER=1>" + StringUtil.newLine + string + "</TABLE>" + StringUtil.newLine;
        return string;
    }

    private static class MapAndList {
        public Map map;
        public List list;

        private MapAndList() {
        }
    }
}

