/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jtstest.testrunner;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.util.Assert;
import com.vividsolutions.jtstest.geomop.GeometryOperation;
import com.vividsolutions.jtstest.testrunner.Result;
import com.vividsolutions.jtstest.testrunner.ResultMatcher;
import com.vividsolutions.jtstest.testrunner.StringUtil;
import com.vividsolutions.jtstest.testrunner.TestCase;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class Test
implements Runnable {
    private String description;
    private String operation;
    private Result expectedResult;
    private int testIndex;
    private String geometryIndex;
    private ArrayList arguments;
    private TestCase testCase;
    private boolean passed;
    private double tolerance;
    private Geometry targetGeometry;
    private Object[] operationArgs;
    private boolean isRun = false;
    private Result actualResult = null;
    private Exception exception = null;

    public Test(TestCase testCase, int n, String string, String string2, String string3, List list, Result result, double d) {
        this.tolerance = d;
        this.description = string;
        this.operation = string2;
        this.expectedResult = result;
        this.testIndex = n;
        this.geometryIndex = string3;
        this.arguments = new ArrayList(list);
        this.testCase = testCase;
    }

    public void setResult(Result result) {
        this.expectedResult = result;
    }

    public void setArgument(int n, String string) {
        this.arguments.set(n, string);
    }

    public String getDescription() {
        return this.description;
    }

    public String getGeometryIndex() {
        return this.geometryIndex;
    }

    public Result getExpectedResult() {
        return this.expectedResult;
    }

    public String getOperation() {
        return this.operation;
    }

    public int getTestIndex() {
        return this.testIndex;
    }

    public String getArgument(int n) {
        return (String)this.arguments.get(n);
    }

    public int getArgumentCount() {
        return this.arguments.size();
    }

    public boolean isPassed() {
        return this.passed;
    }

    public Exception getException() {
        return this.exception;
    }

    public TestCase getTestCase() {
        return this.testCase;
    }

    public void removeArgument(int n) {
        this.arguments.remove(n);
    }

    public void run() {
        try {
            this.exception = null;
            this.passed = this.computePassed();
        }
        catch (Exception exception) {
            this.exception = exception;
        }
    }

    public boolean computePassed() throws Exception {
        Result result = this.getActualResult();
        ResultMatcher resultMatcher = this.testCase.getTestRun().getResultMatcher();
        return resultMatcher.isMatch(this.targetGeometry, this.operation, this.operationArgs, result, this.expectedResult, this.tolerance);
    }

    public Result getActualResult() throws Exception {
        if (this.isRun) {
            return this.actualResult;
        }
        this.isRun = true;
        this.targetGeometry = this.geometryIndex.equalsIgnoreCase("A") ? this.testCase.getGeometryA() : this.testCase.getGeometryB();
        this.operationArgs = this.convertArgs(this.arguments);
        GeometryOperation geometryOperation = this.getGeometryOperation();
        this.actualResult = geometryOperation.invoke(this.operation, this.targetGeometry, this.operationArgs);
        return this.actualResult;
    }

    private GeometryOperation getGeometryOperation() {
        return this.testCase.getTestRun().getGeometryOperation();
    }

    public String toXml() {
        String string = "";
        string = string + "<test>" + StringUtil.newLine;
        if (this.description != null && this.description.length() > 0) {
            string = string + "  <desc>" + StringUtil.escapeHTML(this.description) + "</desc>" + StringUtil.newLine;
        }
        string = string + "  <op name=\"" + this.operation + "\"";
        string = string + " arg1=\"" + this.geometryIndex + "\"";
        int n = 2;
        Iterator iterator = this.arguments.iterator();
        while (iterator.hasNext()) {
            String string2 = (String)iterator.next();
            Assert.isTrue((string2 != null ? 1 : 0) != 0);
            string = string + " arg" + n + "=\"" + string2 + "\"";
            ++n;
        }
        string = string + ">" + StringUtil.newLine;
        string = string + StringUtil.indent(this.expectedResult.toFormattedString(), 4) + StringUtil.newLine;
        string = string + "  </op>" + StringUtil.newLine;
        string = string + "</test>" + StringUtil.newLine;
        return string;
    }

    private Object[] convertArgs(List list) {
        Object[] objectArray = new Object[list.size()];
        for (int i = 0; i < objectArray.length; ++i) {
            objectArray[i] = this.convertArgToGeomOrString((String)list.get(i));
        }
        return objectArray;
    }

    private Object convertArgToGeomOrString(String string) {
        if (string.equalsIgnoreCase("null")) {
            return null;
        }
        if (string.equalsIgnoreCase("A")) {
            return this.testCase.getGeometryA();
        }
        if (string.equalsIgnoreCase("B")) {
            return this.testCase.getGeometryB();
        }
        return string;
    }
}

