/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.algorithm;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryCollection;
import com.vividsolutions.jts.geom.LineString;

public class InteriorPointLine {
    private Coordinate centroid;
    private double minDistance = Double.MAX_VALUE;
    private Coordinate interiorPoint = null;

    public InteriorPointLine(Geometry geometry) {
        this.centroid = geometry.getCentroid().getCoordinate();
        this.addInterior(geometry);
        if (this.interiorPoint == null) {
            this.addEndpoints(geometry);
        }
    }

    public Coordinate getInteriorPoint() {
        return this.interiorPoint;
    }

    private void addInterior(Geometry geometry) {
        if (geometry instanceof LineString) {
            this.addInterior(geometry.getCoordinates());
        } else if (geometry instanceof GeometryCollection) {
            GeometryCollection geometryCollection = (GeometryCollection)geometry;
            for (int i = 0; i < geometryCollection.getNumGeometries(); ++i) {
                this.addInterior(geometryCollection.getGeometryN(i));
            }
        }
    }

    private void addInterior(Coordinate[] coordinateArray) {
        for (int i = 1; i < coordinateArray.length - 1; ++i) {
            this.add(coordinateArray[i]);
        }
    }

    private void addEndpoints(Geometry geometry) {
        if (geometry instanceof LineString) {
            this.addEndpoints(geometry.getCoordinates());
        } else if (geometry instanceof GeometryCollection) {
            GeometryCollection geometryCollection = (GeometryCollection)geometry;
            for (int i = 0; i < geometryCollection.getNumGeometries(); ++i) {
                this.addEndpoints(geometryCollection.getGeometryN(i));
            }
        }
    }

    private void addEndpoints(Coordinate[] coordinateArray) {
        this.add(coordinateArray[0]);
        this.add(coordinateArray[coordinateArray.length - 1]);
    }

    private void add(Coordinate coordinate) {
        double d = coordinate.distance(this.centroid);
        if (d < this.minDistance) {
            this.interiorPoint = new Coordinate(coordinate);
            this.minDistance = d;
        }
    }
}

