/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.algorithm;

import com.vividsolutions.jts.algorithm.PointInRing;
import com.vividsolutions.jts.algorithm.RobustDeterminant;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.CoordinateArrays;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.LineSegment;
import com.vividsolutions.jts.geom.LinearRing;
import com.vividsolutions.jts.index.bintree.Bintree;
import com.vividsolutions.jts.index.bintree.Interval;
import com.vividsolutions.jts.index.chain.MonotoneChain;
import com.vividsolutions.jts.index.chain.MonotoneChainBuilder;
import com.vividsolutions.jts.index.chain.MonotoneChainSelectAction;
import java.util.Iterator;
import java.util.List;

public class MCPointInRing
implements PointInRing {
    private LinearRing ring;
    private Bintree tree;
    private int crossings = 0;
    private Interval interval = new Interval();

    public MCPointInRing(LinearRing linearRing) {
        this.ring = linearRing;
        this.buildIndex();
    }

    private void buildIndex() {
        Envelope envelope = this.ring.getEnvelopeInternal();
        this.tree = new Bintree();
        Coordinate[] coordinateArray = CoordinateArrays.removeRepeatedPoints(this.ring.getCoordinates());
        List list = MonotoneChainBuilder.getChains(coordinateArray);
        for (int i = 0; i < list.size(); ++i) {
            MonotoneChain monotoneChain = (MonotoneChain)list.get(i);
            Envelope envelope2 = monotoneChain.getEnvelope();
            this.interval.min = envelope2.getMinY();
            this.interval.max = envelope2.getMaxY();
            this.tree.insert(this.interval, monotoneChain);
        }
    }

    public boolean isInside(Coordinate coordinate) {
        this.crossings = 0;
        Envelope envelope = new Envelope(Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, coordinate.y, coordinate.y);
        this.interval.min = coordinate.y;
        this.interval.max = coordinate.y;
        List list = this.tree.query(this.interval);
        MCSelecter mCSelecter = new MCSelecter(coordinate);
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            MonotoneChain monotoneChain = (MonotoneChain)iterator.next();
            this.testMonotoneChain(envelope, mCSelecter, monotoneChain);
        }
        return this.crossings % 2 == 1;
    }

    private void testMonotoneChain(Envelope envelope, MCSelecter mCSelecter, MonotoneChain monotoneChain) {
        monotoneChain.select(envelope, mCSelecter);
    }

    private void testLineSegment(Coordinate coordinate, LineSegment lineSegment) {
        double d;
        Coordinate coordinate2 = lineSegment.p0;
        Coordinate coordinate3 = lineSegment.p1;
        double d2 = coordinate2.x - coordinate.x;
        double d3 = coordinate2.y - coordinate.y;
        double d4 = coordinate3.x - coordinate.x;
        double d5 = coordinate3.y - coordinate.y;
        if ((d3 > 0.0 && d5 <= 0.0 || d5 > 0.0 && d3 <= 0.0) && 0.0 < (d = (double)RobustDeterminant.signOfDet2x2(d2, d3, d4, d5) / (d5 - d3))) {
            ++this.crossings;
        }
    }

    class MCSelecter
    extends MonotoneChainSelectAction {
        Coordinate p;

        public MCSelecter(Coordinate coordinate) {
            this.p = coordinate;
        }

        public void select(LineSegment lineSegment) {
            MCPointInRing.this.testLineSegment(this.p, lineSegment);
        }
    }
}

