/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.algorithm;

import com.vividsolutions.jts.algorithm.PointInRing;
import com.vividsolutions.jts.algorithm.RobustDeterminant;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.LineSegment;
import com.vividsolutions.jts.geom.LinearRing;
import com.vividsolutions.jts.index.strtree.SIRtree;
import java.util.Iterator;
import java.util.List;

public class SIRtreePointInRing
implements PointInRing {
    private LinearRing ring;
    private SIRtree sirTree;
    private int crossings = 0;

    public SIRtreePointInRing(LinearRing linearRing) {
        this.ring = linearRing;
        this.buildIndex();
    }

    private void buildIndex() {
        Envelope envelope = this.ring.getEnvelopeInternal();
        this.sirTree = new SIRtree();
        Coordinate[] coordinateArray = this.ring.getCoordinates();
        for (int i = 1; i < coordinateArray.length; ++i) {
            if (coordinateArray[i - 1].equals(coordinateArray[i])) continue;
            LineSegment lineSegment = new LineSegment(coordinateArray[i - 1], coordinateArray[i]);
            this.sirTree.insert(lineSegment.p0.y, lineSegment.p1.y, lineSegment);
        }
    }

    public boolean isInside(Coordinate coordinate) {
        this.crossings = 0;
        List list = this.sirTree.query(coordinate.y);
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            LineSegment lineSegment = (LineSegment)iterator.next();
            this.testLineSegment(coordinate, lineSegment);
        }
        return this.crossings % 2 == 1;
    }

    private void testLineSegment(Coordinate coordinate, LineSegment lineSegment) {
        double d;
        Coordinate coordinate2 = lineSegment.p0;
        Coordinate coordinate3 = lineSegment.p1;
        double d2 = coordinate2.x - coordinate.x;
        double d3 = coordinate2.y - coordinate.y;
        double d4 = coordinate3.x - coordinate.x;
        double d5 = coordinate3.y - coordinate.y;
        if ((d3 > 0.0 && d5 <= 0.0 || d5 > 0.0 && d3 <= 0.0) && 0.0 < (d = (double)RobustDeterminant.signOfDet2x2(d2, d3, d4, d5) / (d5 - d3))) {
            ++this.crossings;
        }
    }
}

