/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.geomgraph;

import com.vividsolutions.jts.algorithm.CGAlgorithms;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geomgraph.DirectedEdge;
import com.vividsolutions.jts.geomgraph.DirectedEdgeStar;
import com.vividsolutions.jts.geomgraph.Edge;
import com.vividsolutions.jts.geomgraph.EdgeEnd;
import com.vividsolutions.jts.geomgraph.Label;
import com.vividsolutions.jts.geomgraph.Node;
import com.vividsolutions.jts.geomgraph.NodeFactory;
import com.vividsolutions.jts.geomgraph.NodeMap;
import com.vividsolutions.jts.geomgraph.Quadrant;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public class PlanarGraph {
    public static final CGAlgorithms cga = new CGAlgorithms();
    protected List edges = new ArrayList();
    protected NodeMap nodes;
    protected List edgeEndList = new ArrayList();

    public static void linkResultDirectedEdges(Collection collection) {
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            Node node = (Node)iterator.next();
            ((DirectedEdgeStar)node.getEdges()).linkResultDirectedEdges();
        }
    }

    public PlanarGraph(NodeFactory nodeFactory) {
        this.nodes = new NodeMap(nodeFactory);
    }

    public PlanarGraph() {
        this.nodes = new NodeMap(new NodeFactory());
    }

    public Iterator getEdgeIterator() {
        return this.edges.iterator();
    }

    public Collection getEdgeEnds() {
        return this.edgeEndList;
    }

    public boolean isBoundaryNode(int n, Coordinate coordinate) {
        Node node = this.nodes.find(coordinate);
        if (node == null) {
            return false;
        }
        Label label = node.getLabel();
        return label != null && label.getLocation(n) == 1;
    }

    protected void insertEdge(Edge edge) {
        this.edges.add(edge);
    }

    public void add(EdgeEnd edgeEnd) {
        this.nodes.add(edgeEnd);
        this.edgeEndList.add(edgeEnd);
    }

    public Iterator getNodeIterator() {
        return this.nodes.iterator();
    }

    public Collection getNodes() {
        return this.nodes.values();
    }

    public Node addNode(Node node) {
        return this.nodes.addNode(node);
    }

    public Node addNode(Coordinate coordinate) {
        return this.nodes.addNode(coordinate);
    }

    public Node find(Coordinate coordinate) {
        return this.nodes.find(coordinate);
    }

    public void addEdges(List list) {
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Edge edge = (Edge)iterator.next();
            this.edges.add(edge);
            DirectedEdge directedEdge = new DirectedEdge(edge, true);
            DirectedEdge directedEdge2 = new DirectedEdge(edge, false);
            directedEdge.setSym(directedEdge2);
            directedEdge2.setSym(directedEdge);
            this.add(directedEdge);
            this.add(directedEdge2);
        }
    }

    public void linkResultDirectedEdges() {
        Iterator iterator = this.nodes.iterator();
        while (iterator.hasNext()) {
            Node node = (Node)iterator.next();
            ((DirectedEdgeStar)node.getEdges()).linkResultDirectedEdges();
        }
    }

    public void linkAllDirectedEdges() {
        Iterator iterator = this.nodes.iterator();
        while (iterator.hasNext()) {
            Node node = (Node)iterator.next();
            ((DirectedEdgeStar)node.getEdges()).linkAllDirectedEdges();
        }
    }

    public EdgeEnd findEdgeEnd(Edge edge) {
        Iterator iterator = this.getEdgeEnds().iterator();
        while (iterator.hasNext()) {
            EdgeEnd edgeEnd = (EdgeEnd)iterator.next();
            if (edgeEnd.getEdge() != edge) continue;
            return edgeEnd;
        }
        return null;
    }

    public Edge findEdge(Coordinate coordinate, Coordinate coordinate2) {
        for (int i = 0; i < this.edges.size(); ++i) {
            Edge edge = (Edge)this.edges.get(i);
            Coordinate[] coordinateArray = edge.getCoordinates();
            if (!coordinate.equals(coordinateArray[0]) || !coordinate2.equals(coordinateArray[1])) continue;
            return edge;
        }
        return null;
    }

    public Edge findEdgeInSameDirection(Coordinate coordinate, Coordinate coordinate2) {
        for (int i = 0; i < this.edges.size(); ++i) {
            Edge edge = (Edge)this.edges.get(i);
            Coordinate[] coordinateArray = edge.getCoordinates();
            if (this.matchInSameDirection(coordinate, coordinate2, coordinateArray[0], coordinateArray[1])) {
                return edge;
            }
            if (!this.matchInSameDirection(coordinate, coordinate2, coordinateArray[coordinateArray.length - 1], coordinateArray[coordinateArray.length - 2])) continue;
            return edge;
        }
        return null;
    }

    private boolean matchInSameDirection(Coordinate coordinate, Coordinate coordinate2, Coordinate coordinate3, Coordinate coordinate4) {
        if (!coordinate.equals(coordinate3)) {
            return false;
        }
        return CGAlgorithms.computeOrientation(coordinate, coordinate2, coordinate4) == 0 && Quadrant.quadrant(coordinate, coordinate2) == Quadrant.quadrant(coordinate3, coordinate4);
    }

    public void printEdges(PrintStream printStream) {
        printStream.println("Edges:");
        for (int i = 0; i < this.edges.size(); ++i) {
            printStream.println("edge " + i + ":");
            Edge edge = (Edge)this.edges.get(i);
            edge.print(printStream);
            edge.eiList.print(printStream);
        }
    }

    void debugPrint(Object object) {
        System.out.print(object);
    }

    void debugPrintln(Object object) {
        System.out.println(object);
    }
}

