/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.noding.snapround;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.noding.SegmentString;

public class SegmentSnapper {
    private static double TOLERANCE = 0.5;

    public static boolean isWithinTolerance(Coordinate coordinate, Coordinate coordinate2, Coordinate coordinate3) {
        double d = coordinate.x - TOLERANCE;
        double d2 = coordinate.x + TOLERANCE;
        double d3 = coordinate.y - TOLERANCE;
        double d4 = coordinate.y + TOLERANCE;
        double d5 = Math.min(coordinate2.x, coordinate3.x);
        double d6 = Math.max(coordinate2.x, coordinate3.x);
        double d7 = Math.min(coordinate2.y, coordinate3.y);
        double d8 = Math.max(coordinate2.y, coordinate3.y);
        if (d2 < d5 || d > d6 || d4 < d7 || d3 > d8) {
            return false;
        }
        double d9 = coordinate3.x - coordinate2.x;
        double d10 = coordinate3.y - coordinate2.y;
        double d11 = coordinate.x - coordinate2.x;
        double d12 = coordinate.y - coordinate2.y;
        double d13 = d11 * d10 / d9 - d12;
        double d14 = d12 * d9 / d10 - d11;
        double d15 = d11 * d10 - d12 * d9;
        if (Math.abs(d15) < Math.abs(0.5 * d9)) {
            return true;
        }
        double d16 = d12 * d9 - d11 * d10;
        return Math.abs(d16) < Math.abs(0.5 * d10);
    }

    public boolean addSnappedNode(Coordinate coordinate, SegmentString segmentString, int n) {
        Coordinate coordinate2 = segmentString.getCoordinate(n);
        Coordinate coordinate3 = segmentString.getCoordinate(n + 1);
        if (coordinate.equals(coordinate2)) {
            return false;
        }
        if (coordinate.equals(coordinate3)) {
            return false;
        }
        if (SegmentSnapper.isWithinTolerance(coordinate, coordinate2, coordinate3)) {
            segmentString.addIntersection(coordinate, n);
            return true;
        }
        return false;
    }
}

