/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.operation.buffer;

import com.vividsolutions.jts.algorithm.CGAlgorithms;
import com.vividsolutions.jts.algorithm.RobustCGAlgorithms;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryCollection;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.PrecisionModel;
import com.vividsolutions.jts.geomgraph.Edge;
import com.vividsolutions.jts.geomgraph.EdgeList;
import com.vividsolutions.jts.geomgraph.Label;
import com.vividsolutions.jts.geomgraph.Node;
import com.vividsolutions.jts.geomgraph.PlanarGraph;
import com.vividsolutions.jts.noding.IteratedNoder;
import com.vividsolutions.jts.noding.SegmentString;
import com.vividsolutions.jts.operation.buffer.BufferSubgraph;
import com.vividsolutions.jts.operation.buffer.OffsetCurveBuilder;
import com.vividsolutions.jts.operation.buffer.OffsetCurveSetBuilder;
import com.vividsolutions.jts.operation.buffer.SubgraphDepthLocater;
import com.vividsolutions.jts.operation.overlay.OverlayNodeFactory;
import com.vividsolutions.jts.operation.overlay.PolygonBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class BufferBuilder {
    private final CGAlgorithms cga = new RobustCGAlgorithms();
    private int quadrantSegments = 8;
    private int endCapStyle = 1;
    private PrecisionModel workingPrecisionModel;
    private GeometryFactory geomFact;
    private PlanarGraph graph;
    private EdgeList edgeList = new EdgeList();

    private static int depthDelta(Label label) {
        int n = label.getLocation(0, 1);
        int n2 = label.getLocation(0, 2);
        if (n == 0 && n2 == 2) {
            return 1;
        }
        if (n == 2 && n2 == 0) {
            return -1;
        }
        return 0;
    }

    public void setQuadrantSegments(int n) {
        this.quadrantSegments = n;
    }

    public void setWorkingPrecisionModel(PrecisionModel precisionModel) {
        this.workingPrecisionModel = precisionModel;
    }

    public void setEndCapStyle(int n) {
        this.endCapStyle = n;
    }

    public Geometry buffer(Geometry geometry, double d) {
        PrecisionModel precisionModel = this.workingPrecisionModel;
        if (precisionModel == null) {
            precisionModel = geometry.getPrecisionModel();
        }
        this.geomFact = geometry.getFactory();
        OffsetCurveBuilder offsetCurveBuilder = new OffsetCurveBuilder(precisionModel, this.quadrantSegments);
        offsetCurveBuilder.setEndCapStyle(this.endCapStyle);
        OffsetCurveSetBuilder offsetCurveSetBuilder = new OffsetCurveSetBuilder(geometry, d, offsetCurveBuilder);
        List list = offsetCurveSetBuilder.getCurves();
        if (list.size() <= 0) {
            GeometryCollection geometryCollection = this.geomFact.createGeometryCollection(new Geometry[0]);
            return geometryCollection;
        }
        this.computeNodedEdges(list, precisionModel);
        this.graph = new PlanarGraph(new OverlayNodeFactory());
        this.graph.addEdges(this.edgeList.getEdges());
        List list2 = this.createSubgraphs(this.graph);
        PolygonBuilder polygonBuilder = new PolygonBuilder(this.geomFact, this.cga);
        this.buildSubgraphs(list2, polygonBuilder);
        List list3 = polygonBuilder.getPolygons();
        Geometry geometry2 = this.geomFact.buildGeometry(list3);
        return geometry2;
    }

    private void computeNodedEdges(List list, PrecisionModel precisionModel) {
        IteratedNoder iteratedNoder = new IteratedNoder(precisionModel);
        Collection collection = iteratedNoder.node(list);
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            SegmentString segmentString = (SegmentString)iterator.next();
            Label label = (Label)segmentString.getContext();
            Edge edge = new Edge(segmentString.getCoordinates(), new Label(label));
            this.insertEdge(edge);
        }
    }

    protected void insertEdge(Edge edge) {
        Edge edge2 = this.edgeList.findEqualEdge(edge);
        if (edge2 != null) {
            Label label = edge2.getLabel();
            Label label2 = edge.getLabel();
            if (!edge2.isPointwiseEqual(edge)) {
                label2 = new Label(edge.getLabel());
                label2.flip();
            }
            label.merge(label2);
            int n = BufferBuilder.depthDelta(label2);
            int n2 = edge2.getDepthDelta();
            int n3 = n2 + n;
            edge2.setDepthDelta(n3);
        } else {
            this.edgeList.add(edge);
            edge.setDepthDelta(BufferBuilder.depthDelta(edge.getLabel()));
        }
    }

    private List createSubgraphs(PlanarGraph planarGraph) {
        ArrayList<BufferSubgraph> arrayList = new ArrayList<BufferSubgraph>();
        Iterator iterator = planarGraph.getNodes().iterator();
        while (iterator.hasNext()) {
            Node node = (Node)iterator.next();
            if (node.isVisited()) continue;
            BufferSubgraph bufferSubgraph = new BufferSubgraph(this.cga);
            bufferSubgraph.create(node);
            arrayList.add(bufferSubgraph);
        }
        Collections.sort(arrayList, Collections.reverseOrder());
        return arrayList;
    }

    private void buildSubgraphs(List list, PolygonBuilder polygonBuilder) {
        ArrayList<BufferSubgraph> arrayList = new ArrayList<BufferSubgraph>();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            BufferSubgraph bufferSubgraph = (BufferSubgraph)iterator.next();
            Coordinate coordinate = bufferSubgraph.getRightmostCoordinate();
            SubgraphDepthLocater subgraphDepthLocater = new SubgraphDepthLocater(arrayList);
            int n = subgraphDepthLocater.getDepth(coordinate);
            bufferSubgraph.computeDepth(n);
            bufferSubgraph.findResultEdges();
            arrayList.add(bufferSubgraph);
            polygonBuilder.add(bufferSubgraph.getDirectedEdges(), bufferSubgraph.getNodes());
        }
    }
}

