/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.operation.buffer;

import com.vividsolutions.jts.algorithm.CGAlgorithms;
import com.vividsolutions.jts.algorithm.LineIntersector;
import com.vividsolutions.jts.algorithm.RobustCGAlgorithms;
import com.vividsolutions.jts.algorithm.RobustLineIntersector;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.LineSegment;
import com.vividsolutions.jts.geom.PrecisionModel;
import java.util.ArrayList;
import java.util.List;

public class OffsetCurveBuilder {
    private static double PI_OVER_2 = 1.5707963267948966;
    public static final int DEFAULT_QUADRANT_SEGMENTS = 8;
    private static final Coordinate[] arrayTypeCoordinate = new Coordinate[0];
    private CGAlgorithms cga = new RobustCGAlgorithms();
    private LineIntersector li;
    private double filletAngleQuantum;
    private double maxCurveSegmentError = 0.0;
    private ArrayList ptList;
    private double distance = 0.0;
    private PrecisionModel precisionModel;
    private int endCapStyle = 1;
    private int joinStyle;
    private Coordinate s0;
    private Coordinate s1;
    private Coordinate s2;
    private LineSegment seg0 = new LineSegment();
    private LineSegment seg1 = new LineSegment();
    private LineSegment offset0 = new LineSegment();
    private LineSegment offset1 = new LineSegment();
    private int side = 0;
    private static double MAX_CLOSING_SEG_LEN = 3.0;

    public OffsetCurveBuilder(PrecisionModel precisionModel) {
        this(precisionModel, 8);
    }

    public OffsetCurveBuilder(PrecisionModel precisionModel, int n) {
        this.precisionModel = precisionModel;
        this.li = new RobustLineIntersector();
        int n2 = n < 1 ? 1 : n;
        this.filletAngleQuantum = 1.5707963267948966 / (double)n2;
    }

    public void setEndCapStyle(int n) {
        this.endCapStyle = n;
    }

    public List getLineCurve(Coordinate[] coordinateArray, double d) {
        ArrayList<Coordinate[]> arrayList = new ArrayList<Coordinate[]>();
        if (d <= 0.0) {
            return arrayList;
        }
        this.init(d);
        if (coordinateArray.length <= 1) {
            switch (this.endCapStyle) {
                case 1: {
                    this.addCircle(coordinateArray[0], d);
                    break;
                }
                case 3: {
                    this.addSquare(coordinateArray[0], d);
                }
            }
        } else {
            this.computeLineBufferCurve(coordinateArray);
        }
        Coordinate[] coordinateArray2 = this.getCoordinates();
        arrayList.add(coordinateArray2);
        return arrayList;
    }

    public List getRingCurve(Coordinate[] coordinateArray, int n, double d) {
        ArrayList<Coordinate[]> arrayList = new ArrayList<Coordinate[]>();
        this.init(d);
        if (coordinateArray.length <= 2) {
            return this.getLineCurve(coordinateArray, d);
        }
        if (d == 0.0) {
            arrayList.add(OffsetCurveBuilder.copyCoordinates(coordinateArray));
            return arrayList;
        }
        this.computeRingBufferCurve(coordinateArray, n);
        arrayList.add(this.getCoordinates());
        return arrayList;
    }

    private static Coordinate[] copyCoordinates(Coordinate[] coordinateArray) {
        Coordinate[] coordinateArray2 = new Coordinate[coordinateArray.length];
        for (int i = 0; i < coordinateArray2.length; ++i) {
            coordinateArray2[i] = new Coordinate(coordinateArray[i]);
        }
        return coordinateArray2;
    }

    private void init(double d) {
        this.distance = d;
        this.maxCurveSegmentError = d * (1.0 - Math.cos(this.filletAngleQuantum / 2.0));
        this.ptList = new ArrayList();
    }

    private Coordinate[] getCoordinates() {
        Coordinate coordinate;
        Coordinate[] coordinateArray;
        if (this.ptList.size() > 1 && !(coordinateArray = (Coordinate[])this.ptList.get(0)).equals(coordinate = (Coordinate)this.ptList.get(1))) {
            this.addPt((Coordinate)coordinateArray);
        }
        coordinateArray = this.ptList.toArray(arrayTypeCoordinate);
        return coordinateArray;
    }

    private void computeLineBufferCurve(Coordinate[] coordinateArray) {
        int n;
        int n2 = coordinateArray.length - 1;
        this.initSideSegments(coordinateArray[0], coordinateArray[1], 1);
        for (n = 2; n <= n2; ++n) {
            this.addNextSegment(coordinateArray[n], true);
        }
        this.addLastSegment();
        this.addLineEndCap(coordinateArray[n2 - 1], coordinateArray[n2]);
        this.initSideSegments(coordinateArray[n2], coordinateArray[n2 - 1], 1);
        for (n = n2 - 2; n >= 0; --n) {
            this.addNextSegment(coordinateArray[n], true);
        }
        this.addLastSegment();
        this.addLineEndCap(coordinateArray[1], coordinateArray[0]);
        this.closePts();
    }

    private void computeRingBufferCurve(Coordinate[] coordinateArray, int n) {
        int n2 = coordinateArray.length - 1;
        this.initSideSegments(coordinateArray[n2 - 1], coordinateArray[0], n);
        for (int i = 1; i <= n2; ++i) {
            boolean bl = i != 1;
            this.addNextSegment(coordinateArray[i], bl);
        }
        this.closePts();
    }

    private void addPt(Coordinate coordinate) {
        Coordinate coordinate2 = new Coordinate(coordinate);
        this.precisionModel.makePrecise(coordinate2);
        Coordinate coordinate3 = null;
        if (this.ptList.size() >= 1) {
            coordinate3 = (Coordinate)this.ptList.get(this.ptList.size() - 1);
        }
        if (coordinate3 != null && coordinate2.equals(coordinate3)) {
            return;
        }
        this.ptList.add(coordinate2);
    }

    private void closePts() {
        if (this.ptList.size() < 1) {
            return;
        }
        Coordinate coordinate = new Coordinate((Coordinate)this.ptList.get(0));
        Coordinate coordinate2 = (Coordinate)this.ptList.get(this.ptList.size() - 1);
        Coordinate coordinate3 = null;
        if (this.ptList.size() >= 2) {
            coordinate3 = (Coordinate)this.ptList.get(this.ptList.size() - 2);
        }
        if (coordinate.equals(coordinate2)) {
            return;
        }
        this.ptList.add(coordinate);
    }

    private void initSideSegments(Coordinate coordinate, Coordinate coordinate2, int n) {
        this.s1 = coordinate;
        this.s2 = coordinate2;
        this.side = n;
        this.seg1.setCoordinates(coordinate, coordinate2);
        this.computeOffsetSegment(this.seg1, n, this.distance, this.offset1);
    }

    private void addNextSegment(Coordinate coordinate, boolean bl) {
        boolean bl2;
        this.s0 = this.s1;
        this.s1 = this.s2;
        this.s2 = coordinate;
        this.seg0.setCoordinates(this.s0, this.s1);
        this.computeOffsetSegment(this.seg0, this.side, this.distance, this.offset0);
        this.seg1.setCoordinates(this.s1, this.s2);
        this.computeOffsetSegment(this.seg1, this.side, this.distance, this.offset1);
        if (this.s1.equals(this.s2)) {
            return;
        }
        int n = CGAlgorithms.computeOrientation(this.s0, this.s1, this.s2);
        boolean bl3 = bl2 = n == -1 && this.side == 1 || n == 1 && this.side == 2;
        if (n == 0) {
            this.li.computeIntersection(this.s0, this.s1, this.s1, this.s2);
            int n2 = this.li.getIntersectionNum();
            if (n2 >= 2) {
                this.addFillet(this.s1, this.offset0.p1, this.offset1.p0, -1, this.distance);
            }
        } else if (bl2) {
            if (bl) {
                this.addPt(this.offset0.p1);
            }
            this.addFillet(this.s1, this.offset0.p1, this.offset1.p0, n, this.distance);
            this.addPt(this.offset1.p0);
        } else {
            this.li.computeIntersection(this.offset0.p0, this.offset0.p1, this.offset1.p0, this.offset1.p1);
            if (this.li.hasIntersection()) {
                this.addPt(this.li.getIntersection(0));
            } else if (this.offset0.p1.distance(this.offset1.p0) < this.distance / 1000.0) {
                this.addPt(this.offset0.p1);
            } else {
                this.addPt(this.offset0.p1);
                this.addPt(this.s1);
                this.addPt(this.offset1.p0);
            }
        }
    }

    private void addLastSegment() {
        this.addPt(this.offset1.p1);
    }

    private void computeOffsetSegment(LineSegment lineSegment, int n, double d, LineSegment lineSegment2) {
        int n2 = n == 1 ? 1 : -1;
        double d2 = lineSegment.p1.x - lineSegment.p0.x;
        double d3 = lineSegment.p1.y - lineSegment.p0.y;
        double d4 = Math.sqrt(d2 * d2 + d3 * d3);
        double d5 = (double)n2 * d * d2 / d4;
        double d6 = (double)n2 * d * d3 / d4;
        lineSegment2.p0.x = lineSegment.p0.x - d6;
        lineSegment2.p0.y = lineSegment.p0.y + d5;
        lineSegment2.p1.x = lineSegment.p1.x - d6;
        lineSegment2.p1.y = lineSegment.p1.y + d5;
    }

    private void addLineEndCap(Coordinate coordinate, Coordinate coordinate2) {
        LineSegment lineSegment = new LineSegment(coordinate, coordinate2);
        LineSegment lineSegment2 = new LineSegment();
        this.computeOffsetSegment(lineSegment, 1, this.distance, lineSegment2);
        LineSegment lineSegment3 = new LineSegment();
        this.computeOffsetSegment(lineSegment, 2, this.distance, lineSegment3);
        double d = coordinate2.x - coordinate.x;
        double d2 = coordinate2.y - coordinate.y;
        double d3 = Math.atan2(d2, d);
        switch (this.endCapStyle) {
            case 1: {
                this.addPt(lineSegment2.p1);
                this.addFillet(coordinate2, d3 + 1.5707963267948966, d3 - 1.5707963267948966, -1, this.distance);
                this.addPt(lineSegment3.p1);
                break;
            }
            case 2: {
                this.addPt(lineSegment2.p1);
                this.addPt(lineSegment3.p1);
                break;
            }
            case 3: {
                Coordinate coordinate3 = new Coordinate();
                coordinate3.x = Math.abs(this.distance) * Math.cos(d3);
                coordinate3.y = Math.abs(this.distance) * Math.sin(d3);
                Coordinate coordinate4 = new Coordinate(lineSegment2.p1.x + coordinate3.x, lineSegment2.p1.y + coordinate3.y);
                Coordinate coordinate5 = new Coordinate(lineSegment3.p1.x + coordinate3.x, lineSegment3.p1.y + coordinate3.y);
                this.addPt(coordinate4);
                this.addPt(coordinate5);
            }
        }
    }

    private void addFillet(Coordinate coordinate, Coordinate coordinate2, Coordinate coordinate3, int n, double d) {
        double d2 = coordinate2.x - coordinate.x;
        double d3 = coordinate2.y - coordinate.y;
        double d4 = Math.atan2(d3, d2);
        double d5 = coordinate3.x - coordinate.x;
        double d6 = coordinate3.y - coordinate.y;
        double d7 = Math.atan2(d6, d5);
        if (n == -1) {
            if (d4 <= d7) {
                d4 += Math.PI * 2;
            }
        } else if (d4 >= d7) {
            d4 -= Math.PI * 2;
        }
        this.addPt(coordinate2);
        this.addFillet(coordinate, d4, d7, n, d);
        this.addPt(coordinate3);
    }

    private void addFillet(Coordinate coordinate, double d, double d2, int n, double d3) {
        int n2 = n == -1 ? -1 : 1;
        double d4 = Math.abs(d - d2);
        int n3 = (int)(d4 / this.filletAngleQuantum + 0.5);
        if (n3 < 1) {
            return;
        }
        double d5 = 0.0;
        double d6 = d4 / (double)n3;
        Coordinate coordinate2 = new Coordinate();
        for (double d7 = d5; d7 < d4; d7 += d6) {
            double d8 = d + (double)n2 * d7;
            coordinate2.x = coordinate.x + d3 * Math.cos(d8);
            coordinate2.y = coordinate.y + d3 * Math.sin(d8);
            this.addPt(coordinate2);
        }
    }

    private void addCircle(Coordinate coordinate, double d) {
        Coordinate coordinate2 = new Coordinate(coordinate.x + d, coordinate.y);
        this.addPt(coordinate2);
        this.addFillet(coordinate, 0.0, Math.PI * 2, -1, d);
    }

    private void addSquare(Coordinate coordinate, double d) {
        this.addPt(new Coordinate(coordinate.x + d, coordinate.y + d));
        this.addPt(new Coordinate(coordinate.x + d, coordinate.y - d));
        this.addPt(new Coordinate(coordinate.x - d, coordinate.y - d));
        this.addPt(new Coordinate(coordinate.x - d, coordinate.y + d));
        this.addPt(new Coordinate(coordinate.x + d, coordinate.y + d));
    }
}

