/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.operation.buffer;

import com.vividsolutions.jts.algorithm.CGAlgorithms;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geomgraph.DirectedEdge;
import com.vividsolutions.jts.geomgraph.DirectedEdgeStar;
import com.vividsolutions.jts.geomgraph.Edge;
import com.vividsolutions.jts.geomgraph.Node;
import com.vividsolutions.jts.util.Assert;
import java.util.Iterator;
import java.util.List;

public class RightmostEdgeFinder {
    private CGAlgorithms cga;
    private int minIndex = -1;
    private Coordinate minCoord = null;
    private DirectedEdge minDe = null;
    private DirectedEdge orientedDe = null;

    public RightmostEdgeFinder(CGAlgorithms cGAlgorithms) {
        this.cga = cGAlgorithms;
    }

    public DirectedEdge getEdge() {
        return this.orientedDe;
    }

    public Coordinate getCoordinate() {
        return this.minCoord;
    }

    public void findEdge(List list) {
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            DirectedEdge directedEdge = (DirectedEdge)iterator.next();
            if (!directedEdge.isForward()) continue;
            this.checkForRightmostCoordinate(directedEdge);
        }
        Assert.isTrue(this.minIndex != 0 || this.minCoord.equals(this.minDe.getCoordinate()), "inconsistency in rightmost processing");
        if (this.minIndex == 0) {
            this.findRightmostEdgeAtNode();
        } else {
            this.findRightmostEdgeAtVertex();
        }
        this.orientedDe = this.minDe;
        int n = this.getRightmostSide(this.minDe, this.minIndex);
        if (n == 1) {
            this.orientedDe = this.minDe.getSym();
        }
    }

    private void findRightmostEdgeAtNode() {
        Node node = this.minDe.getNode();
        DirectedEdgeStar directedEdgeStar = (DirectedEdgeStar)node.getEdges();
        this.minDe = directedEdgeStar.getRightmostEdge();
        if (!this.minDe.isForward()) {
            this.minDe = this.minDe.getSym();
            this.minIndex = this.minDe.getEdge().getCoordinates().length - 1;
        }
    }

    private void findRightmostEdgeAtVertex() {
        Coordinate[] coordinateArray = this.minDe.getEdge().getCoordinates();
        Assert.isTrue(this.minIndex > 0 && this.minIndex < coordinateArray.length, "rightmost point expected to be interior vertex of edge");
        Coordinate coordinate = coordinateArray[this.minIndex - 1];
        Coordinate coordinate2 = coordinateArray[this.minIndex + 1];
        int n = CGAlgorithms.computeOrientation(this.minCoord, coordinate2, coordinate);
        boolean bl = false;
        if (coordinate.y < this.minCoord.y && coordinate2.y < this.minCoord.y && n == 1) {
            bl = true;
        } else if (coordinate.y > this.minCoord.y && coordinate2.y > this.minCoord.y && n == -1) {
            bl = true;
        }
        if (bl) {
            --this.minIndex;
        }
    }

    private void checkForRightmostCoordinate(DirectedEdge directedEdge) {
        Coordinate[] coordinateArray = directedEdge.getEdge().getCoordinates();
        for (int i = 0; i < coordinateArray.length - 1; ++i) {
            if (this.minCoord != null && !(coordinateArray[i].x > this.minCoord.x)) continue;
            this.minDe = directedEdge;
            this.minIndex = i;
            this.minCoord = coordinateArray[i];
        }
    }

    private int getRightmostSide(DirectedEdge directedEdge, int n) {
        int n2 = this.getRightmostSideOfSegment(directedEdge, n);
        if (n2 < 0) {
            n2 = this.getRightmostSideOfSegment(directedEdge, n - 1);
        }
        if (n2 < 0) {
            this.minCoord = null;
            this.checkForRightmostCoordinate(directedEdge);
        }
        return n2;
    }

    private int getRightmostSideOfSegment(DirectedEdge directedEdge, int n) {
        Edge edge = directedEdge.getEdge();
        Coordinate[] coordinateArray = edge.getCoordinates();
        if (n < 0 || n + 1 >= coordinateArray.length) {
            return -1;
        }
        if (coordinateArray[n].y == coordinateArray[n + 1].y) {
            return -1;
        }
        int n2 = 1;
        if (coordinateArray[n].y < coordinateArray[n + 1].y) {
            n2 = 2;
        }
        return n2;
    }
}

