/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.util;

import java.io.PrintStream;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Iterator;

public class Debug {
    private static boolean debugOn = true;
    private static Debug debug = new Debug();
    private static final String DEBUG_LINE_TAG = "D! ";
    private PrintStream out;
    private Class[] printArgs;
    private Object watchObj = null;
    private Object[] args = new Object[1];

    public static void print(String string) {
        if (!debugOn) {
            return;
        }
        debug.instancePrint(string);
    }

    public static void print(Object object) {
        if (!debugOn) {
            return;
        }
        debug.instancePrint(object);
    }

    public static void print(boolean bl, Object object) {
        if (!debugOn) {
            return;
        }
        if (!bl) {
            return;
        }
        debug.instancePrint(object);
    }

    public static void println(Object object) {
        if (!debugOn) {
            return;
        }
        debug.instancePrint(object);
        debug.println();
    }

    public static void addWatch(Object object) {
        debug.instanceAddWatch(object);
    }

    public static void printWatch() {
        debug.instancePrintWatch();
    }

    public static void printIfWatch(Object object) {
        debug.instancePrintIfWatch(object);
    }

    private Debug() {
        this.out = System.out;
        this.printArgs = new Class[1];
        try {
            this.printArgs[0] = Class.forName("java.io.PrintStream");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void instancePrintWatch() {
        if (this.watchObj == null) {
            return;
        }
        this.instancePrint(this.watchObj);
    }

    public void instancePrintIfWatch(Object object) {
        if (object != this.watchObj) {
            return;
        }
        if (this.watchObj == null) {
            return;
        }
        this.instancePrint(this.watchObj);
    }

    public void instancePrint(Object object) {
        if (object instanceof Collection) {
            this.instancePrint(((Collection)object).iterator());
        } else if (object instanceof Iterator) {
            this.instancePrint((Iterator)object);
        } else {
            this.instancePrintObject(object);
        }
    }

    public void instancePrint(Iterator iterator) {
        while (iterator.hasNext()) {
            Object e = iterator.next();
            this.instancePrintObject(e);
        }
    }

    public void instancePrintObject(Object object) {
        Method method = null;
        try {
            Class<?> clazz = object.getClass();
            try {
                method = clazz.getMethod("print", this.printArgs);
                this.args[0] = this.out;
                this.out.print(DEBUG_LINE_TAG);
                method.invoke(object, this.args);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                this.instancePrint(object.toString());
            }
        }
        catch (Exception exception) {
            exception.printStackTrace(this.out);
        }
    }

    public void println() {
        this.out.println();
    }

    private void instanceAddWatch(Object object) {
        this.watchObj = object;
    }

    private void instancePrint(String string) {
        this.out.print(DEBUG_LINE_TAG);
        this.out.print(string);
    }
}

