/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.util;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.LinearRing;
import com.vividsolutions.jts.geom.Polygon;

public class GeometricShapeFactory {
    private GeometryFactory geomFact;
    private Dimensions dim = new Dimensions();
    private int nPts = 100;

    public GeometricShapeFactory(GeometryFactory geometryFactory) {
        this.geomFact = geometryFactory;
    }

    public void setBase(Coordinate coordinate) {
        this.dim.setBase(coordinate);
    }

    public void setCentre(Coordinate coordinate) {
        this.dim.setCentre(coordinate);
    }

    public void setNumPoints(int n) {
        this.nPts = n;
    }

    public void setSize(double d) {
        this.dim.setSize(d);
    }

    public void setWidth(double d) {
        this.dim.setWidth(d);
    }

    public void setHeight(double d) {
        this.dim.setHeight(d);
    }

    public Polygon createRectangle() {
        double d;
        double d2;
        int n;
        int n2 = 0;
        int n3 = this.nPts / 4;
        if (n3 < 1) {
            n3 = 1;
        }
        double d3 = this.dim.getEnvelope().getWidth() / (double)n3;
        double d4 = this.dim.getEnvelope().getHeight() / (double)n3;
        Coordinate[] coordinateArray = new Coordinate[4 * n3 + 1];
        Envelope envelope = this.dim.getEnvelope();
        double d5 = envelope.getMinX() + (double)n3 * d3;
        double d6 = envelope.getMinY() + (double)n3 * d3;
        for (n = 0; n < n3; ++n) {
            d2 = envelope.getMinX() + (double)n * d3;
            d = envelope.getMinY();
            coordinateArray[n2++] = new Coordinate(d2, d);
        }
        for (n = 0; n < n3; ++n) {
            d2 = envelope.getMaxX();
            d = envelope.getMinY() + (double)n * d4;
            coordinateArray[n2++] = new Coordinate(d2, d);
        }
        for (n = 0; n < n3; ++n) {
            d2 = envelope.getMaxX() - (double)n * d3;
            d = envelope.getMaxY();
            coordinateArray[n2++] = new Coordinate(d2, d);
        }
        for (n = 0; n < n3; ++n) {
            d2 = envelope.getMinX();
            d = envelope.getMaxY() - (double)n * d4;
            coordinateArray[n2++] = new Coordinate(d2, d);
        }
        coordinateArray[n2++] = new Coordinate(coordinateArray[0]);
        LinearRing linearRing = this.geomFact.createLinearRing(coordinateArray);
        Polygon polygon = this.geomFact.createPolygon(linearRing, null);
        return polygon;
    }

    public Polygon createCircle() {
        Envelope envelope = this.dim.getEnvelope();
        double d = envelope.getWidth() / 2.0;
        double d2 = envelope.getHeight() / 2.0;
        double d3 = envelope.getMinX() + d;
        double d4 = envelope.getMinY() + d2;
        Coordinate[] coordinateArray = new Coordinate[this.nPts + 1];
        int n = 0;
        for (int i = 0; i < this.nPts; ++i) {
            double d5 = (double)i * (Math.PI * 2 / (double)this.nPts);
            double d6 = d * Math.cos(d5) + d3;
            double d7 = d2 * Math.sin(d5) + d4;
            Coordinate coordinate = new Coordinate(d6, d7);
            coordinateArray[n++] = coordinate;
        }
        coordinateArray[n] = coordinateArray[0];
        LinearRing linearRing = this.geomFact.createLinearRing(coordinateArray);
        Polygon polygon = this.geomFact.createPolygon(linearRing, null);
        return polygon;
    }

    public LineString createArc(double d, double d2) {
        Envelope envelope = this.dim.getEnvelope();
        double d3 = envelope.getWidth() / 2.0;
        double d4 = envelope.getHeight() / 2.0;
        double d5 = envelope.getMinX() + d3;
        double d6 = envelope.getMinY() + d4;
        double d7 = d2 - d;
        if (d7 <= 0.0 || d7 > Math.PI * 2) {
            d7 = Math.PI * 2;
        }
        double d8 = d7 / (double)this.nPts;
        Coordinate[] coordinateArray = new Coordinate[this.nPts];
        int n = 0;
        for (int i = 0; i < this.nPts; ++i) {
            double d9 = d + (double)i * d8;
            double d10 = d3 * Math.cos(d9) + d5;
            double d11 = d4 * Math.sin(d9) + d6;
            Coordinate coordinate = new Coordinate(d10, d11);
            this.geomFact.getPrecisionModel().makePrecise(coordinate);
            coordinateArray[n++] = coordinate;
        }
        LineString lineString = this.geomFact.createLineString(coordinateArray);
        return lineString;
    }

    private class Dimensions {
        public Coordinate base;
        public Coordinate centre;
        public double width;
        public double height;

        private Dimensions() {
        }

        public void setBase(Coordinate coordinate) {
            this.base = coordinate;
        }

        public void setCentre(Coordinate coordinate) {
            this.centre = coordinate;
        }

        public void setSize(double d) {
            this.height = d;
            this.width = d;
        }

        public void setWidth(double d) {
            this.width = d;
        }

        public void setHeight(double d) {
            this.height = d;
        }

        public Envelope getEnvelope() {
            if (this.base != null) {
                return new Envelope(this.base.x, this.base.x + this.width, this.base.y, this.base.y + this.height);
            }
            if (this.centre != null) {
                return new Envelope(this.centre.x - this.width / 2.0, this.centre.x + this.width / 2.0, this.centre.y - this.height / 2.0, this.centre.y + this.height / 2.0);
            }
            return new Envelope(0.0, this.width, 0.0, this.height);
        }
    }
}

