/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.plugin;

import com.vividsolutions.jts.util.Assert;
import com.vividsolutions.jump.task.TaskMonitor;
import com.vividsolutions.jump.util.StringUtil;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.plugin.Configuration;
import com.vividsolutions.jump.workbench.plugin.Extension;
import com.vividsolutions.jump.workbench.plugin.PlugIn;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;

public class PlugInManager {
    private TaskMonitor monitor;
    private WorkbenchContext context;
    private Collection configurations = new ArrayList();
    static /* synthetic */ Class class$com$vividsolutions$jump$workbench$plugin$Configuration;

    public PlugInManager(WorkbenchContext context, File plugInDirectory, TaskMonitor monitor) throws Exception {
        this.monitor = monitor;
        Assert.isTrue((plugInDirectory == null || plugInDirectory.isDirectory() ? 1 : 0) != 0);
        this.context = context;
        this.configurations.addAll(plugInDirectory != null ? this.findConfigurations(plugInDirectory) : new ArrayList());
        this.configurations.addAll(this.findConfigurations(context.getWorkbench().getProperties().getConfigurationClasses()));
    }

    public void load() throws Exception {
        this.loadPlugInClasses(this.context.getWorkbench().getProperties().getPlugInClasses());
        this.loadConfigurations();
    }

    private void loadConfigurations() throws Exception {
        Iterator i = this.configurations.iterator();
        while (i.hasNext()) {
            Configuration configuration = (Configuration)i.next();
            configuration.configure(new PlugInContext(this.context, null, null, null, null));
        }
    }

    public static String name(Configuration configuration) {
        if (configuration instanceof Extension) {
            return ((Extension)configuration).getName();
        }
        return StringUtil.toFriendlyName(configuration.getClass().getName(), "Configuration") + " (" + configuration.getClass().getPackage().getName() + ")";
    }

    public static String version(Configuration configuration) {
        if (configuration instanceof Extension) {
            return ((Extension)configuration).getVersion();
        }
        return "";
    }

    private Collection findConfigurations(List classes) throws Exception {
        ArrayList<Configuration> configurations = new ArrayList<Configuration>();
        Iterator i = classes.iterator();
        while (i.hasNext()) {
            Class c;
            if (!(class$com$vividsolutions$jump$workbench$plugin$Configuration == null ? PlugInManager.class$("com.vividsolutions.jump.workbench.plugin.Configuration") : class$com$vividsolutions$jump$workbench$plugin$Configuration).isAssignableFrom(c = (Class)i.next())) continue;
            Configuration configuration = (Configuration)c.newInstance();
            configurations.add(configuration);
            this.monitor.report("Loading " + PlugInManager.name(configuration) + " " + PlugInManager.version(configuration));
        }
        return configurations;
    }

    private void loadPlugInClasses(List plugInClasses) throws Exception {
        Iterator i = plugInClasses.iterator();
        while (i.hasNext()) {
            Class plugInClass = (Class)i.next();
            PlugIn plugIn = (PlugIn)plugInClass.newInstance();
            plugIn.initialize(new PlugInContext(this.context, null, null, null, null));
        }
    }

    private Collection findConfigurations(File plugInDirectory) throws Exception {
        URLClassLoader classLoader = new URLClassLoader(this.toURLs(plugInDirectory.listFiles()));
        ArrayList configurations = new ArrayList();
        Iterator<File> i = Arrays.asList(plugInDirectory.listFiles()).iterator();
        while (i.hasNext()) {
            File file = i.next();
            if (file.isDirectory()) {
                configurations.addAll(this.findConfigurations(file));
            }
            if (!file.isFile()) continue;
            try {
                configurations.addAll(this.findConfigurations(this.classes(new ZipFile(file), classLoader)));
            }
            catch (ZipException e) {}
        }
        return configurations;
    }

    private URL[] toURLs(File[] files) {
        URL[] urls = new URL[files.length];
        for (int i = 0; i < files.length; ++i) {
            try {
                urls[i] = new URL("jar:file:" + files[i].getPath() + "!/");
                continue;
            }
            catch (MalformedURLException e) {
                Assert.shouldNeverReachHere((String)e.toString());
            }
        }
        return urls;
    }

    private List classes(ZipFile zipFile, ClassLoader classLoader) {
        ArrayList<Class> classes = new ArrayList<Class>();
        Enumeration<? extends ZipEntry> e = zipFile.entries();
        while (e.hasMoreElements()) {
            Class c;
            ZipEntry entry = e.nextElement();
            if (!entry.getName().endsWith("Extension.class") && !entry.getName().endsWith("Configuration.class") || (c = this.toClass(entry, classLoader)) == null) continue;
            classes.add(c);
        }
        return classes;
    }

    private Class toClass(ZipEntry entry, ClassLoader classLoader) {
        Class<?> candidate;
        if (entry.isDirectory()) {
            return null;
        }
        if (!entry.getName().endsWith(".class")) {
            return null;
        }
        if (entry.getName().indexOf("$") != -1) {
            return null;
        }
        String className = entry.getName();
        className = className.substring(0, className.length() - ".class".length());
        className = StringUtil.replaceAll(className, "/", ".");
        try {
            candidate = classLoader.loadClass(className);
        }
        catch (ClassNotFoundException e) {
            Assert.shouldNeverReachHere((String)("Class not found: " + className + ". Refine class name algorithm."));
            return null;
        }
        catch (Throwable t) {
            System.out.println("Throwable encountered loading " + className + ":");
            t.printStackTrace(System.out);
            return null;
        }
        return candidate;
    }

    public Collection getConfigurations() {
        return Collections.unmodifiableCollection(this.configurations);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

