/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui;

import com.vividsolutions.jump.feature.Feature;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.plugin.EnableCheck;
import com.vividsolutions.jump.workbench.plugin.MultiEnableCheck;
import com.vividsolutions.jump.workbench.ui.AbstractFeatureTextWriter;
import com.vividsolutions.jump.workbench.ui.EnableableToolBar;
import com.vividsolutions.jump.workbench.ui.FeatureInfoWriter;
import com.vividsolutions.jump.workbench.ui.GUIUtil;
import com.vividsolutions.jump.workbench.ui.GeometryInfoPanel;
import com.vividsolutions.jump.workbench.ui.InfoModel;
import com.vividsolutions.jump.workbench.ui.images.IconLoader;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Iterator;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JToggleButton;

public class GeometryInfoTab
extends JPanel {
    private BorderLayout borderLayout2 = new BorderLayout();
    private JToggleButton showAttributesButton = new JToggleButton();
    private JToggleButton showGeometriesButton = new JToggleButton();
    private EnableableToolBar toolBar = new EnableableToolBar();
    private GeometryInfoPanel geometryInfoPanel;
    private EnableCheck geometriesShownEnableCheck = new EnableCheck(){

        public String check(JComponent component) {
            return !GeometryInfoTab.this.showGeometriesButton.isSelected() ? "X" : null;
        }
    };
    private FeatureInfoWriter.Writer geometryWriter;

    public GeometryInfoTab(InfoModel model, WorkbenchContext context) {
        this.geometryInfoPanel = new GeometryInfoPanel(model);
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        this.toolBar.add(this.showGeometriesButton, "Geometries", IconLoader.icon("Geometry.gif"), new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                GeometryInfoTab.this.updateText();
            }
        }, new MultiEnableCheck());
        this.toolBar.addSpacer();
        this.toolBar.add(this.showAttributesButton, "Attributes", IconLoader.icon("Attribute.gif"), new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                GeometryInfoTab.this.updateText();
            }
        }, new MultiEnableCheck());
        Dimension buttonSize = new Dimension((int)((double)this.showGeometriesButton.getPreferredSize().width * 1.5), this.showGeometriesButton.getPreferredSize().height);
        this.toolBar.addSpacer();
        ButtonGroup buttonGroup = new ButtonGroup();
        Iterator i = context.getFeatureTextWriterRegistry().iterator();
        while (i.hasNext()) {
            final AbstractFeatureTextWriter writer = (AbstractFeatureTextWriter)i.next();
            JToggleButton button = new JToggleButton(writer.getShortDescription());
            button.setFont(button.getFont().deriveFont(10.0f));
            buttonGroup.add(button);
            this.toolBar.add(button, writer.getDescription(), null, new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    if (GeometryInfoTab.this.showGeometriesButton.isSelected()) {
                        GeometryInfoTab.this.geometryWriter = new FeatureInfoWriterAdapter(writer);
                    }
                    GeometryInfoTab.this.updateText();
                }
            }, this.geometriesShownEnableCheck);
            button.setPreferredSize(buttonSize);
            button.setMinimumSize(buttonSize);
            button.setMaximumSize(buttonSize);
            button.setSize(buttonSize);
        }
        this.showGeometriesButton.doClick();
        ((JToggleButton)buttonGroup.getElements().nextElement()).doClick();
    }

    private void updateText() {
        if (this.showAttributesButton.isSelected()) {
            this.geometryInfoPanel.setAttributeWriter(FeatureInfoWriter.ATTRIBUTE_WRITER);
        } else {
            this.geometryInfoPanel.setAttributeWriter(FeatureInfoWriter.EMPTY_WRITER);
        }
        if (this.showGeometriesButton.isSelected()) {
            this.geometryInfoPanel.setGeometryWriter(this.geometryWriter);
        } else {
            this.geometryInfoPanel.setGeometryWriter(FeatureInfoWriter.EMPTY_WRITER);
        }
        this.geometryInfoPanel.updateText();
    }

    void jbInit() throws Exception {
        this.setLayout(this.borderLayout2);
        this.toolBar.setOrientation(1);
        this.add((Component)this.geometryInfoPanel, "Center");
        this.add((Component)this.toolBar, "West");
    }

    private class FeatureInfoWriterAdapter
    implements FeatureInfoWriter.Writer {
        private AbstractFeatureTextWriter featureTextWriter;

        public FeatureInfoWriterAdapter(AbstractFeatureTextWriter featureTextWriter) {
            this.featureTextWriter = featureTextWriter;
        }

        public String toHTML(Feature feature) {
            return this.featureTextWriter.isWrapping() ? "<BR><CODE>" + GUIUtil.escapeHTML(this.featureTextWriter.write(feature), false, false) + "</CODE>" : "<pre>" + GUIUtil.escapeHTML(this.featureTextWriter.write(feature), false, false) + "</pre>";
        }
    }
}

