/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui;

import com.vividsolutions.jump.util.StringUtil;
import com.vividsolutions.jump.workbench.ui.HTMLPanel;
import com.vividsolutions.jump.workbench.ui.WorkbenchFrame;
import com.vividsolutions.jump.workbench.ui.images.IconLoader;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyVetoException;
import javax.swing.JButton;
import javax.swing.JInternalFrame;
import javax.swing.Timer;
import javax.swing.event.InternalFrameAdapter;
import javax.swing.event.InternalFrameEvent;

public class HTMLFrame
extends JInternalFrame {
    private WorkbenchFrame workbenchFrame;
    private BorderLayout borderLayout1 = new BorderLayout();
    protected boolean alwaysOnTop = false;
    private boolean notifyingUser = false;
    private JButton button = null;
    private HTMLPanel panel = new HTMLPanel(){

        protected void setEditorPaneText() {
            super.setEditorPaneText();
            HTMLFrame.this.notifyUser();
        }
    };

    public HTMLFrame() {
    }

    public HTMLFrame(final WorkbenchFrame workbenchFrame) {
        this.workbenchFrame = workbenchFrame;
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.setDefaultCloseOperation(0);
        this.addInternalFrameListener(new InternalFrameAdapter(){

            public void internalFrameClosing(InternalFrameEvent e) {
                try {
                    workbenchFrame.removeInternalFrame(HTMLFrame.this);
                }
                catch (Exception x) {
                    workbenchFrame.handleThrowable(x);
                }
            }

            public void internalFrameOpened(InternalFrameEvent e) {
                HTMLFrame.this.panel.getRecordPanel().updateAppearance();
            }
        });
        this.setSize(500, 300);
    }

    public void setCurrentIndex(int index) {
        this.panel.setCurrentIndex(index);
    }

    public void setTitle(String s) {
        super.setTitle(s);
    }

    public void setBackgroundColor(Color color) {
        this.panel.setBackgroundColor(color);
    }

    public Color getBackgroundColor() {
        return this.panel.getBackgroundColor();
    }

    public int getRecordCount() {
        return this.panel.getRecordCount();
    }

    public int getCurrentIndex() {
        return this.panel.getCurrentIndex();
    }

    public void createNewDocument() {
        this.panel.createNewDocument();
    }

    public void setRecordNavigationControlVisible(boolean visible) {
        this.panel.setRecordNavigationControlVisible(visible);
    }

    public void clear() {
        this.panel.createNewDocument();
    }

    public void surface() {
        if (!this.workbenchFrame.hasInternalFrame(this)) {
            this.workbenchFrame.addInternalFrame(this, this.alwaysOnTop, true);
        }
        this.workbenchFrame.activateFrame(this);
        if (this.isIcon()) {
            try {
                this.setIcon(false);
            }
            catch (PropertyVetoException e) {
                this.workbenchFrame.log(StringUtil.stackTrace(e));
            }
        }
        this.moveToFront();
    }

    public void addHeader(int level, String text) {
        this.panel.addHeader(level, text);
    }

    public void addField(String label, String value) {
        this.panel.addField(label, value);
    }

    public void addField(String label, String value, String units) {
        this.panel.addField(label, value, units);
    }

    public void addText(String text) {
        this.panel.addText(text);
    }

    public void append(String html) {
        this.panel.append(html);
    }

    public void setButton(JButton button) {
        this.button = button;
    }

    private void setButtonHighlighted(boolean highlighted) {
        if (this.button == null) {
            return;
        }
        this.button.setIcon(highlighted ? IconLoader.icon("Frame2.gif") : IconLoader.icon("Frame.gif"));
    }

    private void notifyUser() {
        if (this.notifyingUser) {
            return;
        }
        if (this.button == null) {
            return;
        }
        this.notifyingUser = true;
        new Timer(500, new ActionListener(){
            private int tickCount = 0;

            public void actionPerformed(ActionEvent e) {
                ++this.tickCount;
                HTMLFrame.this.setButtonHighlighted(this.tickCount % 2 == 0);
                if (this.tickCount == 8) {
                    Timer timer = (Timer)e.getSource();
                    timer.stop();
                    HTMLFrame.this.notifyingUser = false;
                    HTMLFrame.this.setButtonHighlighted(!HTMLFrame.this.isSelected());
                }
            }
        }).start();
    }

    private void jbInit() throws Exception {
        this.setTitle("Output");
        this.addInternalFrameListener(new InternalFrameAdapter(){

            public void internalFrameActivated(InternalFrameEvent e) {
                HTMLFrame.this.this_internalFrameActivated(e);
            }
        });
        this.getContentPane().setLayout(this.borderLayout1);
        this.getContentPane().add((Component)this.panel, "Center");
        this.setResizable(true);
        this.setClosable(true);
        this.setMaximizable(true);
        this.setIconifiable(true);
        this.panel.getOKButton().addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                HTMLFrame.this.okButton_actionPerformed(e);
            }
        });
    }

    public void scrollToTop() {
        this.panel.scrollToTop();
    }

    void okButton_actionPerformed(ActionEvent e) {
        this.doDefaultCloseAction();
    }

    void this_internalFrameActivated(InternalFrameEvent e) {
        this.setButtonHighlighted(false);
    }
}

