/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui;

import com.vividsolutions.jump.util.OrderedMap;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.ui.InfoModelListener;
import com.vividsolutions.jump.workbench.ui.LayerTableModel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class InfoModel {
    private OrderedMap layerToTableModelMap = new OrderedMap();
    private ArrayList listeners = new ArrayList();

    public void dispose() {
        Iterator i = new ArrayList(this.getLayers()).iterator();
        while (i.hasNext()) {
            Layer layer = (Layer)i.next();
            this.remove(layer);
        }
    }

    public Collection getLayerTableModels() {
        return Collections.unmodifiableCollection(this.layerToTableModelMap.values());
    }

    public void add(Layer layer, Collection features) {
        boolean layerNew = !this.layerToTableModelMap.containsKey(layer);
        LayerTableModel layerTableModel = this.getTableModel(layer);
        layerTableModel.addAll(features);
        if (layerNew) {
            Iterator i = this.listeners.iterator();
            while (i.hasNext()) {
                InfoModelListener listener = (InfoModelListener)i.next();
                listener.layerAdded(layerTableModel);
            }
        }
    }

    public void remove(Layer layer) {
        LayerTableModel layerTableModel = this.getTableModel(layer);
        ((LayerTableModel)this.layerToTableModelMap.get(layer)).dispose();
        this.layerToTableModelMap.remove(layer);
        Iterator i = this.listeners.iterator();
        while (i.hasNext()) {
            InfoModelListener listener = (InfoModelListener)i.next();
            listener.layerRemoved(layerTableModel);
        }
    }

    public void clear() {
        ArrayList layers = new ArrayList(this.layerToTableModelMap.keySet());
        Iterator i = layers.iterator();
        while (i.hasNext()) {
            Layer layer = (Layer)i.next();
            this.remove(layer);
        }
    }

    public LayerTableModel getTableModel(Layer layer) {
        if (!this.layerToTableModelMap.containsKey(layer)) {
            this.layerToTableModelMap.put(layer, new LayerTableModel(layer));
        }
        return (LayerTableModel)this.layerToTableModelMap.get(layer);
    }

    public List getLayers() {
        return Collections.unmodifiableList(this.layerToTableModelMap.keyList());
    }

    public void addListener(InfoModelListener listener) {
        this.listeners.add(listener);
    }
}

