/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.renderer.style;

import com.vividsolutions.jts.util.Assert;
import com.vividsolutions.jump.util.CollectionMap;
import com.vividsolutions.jump.util.FileUtil;
import java.awt.Color;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;

public class ColorScheme {
    private static ArrayList rangeColorSchemeNames;
    private static ArrayList discreteColorSchemeNames;
    private static CollectionMap nameToColorsMap;
    private String name;
    private int lastColorReturned = -1;
    private List colors;
    static /* synthetic */ Class class$com$vividsolutions$jump$workbench$ui$renderer$style$ColorScheme;

    public static ColorScheme create(String name) {
        Assert.isTrue((boolean)ColorScheme.nameToColorsMap().keySet().contains(name));
        return new ColorScheme(name, ColorScheme.nameToColorsMap().getItems(name));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void load() {
        try {
            rangeColorSchemeNames = new ArrayList();
            discreteColorSchemeNames = new ArrayList();
            nameToColorsMap = new CollectionMap();
            InputStream inputStream = (class$com$vividsolutions$jump$workbench$ui$renderer$style$ColorScheme == null ? (class$com$vividsolutions$jump$workbench$ui$renderer$style$ColorScheme = ColorScheme.class$("com.vividsolutions.jump.workbench.ui.renderer.style.ColorScheme")) : class$com$vividsolutions$jump$workbench$ui$renderer$style$ColorScheme).getResourceAsStream("ColorScheme.txt");
            try {
                Iterator i = FileUtil.getContents(inputStream).iterator();
                while (i.hasNext()) {
                    String line = (String)i.next();
                    ColorScheme.add(line);
                }
            }
            finally {
                inputStream.close();
            }
        }
        catch (IOException e) {
            Assert.shouldNeverReachHere((String)e.toString());
        }
    }

    private static void add(String line) {
        StringTokenizer tokenizer = new StringTokenizer(line, ",");
        String name = tokenizer.nextToken();
        boolean range = tokenizer.nextToken().equals("range");
        (range ? rangeColorSchemeNames : discreteColorSchemeNames).add(name);
        while (tokenizer.hasMoreTokens()) {
            String hex = tokenizer.nextToken();
            Assert.isTrue((hex.length() == 6 ? 1 : 0) != 0, (String)hex);
            ColorScheme.nameToColorsMap().addItem(name, Color.decode("#" + hex));
        }
    }

    private static CollectionMap nameToColorsMap() {
        if (nameToColorsMap == null) {
            ColorScheme.load();
        }
        return nameToColorsMap;
    }

    public static Collection rangeColorSchemeNames() {
        if (rangeColorSchemeNames == null) {
            ColorScheme.load();
        }
        return Collections.unmodifiableList(rangeColorSchemeNames);
    }

    public static Collection discreteColorSchemeNames() {
        if (discreteColorSchemeNames == null) {
            ColorScheme.load();
        }
        return Collections.unmodifiableList(discreteColorSchemeNames);
    }

    public ColorScheme(String name, Collection colors) {
        this.name = name;
        this.colors = new ArrayList(colors);
    }

    public int getLastColorReturned() {
        return this.lastColorReturned;
    }

    public void setLastColorReturned(int lastColorReturned) {
        this.lastColorReturned = lastColorReturned;
    }

    public Color next() {
        ++this.lastColorReturned;
        if (this.lastColorReturned >= this.colors.size()) {
            this.lastColorReturned = 0;
        }
        return (Color)this.colors.get(this.lastColorReturned);
    }

    public List getColors() {
        return Collections.unmodifiableList(this.colors);
    }

    public String getName() {
        return this.name;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

