/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.style;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.io.ParseException;
import com.vividsolutions.jts.io.WKTReader;
import com.vividsolutions.jts.util.Assert;
import com.vividsolutions.jump.feature.AttributeType;
import com.vividsolutions.jump.feature.Feature;
import com.vividsolutions.jump.feature.FeatureSchema;
import com.vividsolutions.jump.feature.FeatureUtil;
import com.vividsolutions.jump.util.Blackboard;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.model.LayerManager;
import com.vividsolutions.jump.workbench.ui.GUIUtil;
import com.vividsolutions.jump.workbench.ui.LayerViewPanel;
import com.vividsolutions.jump.workbench.ui.LayerViewPanelContext;
import com.vividsolutions.jump.workbench.ui.Viewport;
import com.vividsolutions.jump.workbench.ui.renderer.style.BasicStyle;
import com.vividsolutions.jump.workbench.ui.renderer.style.Style;
import com.vividsolutions.jump.workbench.ui.renderer.style.VertexStyle;
import com.vividsolutions.jump.workbench.ui.style.BasicStylePanel;
import com.vividsolutions.jump.workbench.ui.style.StylePanel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JTextArea;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class RenderingStylePanel
extends BasicStylePanel
implements StylePanel {
    private Layer layer;
    private JTextArea fillPatternTipLabel = new JTextArea();
    private JCheckBox vertexCheckBox = new JCheckBox();
    private JSlider vertexSlider = new JSlider(){
        {
            this.addChangeListener(new ChangeListener(this){
                private final /* synthetic */ 1 this$1;
                {
                    this.this$1 = this$1;
                }

                public void stateChanged(ChangeEvent e) {
                    1.access$000(this.this$1).updateControls();
                }
            });
        }

        static /* synthetic */ RenderingStylePanel access$000(1 x0) {
            return x0.RenderingStylePanel.this;
        }
    };
    private JPanel previewPanel = new JPanel(){
        private LayerViewPanel dummyLayerViewPanel;
        private Viewport viewport;
        private Feature feature;
        {
            this.setBackground(Color.white);
            this.setBorder(BorderFactory.createLoweredBevelBorder());
            this.setMaximumSize(new Dimension(200, 40));
            this.setMinimumSize(new Dimension(200, 40));
            this.setPreferredSize(new Dimension(200, 40));
            this.dummyLayerViewPanel = new LayerViewPanel(new LayerManager(), new LayerViewPanelContext(this){
                private final /* synthetic */ 3 this$1;
                {
                    this.this$1 = this$1;
                }

                public void setStatusMessage(String message) {
                }

                public void warnUser(String warning) {
                }

                public void handleThrowable(Throwable t) {
                }
            });
            this.viewport = new Viewport(this, this.dummyLayerViewPanel){
                private AffineTransform transform;
                private final /* synthetic */ 3 this$1;
                {
                    this.this$1 = this$1;
                    this.transform = new AffineTransform();
                }

                public Envelope getEnvelopeInModelCoordinates() {
                    return new Envelope(0.0, 200.0, 0.0, 40.0);
                }

                public AffineTransform getModelToViewTransform() {
                    return this.transform;
                }

                public Point2D toViewPoint(Coordinate modelCoordinate) {
                    return new Point2D.Double(modelCoordinate.x, modelCoordinate.y);
                }
            };
            this.feature = this.createFeature();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void paint(Style style, Graphics2D g) {
            Stroke originalStroke = g.getStroke();
            try {
                style.paint(this.feature, g, this.viewport);
            }
            catch (Exception e) {
            }
            finally {
                g.setStroke(originalStroke);
            }
        }

        protected void paintComponent(Graphics g) {
            super.paintComponent(g);
            ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            this.paint(RenderingStylePanel.this.getBasicStyle(), (Graphics2D)g);
            if (RenderingStylePanel.this.vertexCheckBox.isSelected()) {
                VertexStyle vertexStyle = RenderingStylePanel.this.getVertexStyle();
                vertexStyle.initialize(new Layer(this){
                    private final /* synthetic */ 3 this$1;
                    {
                        this.this$1 = this$1;
                    }

                    public BasicStyle getBasicStyle() {
                        return 3.access$200(this.this$1).getBasicStyle();
                    }
                });
                this.paint(vertexStyle, (Graphics2D)g);
            }
        }

        private Feature createFeature() {
            try {
                return FeatureUtil.toFeature(new WKTReader().read("POLYGON ((-200 80, 100 20, 400 -40, 400 80, -200 80))"), new FeatureSchema(this){
                    private static final long serialVersionUID = -8627306219650589202L;
                    private final /* synthetic */ 3 this$1;
                    {
                        this.this$1 = this$1;
                        this.addAttribute("GEOMETRY", AttributeType.GEOMETRY);
                    }
                });
            }
            catch (ParseException e) {
                Assert.shouldNeverReachHere();
                return null;
            }
        }

        static /* synthetic */ RenderingStylePanel access$200(3 x0) {
            return x0.RenderingStylePanel.this;
        }
    };

    public RenderingStylePanel() {
    }

    public RenderingStylePanel(Blackboard blackboard, Layer layer) {
        super(blackboard, 21);
        Hashtable<Integer, JLabel> labelTable = new Hashtable<Integer, JLabel>();
        labelTable.put(new Integer(5), new JLabel("5"));
        labelTable.put(new Integer(10), new JLabel("10"));
        labelTable.put(new Integer(15), new JLabel("15"));
        labelTable.put(new Integer(20), new JLabel("20"));
        this.vertexSlider.setLabelTable(labelTable);
        this.setBasicStyle(layer.getBasicStyle());
        try {
            this.jbInit();
            this.updateControls();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        this.setLayer(layer);
    }

    public void updateControls() {
        super.updateControls();
        if (this.vertexSlider == null) {
            return;
        }
        this.previewPanel.repaint();
        this.vertexSlider.setEnabled(this.vertexCheckBox.isSelected());
        Enumeration e = this.vertexSlider.getLabelTable().elements();
        while (e.hasMoreElements()) {
            JLabel label = (JLabel)e.nextElement();
            label.setEnabled(this.vertexCheckBox.isSelected());
        }
    }

    public String getTitle() {
        return "Rendering";
    }

    private void setLayer(Layer layer) {
        this.layer = layer;
        this.setSynchronizingLineColor(layer.isSynchronizingLineColor());
        this.vertexCheckBox.setSelected(layer.getVertexStyle().isEnabled());
        this.vertexSlider.setValue(layer.getVertexStyle().getSize());
    }

    void jbInit() throws Exception {
        if (this.vertexSlider == null) {
            super.jbInit();
            return;
        }
        this.vertexCheckBox.setText("Vertices. Size:");
        this.vertexCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                RenderingStylePanel.this.showVerticesCheckBox_actionPerformed(e);
            }
        });
        this.vertexSlider.setMinorTickSpacing(1);
        this.vertexSlider.setMajorTickSpacing(0);
        this.vertexSlider.setPaintLabels(true);
        this.vertexSlider.setMinimum(4);
        this.vertexSlider.setValue(4);
        this.vertexSlider.setMaximum(20);
        this.vertexSlider.setSnapToTicks(true);
        this.vertexSlider.setPreferredSize(SLIDER_DIMENSION);
        this.fillPatternTipLabel.setFont(new Font("SansSerif", 2, 10));
        this.fillPatternTipLabel.setOpaque(false);
        this.fillPatternTipLabel.setEditable(false);
        this.fillPatternTipLabel.setText("Tip: After selecting a pattern, use your keyboard's up and down keys to see how other patterns look in the preview below");
        this.fillPatternTipLabel.setLineWrap(true);
        this.fillPatternTipLabel.setWrapStyleWord(true);
        this.centerPanel.add((Component)this.vertexSlider, new GridBagConstraints(1, 35, 1, 1, 0.0, 0.0, 17, 0, new Insets(2, 2, 2, 2), 0, 0));
        this.centerPanel.add((Component)GUIUtil.createSyncdTextField(this.vertexSlider, 3), new GridBagConstraints(2, 35, 1, 1, 0.0, 0.0, 17, 0, new Insets(2, 2, 2, 2), 0, 0));
        this.centerPanel.add((Component)this.vertexCheckBox, new GridBagConstraints(0, 35, 2, 1, 0.0, 0.0, 17, 0, new Insets(2, 2, 2, 2), 0, 0));
        this.centerPanel.add((Component)new JLabel("Preview:"), new GridBagConstraints(0, 40, 3, 1, 0.0, 0.0, 17, 0, new Insets(2, 2, 0, 2), 0, 0));
        this.centerPanel.add((Component)this.previewPanel, new GridBagConstraints(0, 45, 3, 1, 0.0, 0.0, 17, 0, new Insets(0, 10, 2, 2), 0, 0));
        this.centerPanel.add((Component)this.fillPatternTipLabel, new GridBagConstraints(0, 8, 3, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
    }

    public VertexStyle getVertexStyle() {
        VertexStyle vertexStyle = (VertexStyle)this.layer.getVertexStyle().clone();
        vertexStyle.setEnabled(this.vertexCheckBox.isSelected());
        vertexStyle.setSize(this.vertexSlider.getValue());
        return vertexStyle;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateStyles() {
        boolean firingEvents = this.layer.getLayerManager().isFiringEvents();
        this.layer.getLayerManager().setFiringEvents(false);
        try {
            this.layer.removeStyle(this.layer.getBasicStyle());
            this.layer.addStyle(this.getBasicStyle());
            VertexStyle newVertexStyle = this.getVertexStyle();
            this.layer.removeStyle(this.layer.getVertexStyle());
            this.layer.addStyle(newVertexStyle);
            this.layer.setSynchronizingLineColor(this.synchronizeCheckBox.isSelected());
        }
        finally {
            this.layer.getLayerManager().setFiringEvents(firingEvents);
        }
        this.layer.fireAppearanceChanged();
    }

    void showVerticesCheckBox_actionPerformed(ActionEvent e) {
        this.updateControls();
    }

    public String validateInput() {
        return null;
    }
}

