/*
 * Decompiled with CFR 0.152.
 */
package com.kfu.JXM;

import com.kfu.JXM.AboutDialog;
import com.kfu.JXM.Bookmark;
import com.kfu.JXM.Favorite;
import com.kfu.JXM.FilterPanel;
import com.kfu.JXM.IPlatformCallbackHandler;
import com.kfu.JXM.IPreferenceCallbackHandler;
import com.kfu.JXM.JXM;
import com.kfu.JXM.MemoryPanel;
import com.kfu.JXM.PlatformFactory;
import com.kfu.JXM.PreferencesDialog;
import com.kfu.JXM.SearchSystem;
import com.kfu.JXM.TrackerException;
import com.kfu.JXM.XMTracker;
import com.kfu.xm.ChannelInfo;
import com.kfu.xm.RadioCommander;
import com.kfu.xm.RadioEventHandler;
import com.kfu.xm.RadioException;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.HeadlessException;
import java.awt.Image;
import java.awt.Insets;
import java.awt.MediaTracker;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.TimerTask;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JSpinner;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.JViewport;
import javax.swing.JWindow;
import javax.swing.ListSelectionModel;
import javax.swing.SpinnerListModel;
import javax.swing.SwingConstants;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import javax.swing.event.MouseInputAdapter;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public class MainWindow
implements RadioEventHandler,
IPlatformCallbackHandler,
IPreferenceCallbackHandler {
    public static final int CHAN_POPUP_NO_MEM = 1;
    public static final int CHAN_POPUP_NO_TUNE = 2;
    private int sortField = 0;
    private boolean sortDirection = true;
    private HashSet filterList = new HashSet();
    private ChannelInfo[] sortedChannelList = new ChannelInfo[0];
    private HashMap tickList = new HashMap();
    private SearchSystem searchSystem;
    private FilterPanel filterPanel;
    private CompactViewPanel compactView;
    private MemoryPanel memoryPanel;
    private PreferencesDialog preferences;
    private AboutDialog aboutDialog;
    private ChannelInfoPanel nowPlayingPanel;
    private JLabel channelLogo;
    private ChannelTableModel channelTableModel;
    private JTextField searchField;
    private JButton searchFieldClear;
    private JTable channelTable;
    private JCheckBox powerCheckBox;
    private JCheckBox muteButton;
    private JCheckBox smartMuteButton;
    private JButton sleepButton;
    private JFrame myFrame;
    private JMenu bookmarkMenu;
    private JMenuItem powerMenuItem;
    private JComboBox filterMenu;
    private JMenuItem compactMenuItem;
    private Bookmark[] bookmarks;
    private JProgressBar satelliteMeter;
    private JProgressBar terrestrialMeter;
    private JButton memoryButton;
    private JSlider ratingSlider;
    private JComboBox favoriteMenu;
    private JToggleButton favoriteCheckbox;
    private ChannelInfo currentChannelInfo;
    public static final Color stripeColor = new Color(0.85f, 1.0f, 0.85f);
    public static final Color gridColor = new Color(0.85f, 0.85f, 0.85f);
    private final Icon upArrow = new ArrowIcon(1);
    private final Icon downArrow = new ArrowIcon(5);
    private static final int COL_NUM = 0;
    private static final int COL_GENRE = 1;
    private static final int COL_NAME = 2;
    private static final int COL_ARTIST = 3;
    private static final int COL_TITLE = 4;
    private static final int COL_INUSE = 5;
    private static final int DEFAULT_TABLE_ROWS = 15;
    private Bookmark channelMark = new Bookmark("", "http://www.xmradio.com/programming/channel_page.jsp?ch={NUMBER}");
    private URL logoJar;
    MediaTracker myMT = new MediaTracker(this.channelLogo);
    ChannelInfo smartMuteInfo = null;
    JDialog activationDialog;
    private int doNotSelectChannelsUntil = -1;
    private static final String CHAN_TABLE_COLS = "ChannelTableColumnOrder";
    private static final String GRID_NODE = "ChannelGrid";
    private static final String TICK_NODE = "ChannelUsage";
    private static final String SORT_DIR = "SortDirection";
    private static final String SORT_FIELD = "SortColumn";
    private static final String FAVORITE_LIST = "FavoriteChannels";
    private int sleepTime = -1;
    private int lastMinute;
    private static final int[] sleepSettings = new int[]{5, 15, 30, 60, 120};
    private Color savedSleepButtonForeground = null;
    private boolean blinkCycle = false;
    private Icon blankIcon = new BlinkingIcon(0);
    private Icon blinkIcon = new BlinkingIcon(1);
    private Icon nullIcon = new BlinkingIcon(2);
    private Map channelList = Collections.synchronizedMap(new HashMap());
    private boolean ignoreFavoriteMenu = false;
    private boolean disallowSelectionChange = false;
    private boolean ignoreSelectionChange = false;
    private boolean channelTableClickWasPopup = false;
    HashSet favoriteList = new HashSet();
    private ChannelInfo ratingChannelInfo;
    private String lastRecordedUserID;
    private static MessageDigest myDigestMaker;

    private void memorize(ChannelInfo channelInfo) {
        this.forceNormalView();
        this.memoryPanel.memorize(channelInfo);
    }

    private void bookmarkSurf(Bookmark bookmark, ChannelInfo channelInfo) {
        try {
            bookmark.surf(channelInfo);
        }
        catch (IOException iOException) {
            JOptionPane.showMessageDialog(this.myFrame, iOException.getMessage(), "Error opening URL", 0);
        }
    }

    public ChannelInfo[] getChannelList() {
        ChannelInfo[] channelInfoArray = new ChannelInfo[this.channelList.size()];
        Iterator iterator = this.channelList.values().iterator();
        int n = 0;
        while (iterator.hasNext()) {
            channelInfoArray[n++] = (ChannelInfo)iterator.next();
        }
        return channelInfoArray;
    }

    public void setFilter(byte[] byArray) {
        this.filterList.clear();
        for (int i = 0; i < byArray.length; ++i) {
            this.filterList.add(new Integer(byArray[i] & 0xFF));
        }
        this.rebuildSortedChannelList();
    }

    private void rebuildSortedChannelList() {
        Object object;
        ChannelInfo[] channelInfoArray;
        ArrayList<ChannelInfo[]> arrayList = new ArrayList<ChannelInfo[]>();
        Iterator iterator = this.channelList.values().iterator();
        while (iterator.hasNext()) {
            channelInfoArray = (ChannelInfo[])iterator.next();
            if (this.filterList.contains(new Integer(channelInfoArray.getServiceID()))) continue;
            object = this.searchField.getText();
            if (object != null && ((String)(object = ((String)object).trim().toLowerCase())).length() == 0) {
                object = null;
            }
            if (object != null && channelInfoArray.getChannelName().toLowerCase().indexOf((String)object) < 0 && channelInfoArray.getChannelGenre().toLowerCase().indexOf((String)object) < 0 && channelInfoArray.getChannelArtist().toLowerCase().indexOf((String)object) < 0 && channelInfoArray.getChannelTitle().toLowerCase().indexOf((String)object) < 0) continue;
            arrayList.add(channelInfoArray);
        }
        channelInfoArray = arrayList.toArray(new ChannelInfo[0]);
        Arrays.sort(channelInfoArray, new Comparator(){

            public int compare(Object object, Object object2) {
                ChannelInfo channelInfo = (ChannelInfo)object;
                ChannelInfo channelInfo2 = (ChannelInfo)object2;
                int n = 0;
                switch (MainWindow.this.sortField) {
                    case 0: {
                        n = new Integer(channelInfo.getChannelNumber()).compareTo(new Integer(channelInfo2.getChannelNumber()));
                        break;
                    }
                    case 1: {
                        n = channelInfo.getChannelGenre().compareTo(channelInfo2.getChannelGenre());
                        break;
                    }
                    case 2: {
                        n = channelInfo.getChannelName().compareTo(channelInfo2.getChannelName());
                        break;
                    }
                    case 3: {
                        n = channelInfo.getChannelArtist().compareTo(channelInfo2.getChannelArtist());
                        break;
                    }
                    case 4: {
                        n = channelInfo.getChannelTitle().compareTo(channelInfo2.getChannelTitle());
                        break;
                    }
                    case 5: {
                        Integer n2 = (Integer)MainWindow.this.tickList.get(new Integer(channelInfo.getServiceID()));
                        Integer n3 = (Integer)MainWindow.this.tickList.get(new Integer(channelInfo2.getServiceID()));
                        if (n2 == null) {
                            n2 = new Integer(0);
                        }
                        if (n3 == null) {
                            n3 = new Integer(0);
                        }
                        n = n2.compareTo(n3);
                    }
                }
                if (n == 0) {
                    return new Integer(channelInfo.getChannelNumber()).compareTo(new Integer(channelInfo2.getChannelNumber()));
                }
                return n *= MainWindow.this.sortDirection ? 1 : -1;
            }
        });
        object = this.sortedChannelList;
        this.sortedChannelList = channelInfoArray;
        if (((Object)object).length < channelInfoArray.length) {
            this.channelTableModel.fireTableRowsInserted(((Object)object).length, channelInfoArray.length - 1);
        } else if (((Object)object).length > channelInfoArray.length) {
            this.channelTableModel.fireTableRowsDeleted(channelInfoArray.length, ((Object)object).length - 1);
        }
        for (int i = 0; i < Math.min(((Object)object).length, channelInfoArray.length); ++i) {
            if (((ChannelInfo)object[i]).equals(channelInfoArray[i])) continue;
            this.channelTableModel.fireTableRowsUpdated(i, i);
        }
    }

    public SearchSystem getSearchSystem() {
        return this.searchSystem;
    }

    public void reload() {
        this.searchSystem.reload();
        this.filterPanel.reload();
    }

    public void save() {
        this.searchSystem.save();
        this.filterPanel.save();
    }

    public JComponent getSearchPreferencePanel() {
        return this.searchSystem.getPrefPanel();
    }

    public JComponent getFilterPreferencePanel() {
        return this.filterPanel;
    }

    public void clearChannelStats() {
        this.tickList.clear();
        Preferences preferences = JXM.myUserNode().node(TICK_NODE);
        try {
            preferences.clear();
        }
        catch (BackingStoreException backingStoreException) {
            // empty catch block
        }
    }

    public void rebuildBookmarksMenu(Bookmark[] bookmarkArray) {
        this.bookmarks = bookmarkArray;
    }

    private int rowForSID(int n) {
        ChannelInfo[] channelInfoArray = this.sortedChannelList;
        for (int i = 0; i < channelInfoArray.length; ++i) {
            if (channelInfoArray[i].getServiceID() != n) continue;
            return i;
        }
        return -1;
    }

    private int sidForChannel(int n) {
        Iterator iterator = this.channelList.values().iterator();
        while (iterator.hasNext()) {
            ChannelInfo channelInfo = (ChannelInfo)iterator.next();
            if (channelInfo.getChannelNumber() != n) continue;
            return channelInfo.getServiceID();
        }
        return -1;
    }

    private int totalTicks() {
        int n = 0;
        Iterator iterator = this.tickList.values().iterator();
        while (iterator.hasNext()) {
            n += ((Integer)iterator.next()).intValue();
        }
        return n;
    }

    private String inUseForSID(int n) {
        int n2;
        Integer n3 = (Integer)this.tickList.get(new Integer(n));
        if (n3 == null) {
            n3 = new Integer(0);
        }
        if ((n2 = (int)(1000.0f * (float)n3.intValue() / (float)this.totalTicks())) < 1) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(n2 / 10);
        stringBuffer.append(".");
        stringBuffer.append(n2 % 10);
        stringBuffer.append('%');
        return stringBuffer.toString();
    }

    public void quit() {
        if (RadioCommander.theRadio().isOn()) {
            this.turnPowerOff();
        }
        this.saveChannelTableLayout();
        this.saveTickList();
        this.memoryPanel.quit();
        PlatformFactory.ourPlatform().quit();
        System.exit(0);
    }

    public void prefs() {
        this.forceNormalView();
        this.preferences.setVisible(true);
    }

    public void about() {
        this.forceNormalView();
        this.aboutDialog.setVisible(true);
    }

    private void saveChannelTableLayout() {
        byte[] byArray = new byte[this.channelTableModel.getColumnCount()];
        for (int i = 0; i < this.channelTableModel.getColumnCount(); ++i) {
            TableColumn tableColumn = this.channelTable.getColumnModel().getColumn(i);
            byArray[i] = (byte)tableColumn.getModelIndex();
        }
        JXM.myUserNode().putByteArray(CHAN_TABLE_COLS, byArray);
    }

    private static void frontOrShow(Window window) {
        if (window.isVisible()) {
            window.toFront();
        } else {
            window.setVisible(true);
        }
    }

    public MainWindow() {
        String string;
        int n;
        JMenuItem jMenuItem;
        JMenu jMenu;
        PlatformFactory.ourPlatform().registerCallbackHandler(this);
        String[] stringArray = new String[]{"file:" + System.getProperty("user.dir") + "/JXMlogos.jar", "file:" + System.getProperty("user.home") + "/JXMlogos.jar", "file:" + System.getProperty("user.home") + "/.JXMlogos.jar"};
        for (int i = 0; i < stringArray.length; ++i) {
            block24: {
                try {
                    this.logoJar = new URL(stringArray[i]);
                    this.logoJar.openConnection().connect();
                }
                catch (MalformedURLException malformedURLException) {
                    break block24;
                }
                catch (IOException iOException) {
                    break block24;
                }
                if (this.logoJar != null) break;
            }
            this.logoJar = null;
        }
        this.myFrame = new JFrame("JXM");
        Image image = Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/images/xm_duke.png"));
        this.myFrame.setIconImage(image);
        this.myFrame.setJMenuBar(new JMenuBar());
        this.myFrame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                MainWindow.this.quit();
            }
        });
        this.searchSystem = new SearchSystem(this);
        this.filterPanel = new FilterPanel(this);
        this.preferences = new PreferencesDialog(this.myFrame, this);
        this.aboutDialog = new AboutDialog(this.myFrame);
        if (!PlatformFactory.ourPlatform().useMacMenus()) {
            jMenu = new JMenu("JXM");
            jMenuItem = new JMenuItem("Preferences...");
            jMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    MainWindow.this.prefs();
                }
            });
            jMenu.add(jMenuItem);
            jMenuItem = new JMenuItem("Exit");
            jMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    MainWindow.this.quit();
                }
            });
            jMenu.add(jMenuItem);
            this.myFrame.getJMenuBar().add(jMenu);
        }
        jMenu = new JMenu("Actions");
        this.powerMenuItem = new JMenuItem("Turn Radio On");
        this.powerMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MainWindow.this.powerToggle();
            }
        });
        jMenu.add(this.powerMenuItem);
        this.compactMenuItem = new JMenuItem("Compact view");
        this.compactMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MainWindow.this.toggleCompactView();
            }
        });
        this.compactMenuItem.setEnabled(false);
        jMenu.add(this.compactMenuItem);
        this.myFrame.getJMenuBar().add(jMenu);
        class DynamicBookmarkMenu
        extends JMenu {
            private ChannelInfo info;

            public DynamicBookmarkMenu(String string) {
                super(string);
                super.addMenuListener(new MenuListener(){

                    public void menuDeselected(MenuEvent menuEvent) {
                    }

                    public void menuCanceled(MenuEvent menuEvent) {
                    }

                    public void menuSelected(MenuEvent menuEvent) {
                        info = new ChannelInfo(MainWindow.this.currentChannelInfo);
                        this.removeAll();
                        for (int i = 0; i < MainWindow.this.bookmarks.length; ++i) {
                            final Bookmark bookmark = MainWindow.this.bookmarks[i];
                            JMenuItem jMenuItem = new JMenuItem(bookmark.getName());
                            jMenuItem.addActionListener(new ActionListener(){

                                public void actionPerformed(ActionEvent actionEvent) {
                                    MainWindow.this.bookmarkSurf(bookmark, info);
                                }
                            });
                            this.add(jMenuItem);
                        }
                    }
                });
            }
        }
        this.bookmarkMenu = new DynamicBookmarkMenu("Web Bookmarks");
        this.bookmarkMenu.setEnabled(false);
        this.myFrame.getJMenuBar().add(this.bookmarkMenu);
        jMenu = new JMenu("Windows");
        if (PlatformFactory.ourPlatform().useMacMenus()) {
            jMenuItem = new JMenuItem("Main Window");
            jMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    MainWindow.frontOrShow(MainWindow.this.myFrame);
                }
            });
            jMenu.add(jMenuItem);
        }
        jMenuItem = new JMenuItem("Notebook");
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MainWindow.frontOrShow(MainWindow.this.memoryPanel);
            }
        });
        jMenu.add(jMenuItem);
        this.myFrame.getJMenuBar().add(jMenu);
        if (!PlatformFactory.ourPlatform().useMacMenus()) {
            jMenu = new JMenu("Help");
            jMenuItem = new JMenuItem("About JXM...");
            jMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    MainWindow.this.about();
                }
            });
            jMenu.add(jMenuItem);
            this.myFrame.getJMenuBar().add(jMenu);
        }
        this.myFrame.getContentPane().setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 3));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 2));
        jPanel2.add(Box.createHorizontalStrut(20));
        JPanel jPanel3 = new JPanel();
        jPanel3.setBorder(BorderFactory.createLoweredBevelBorder());
        this.channelLogo = new JLabel();
        this.channelLogo.setToolTipText("Click to visit this Channel's Home Page");
        this.channelLogo.setPreferredSize(new Dimension(150, 100));
        this.setChannelLogo(-1);
        this.channelLogo.addMouseListener(new MouseAdapter(){
            boolean didPopup = false;

            public void mousePressed(MouseEvent mouseEvent) {
                this.maybePopup(mouseEvent);
            }

            public void mouseReleased(MouseEvent mouseEvent) {
                this.maybePopup(mouseEvent);
            }

            public void maybePopup(MouseEvent mouseEvent) {
                if (!RadioCommander.theRadio().isOn()) {
                    return;
                }
                if (mouseEvent.isPopupTrigger()) {
                    this.didPopup = true;
                    ChannelInfo channelInfo = new ChannelInfo(MainWindow.this.currentChannelInfo);
                    MainWindow mainWindow = MainWindow.this;
                    mainWindow.getClass();
                    ChannelPopupMenu channelPopupMenu = mainWindow.new ChannelPopupMenu(channelInfo, 2);
                    channelPopupMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
                }
            }

            public void mouseClicked(MouseEvent mouseEvent) {
                if (this.didPopup) {
                    this.didPopup = false;
                    return;
                }
                if (!RadioCommander.theRadio().isOn()) {
                    return;
                }
                MainWindow.this.surfToChannel(RadioCommander.theRadio().getChannel());
            }
        });
        jPanel3.add(this.channelLogo);
        jPanel2.add(jPanel3);
        jPanel2.add(Box.createHorizontalStrut(5));
        this.nowPlayingPanel = new ChannelInfoPanel();
        this.nowPlayingPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(1), "Now Playing", 2, 0));
        this.nowPlayingPanel.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                this.maybePopup(mouseEvent);
            }

            public void mouseReleased(MouseEvent mouseEvent) {
                this.maybePopup(mouseEvent);
            }

            private void maybePopup(MouseEvent mouseEvent) {
                if (!RadioCommander.theRadio().isOn()) {
                    return;
                }
                if (!mouseEvent.isPopupTrigger()) {
                    return;
                }
                ChannelInfo channelInfo = new ChannelInfo(MainWindow.this.currentChannelInfo);
                MainWindow mainWindow = MainWindow.this;
                mainWindow.getClass();
                ChannelPopupMenu channelPopupMenu = mainWindow.new ChannelPopupMenu(channelInfo, 2);
                channelPopupMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
            }
        });
        jPanel2.add(this.nowPlayingPanel);
        jPanel2.add(Box.createHorizontalStrut(5));
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        this.memoryButton = new JButton("Add to notebook");
        this.memoryButton.setToolTipText("Adds current Song Info to your \"notebook\"");
        this.memoryButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MainWindow.this.memorize(MainWindow.this.currentChannelInfo);
            }
        });
        this.memoryButton.setEnabled(false);
        gridBagConstraints2.weightx = 0.0;
        gridBagConstraints2.fill = 0;
        jPanel4.add((Component)this.memoryButton, gridBagConstraints2);
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
        jPanel5.setOpaque(false);
        jPanel5.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(new Color(0, 0, 0, 0), 0), "Quick Search", 2, 6, new Font(null, 0, 10)));
        this.searchField = new JTextField();
        this.searchField.setToolTipText("Filters Channel Grid as you type");
        this.searchField.getDocument().addDocumentListener(new DocumentListener(){

            public void changedUpdate(DocumentEvent documentEvent) {
                this.doit();
            }

            public void insertUpdate(DocumentEvent documentEvent) {
                this.doit();
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                this.doit();
            }

            private void doit() {
                MainWindow.this.rebuildSortedChannelList();
                MainWindow.this.selectCurrentChannel();
            }
        });
        this.searchField.setPreferredSize(new Dimension(100, (int)this.searchField.getPreferredSize().getHeight()));
        this.searchField.setEnabled(false);
        gridBagConstraints3.weightx = 1.0;
        gridBagConstraints3.gridx = 0;
        gridBagConstraints3.gridy = 0;
        gridBagConstraints3.fill = 2;
        jPanel5.add((Component)this.searchField, gridBagConstraints3);
        this.searchFieldClear = new JButton();
        this.searchFieldClear.setIcon(new XIcon());
        this.searchFieldClear.setToolTipText("Clear Quick Search filter");
        this.searchFieldClear.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MainWindow.this.searchField.setText("");
            }
        });
        this.searchFieldClear.setEnabled(false);
        gridBagConstraints3.weightx = 0.0;
        gridBagConstraints3.gridx = 1;
        gridBagConstraints3.gridy = 0;
        gridBagConstraints3.fill = 0;
        gridBagConstraints3.anchor = 22;
        jPanel5.add((Component)this.searchFieldClear, gridBagConstraints3);
        gridBagConstraints2.insets = new Insets(10, 0, 0, 0);
        gridBagConstraints2.gridy = 1;
        jPanel4.add((Component)jPanel5, gridBagConstraints2);
        jPanel4.setMaximumSize(jPanel4.getPreferredSize());
        jPanel2.add(jPanel4);
        jPanel2.add(Box.createHorizontalStrut(20));
        jPanel.add(jPanel2);
        jPanel.add(Box.createVerticalStrut(10));
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
        JPanel jPanel7 = new JPanel();
        jPanel7.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints5 = new GridBagConstraints();
        this.favoriteMenu = new JComboBox();
        this.favoriteMenu.setToolTipText("Jump to a Favorite Channel");
        this.favoriteMenu.setPreferredSize(new Dimension(150, (int)this.favoriteMenu.getPreferredSize().getHeight()));
        this.favoriteMenu.addItem("Favorites");
        this.favoriteMenu.setSelectedIndex(0);
        this.favoriteMenu.setEnabled(false);
        this.favoriteMenu.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (MainWindow.this.ignoreFavoriteMenu) {
                    return;
                }
                Object object = MainWindow.this.favoriteMenu.getSelectedItem();
                if (!(object instanceof Integer)) {
                    if (MainWindow.this.currentChannelInfo == null) {
                        return;
                    }
                    Integer n = new Integer(MainWindow.this.currentChannelInfo.getServiceID());
                    if (MainWindow.this.favoriteList.contains(n)) {
                        MainWindow.this.ignoreFavoriteMenu = true;
                        MainWindow.this.favoriteMenu.setSelectedItem(n);
                        MainWindow.this.ignoreFavoriteMenu = false;
                    }
                    return;
                }
                Integer n = (Integer)object;
                MainWindow.this.favoriteMenu.setSelectedIndex(0);
                ChannelInfo channelInfo = (ChannelInfo)MainWindow.this.channelList.get(n);
                if (channelInfo == null) {
                    return;
                }
                MainWindow.this.setChannel(channelInfo.getChannelNumber());
            }
        });
        this.favoriteMenu.setRenderer(new DefaultListCellRenderer(){

            public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
                if (object instanceof Integer && MainWindow.this.channelList != null) {
                    Integer n2 = (Integer)object;
                    ChannelInfo channelInfo = (ChannelInfo)MainWindow.this.channelList.get(n2);
                    object = channelInfo == null ? "Service ID " + n2 : Integer.toString(channelInfo.getChannelNumber()) + " - " + channelInfo.getChannelName();
                }
                return super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
            }
        });
        gridBagConstraints5.weightx = 1.0;
        gridBagConstraints5.anchor = 10;
        gridBagConstraints5.fill = 2;
        jPanel7.add((Component)this.favoriteMenu, gridBagConstraints5);
        this.favoriteCheckbox = new JToggleButton(new ImageIcon(this.getClass().getResource("/images/no_heart.png")));
        this.favoriteCheckbox.setToolTipText("Add/Remove current Channel from your Favorites");
        this.favoriteCheckbox.setSelectedIcon(new ImageIcon(this.getClass().getResource("/images/heart.png")));
        this.favoriteCheckbox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Integer n = new Integer(MainWindow.this.currentChannelInfo.getServiceID());
                boolean bl = MainWindow.this.favoriteCheckbox.isSelected();
                if (bl) {
                    MainWindow.this.favoriteList.add(n);
                } else {
                    MainWindow.this.favoriteList.remove(n);
                }
                MainWindow.this.saveFavorites();
                MainWindow.this.rebuildFavoritesMenu();
            }
        });
        this.favoriteCheckbox.setEnabled(false);
        gridBagConstraints5.weightx = 0.0;
        gridBagConstraints5.gridx = 1;
        gridBagConstraints5.anchor = 10;
        gridBagConstraints5.fill = 0;
        jPanel7.add((Component)this.favoriteCheckbox, gridBagConstraints5);
        gridBagConstraints4.weightx = 0.0;
        gridBagConstraints4.insets = new Insets(0, 20, 0, 0);
        gridBagConstraints4.anchor = 21;
        jPanel6.add((Component)jPanel7, gridBagConstraints4);
        JPanel jPanel8 = new JPanel();
        jPanel8.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints6 = new GridBagConstraints();
        this.ratingSlider = new JSlider(-5, 5);
        this.ratingSlider.setToolTipText("Drag left if you dislike the current song, right if you like it");
        this.ratingSlider.setMajorTickSpacing(5);
        this.ratingSlider.setMinorTickSpacing(1);
        this.ratingSlider.setSnapToTicks(true);
        this.ratingSlider.setPaintTicks(true);
        this.ratingSlider.setEnabled(false);
        gridBagConstraints6.weightx = 1.0;
        gridBagConstraints6.gridwidth = 3;
        gridBagConstraints6.fill = 2;
        jPanel8.add((Component)this.ratingSlider, gridBagConstraints6);
        JLabel jLabel = new JLabel("-");
        gridBagConstraints6.gridwidth = 1;
        gridBagConstraints6.fill = 0;
        gridBagConstraints6.anchor = 21;
        gridBagConstraints6.gridy = 1;
        gridBagConstraints6.gridx = 0;
        gridBagConstraints6.weightx = 0.0;
        jPanel8.add((Component)jLabel, gridBagConstraints6);
        jLabel = new JLabel("Rate Song");
        jLabel.setHorizontalAlignment(0);
        gridBagConstraints6.gridx = 1;
        gridBagConstraints6.weightx = 1.0;
        gridBagConstraints6.anchor = 10;
        jPanel8.add((Component)jLabel, gridBagConstraints6);
        jLabel = new JLabel("+");
        gridBagConstraints6.weightx = 0.0;
        gridBagConstraints6.gridx = 2;
        gridBagConstraints6.anchor = 22;
        jPanel8.add((Component)jLabel, gridBagConstraints6);
        gridBagConstraints4.weightx = 1.0;
        gridBagConstraints4.gridx = 1;
        gridBagConstraints4.insets = new Insets(0, 20, 0, 20);
        gridBagConstraints4.fill = 2;
        gridBagConstraints4.anchor = 10;
        jPanel6.add((Component)jPanel8, gridBagConstraints4);
        this.filterMenu = this.filterPanel.getFilterMenu();
        this.filterMenu.setToolTipText("Pick a set of Channels to show in the Grid");
        gridBagConstraints4.gridx = 2;
        gridBagConstraints4.weightx = 0.0;
        gridBagConstraints4.fill = 2;
        gridBagConstraints4.anchor = 22;
        gridBagConstraints4.insets = new Insets(0, 0, 0, 20);
        gridBagConstraints4.fill = 0;
        this.filterMenu.setPreferredSize(new Dimension((int)jPanel7.getPreferredSize().getWidth(), (int)this.filterMenu.getPreferredSize().getHeight()));
        jPanel6.add((Component)this.filterMenu, gridBagConstraints4);
        jPanel.add(jPanel6);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(10, 0, 0, 0);
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 19;
        this.myFrame.getContentPane().add((Component)jPanel, gridBagConstraints);
        this.channelTable = new JTable();
        this.channelTable.setAutoCreateColumnsFromModel(false);
        this.channelTable.setShowGrid(true);
        this.channelTable.setGridColor(gridColor);
        this.channelTable.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                this.maybePopup(mouseEvent);
            }

            public void mouseReleased(MouseEvent mouseEvent) {
                this.maybePopup(mouseEvent);
            }

            private void maybePopup(MouseEvent mouseEvent) {
                if (!RadioCommander.theRadio().isOn()) {
                    return;
                }
                if (!mouseEvent.isPopupTrigger()) {
                    return;
                }
                MainWindow.this.channelTableClickWasPopup = true;
                int n = MainWindow.this.channelTable.rowAtPoint(mouseEvent.getPoint());
                if (n < 0) {
                    return;
                }
                ChannelInfo channelInfo = new ChannelInfo(MainWindow.this.sortedChannelList[n]);
                MainWindow mainWindow = MainWindow.this;
                mainWindow.getClass();
                ChannelPopupMenu channelPopupMenu = mainWindow.new ChannelPopupMenu(channelInfo);
                channelPopupMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
            }
        });
        this.channelTableModel = new ChannelTableModel();
        this.channelTable.setModel(this.channelTableModel);
        class HeaderRenderer
        extends DefaultTableCellRenderer {
            public HeaderRenderer() {
                this.setHorizontalAlignment(0);
                this.setOpaque(true);
                this.setBorder(UIManager.getBorder("TableHeader.cellBorder"));
            }

            public void updateUI() {
                super.updateUI();
                this.setBorder(UIManager.getBorder("TableHeader.cellBorder"));
            }

            public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                int n3 = jTable.getColumnModel().getColumn(n2).getModelIndex();
                if (n3 == MainWindow.this.sortField) {
                    this.setForeground(jTable.getSelectionForeground());
                    this.setBackground(jTable.getSelectionBackground());
                    this.setHorizontalTextPosition(10);
                    this.setVerticalTextPosition(0);
                    this.setIcon(MainWindow.this.sortDirection ? MainWindow.this.upArrow : MainWindow.this.downArrow);
                } else {
                    this.setForeground(UIManager.getColor("TableHeader.foreground"));
                    this.setBackground(UIManager.getColor("TableHeader.background"));
                    this.setIcon(null);
                }
                this.setFont(UIManager.getFont("TableHeader.font"));
                this.setValue(object);
                return this;
            }
        }
        HeaderRenderer headerRenderer = new HeaderRenderer();
        byte[] byArray = JXM.myUserNode().getByteArray(CHAN_TABLE_COLS, null);
        if (byArray == null || byArray.length != 6) {
            byArray = new byte[]{0, 1, 2, 3, 4, 5};
        } else {
            for (int i = 0; i < byArray.length; ++i) {
                if (byArray[i] >= 0 && byArray[i] <= 5) continue;
                byArray = new byte[]{0, 1, 2, 3, 4, 5};
                break;
            }
        }
        DefaultTableColumnModel defaultTableColumnModel = new DefaultTableColumnModel();
        class MyTableCellRenderer
        extends DefaultTableCellRenderer {
            MyTableCellRenderer() {
            }

            public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                Component component = super.getTableCellRendererComponent(jTable, object, bl, false, n, n2);
                if (!bl) {
                    component.setForeground(Color.BLACK);
                    component.setBackground(n % 2 == 0 ? Color.WHITE : stripeColor);
                } else {
                    component.setForeground(MainWindow.this.channelTable.getSelectionForeground());
                    component.setBackground(MainWindow.this.channelTable.getSelectionBackground());
                }
                return component;
            }
        }
        MyTableCellRenderer myTableCellRenderer = new MyTableCellRenderer();
        myTableCellRenderer.setHorizontalAlignment(0);
        MyTableCellRenderer myTableCellRenderer2 = new MyTableCellRenderer();
        for (n = 0; n < byArray.length; ++n) {
            TableColumn tableColumn;
            switch (byArray[n]) {
                case 0: {
                    tableColumn = new TableColumn(0, 80, null, null);
                    tableColumn.setMinWidth(80);
                    tableColumn.setCellRenderer(myTableCellRenderer);
                    tableColumn.setHeaderValue("Num.");
                    break;
                }
                case 1: {
                    tableColumn = new TableColumn(1, 100, null, null);
                    tableColumn.setMinWidth(100);
                    tableColumn.setCellRenderer(myTableCellRenderer2);
                    tableColumn.setHeaderValue("Genre");
                    break;
                }
                case 2: {
                    tableColumn = new TableColumn(2, 100, null, null);
                    tableColumn.setMinWidth(100);
                    tableColumn.setCellRenderer(myTableCellRenderer2);
                    tableColumn.setHeaderValue("Name");
                    break;
                }
                case 3: {
                    tableColumn = new TableColumn(3, 160, null, null);
                    tableColumn.setMinWidth(160);
                    tableColumn.setCellRenderer(myTableCellRenderer2);
                    tableColumn.setHeaderValue("Artist");
                    break;
                }
                case 4: {
                    tableColumn = new TableColumn(4, 160, null, null);
                    tableColumn.setMinWidth(160);
                    tableColumn.setCellRenderer(myTableCellRenderer2);
                    tableColumn.setHeaderValue("Title");
                    break;
                }
                case 5: {
                    tableColumn = new TableColumn(5, 80, null, null);
                    tableColumn.setMinWidth(80);
                    tableColumn.setCellRenderer(myTableCellRenderer);
                    tableColumn.setHeaderValue("% In Use");
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Which column?!");
                }
            }
            tableColumn.setHeaderRenderer(headerRenderer);
            defaultTableColumnModel.addColumn(tableColumn);
        }
        this.channelTable.setColumnModel(defaultTableColumnModel);
        n = defaultTableColumnModel.getTotalColumnWidth();
        this.channelTable.setColumnSelectionAllowed(false);
        this.channelTable.setRowSelectionAllowed(true);
        this.channelTable.setSelectionMode(0);
        this.channelTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (MainWindow.this.ignoreSelectionChange) {
                    return;
                }
                if (MainWindow.this.channelTableClickWasPopup) {
                    if (listSelectionEvent.getValueIsAdjusting()) {
                        return;
                    }
                    MainWindow.this.channelTableClickWasPopup = false;
                    MainWindow.this.disallowSelectionChange = false;
                    MainWindow.this.selectCurrentChannel();
                    return;
                }
                MainWindow.this.disallowSelectionChange = listSelectionEvent.getValueIsAdjusting();
                if (listSelectionEvent.getValueIsAdjusting()) {
                    return;
                }
                ListSelectionModel listSelectionModel = (ListSelectionModel)listSelectionEvent.getSource();
                if (!listSelectionModel.isSelectionEmpty()) {
                    int n = listSelectionModel.getMinSelectionIndex();
                    if (n >= MainWindow.this.sortedChannelList.length) {
                        return;
                    }
                    ChannelInfo channelInfo = MainWindow.this.sortedChannelList[n];
                    if (RadioCommander.theRadio().getChannel() != channelInfo.getChannelNumber()) {
                        MainWindow.this.setChannel(channelInfo.getChannelNumber());
                    }
                }
            }
        });
        this.channelTable.getTableHeader().addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                TableColumnModel tableColumnModel = MainWindow.this.channelTable.getColumnModel();
                int n = tableColumnModel.getColumnIndexAtX(mouseEvent.getX());
                int n2 = MainWindow.this.channelTable.convertColumnIndexToModel(n);
                if (n2 == MainWindow.this.sortField) {
                    MainWindow.this.sortDirection = !MainWindow.this.sortDirection;
                } else {
                    MainWindow.this.sortField = n2;
                    MainWindow.this.sortDirection = n2 != 5;
                }
                JXM.myUserNode().putInt(MainWindow.SORT_FIELD, MainWindow.this.sortField);
                JXM.myUserNode().putBoolean(MainWindow.SORT_DIR, MainWindow.this.sortDirection);
                MainWindow.this.rebuildSortedChannelList();
                MainWindow.this.scrollToCurrentChannel();
                MainWindow.this.selectCurrentChannel();
            }
        });
        this.sortField = JXM.myUserNode().getInt(SORT_FIELD, 0);
        if (this.sortField < 0 || this.sortField > 5) {
            this.sortField = 0;
        }
        this.sortDirection = JXM.myUserNode().getBoolean(SORT_DIR, true);
        this.channelTable.setPreferredScrollableViewportSize(new Dimension(n, this.channelTable.getRowHeight() * 15));
        this.channelTable.setAutoResizeMode(0);
        JScrollPane jScrollPane = new JScrollPane();
        class StripedViewport
        extends JViewport {
            public StripedViewport() {
                MainWindow.this.channelTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

                    public void valueChanged(ListSelectionEvent listSelectionEvent) {
                        this.repaint();
                    }
                });
            }

            public void paint(Graphics graphics) {
                int n = MainWindow.this.channelTable.getRowHeight();
                int n2 = 0;
                for (n2 = (int)((double)n2 - this.getViewPosition().getY() % (double)(n * 2)); n2 < this.getHeight(); n2 += n) {
                    graphics.setColor(gridColor);
                    graphics.drawLine(0, n2 - 1, this.getWidth(), n2 - 1);
                    graphics.setColor(Color.WHITE);
                    graphics.fillRect(0, n2, this.getWidth(), n);
                    graphics.setColor(gridColor);
                    graphics.drawLine(0, (n2 += n) - 1, this.getWidth(), n2 - 1);
                    graphics.setColor(stripeColor);
                    graphics.fillRect(0, n2, this.getWidth(), n);
                }
                int n3 = MainWindow.this.channelTable.getSelectedRow();
                int n4 = n3 * n;
                if ((n4 = (int)((double)n4 - this.getViewPosition().getY())) >= -n && n4 <= this.getHeight()) {
                    graphics.setColor(MainWindow.this.channelTable.getSelectionBackground());
                    graphics.fillRect(0, n4, this.getWidth(), n - 1);
                }
                super.paint(graphics);
            }
        }
        StripedViewport stripedViewport = new StripedViewport();
        stripedViewport.setOpaque(false);
        stripedViewport.setScrollMode(0);
        jScrollPane.setViewport(stripedViewport);
        jScrollPane.setViewportView(this.channelTable);
        jScrollPane.setHorizontalScrollBarPolicy(30);
        jScrollPane.setVerticalScrollBarPolicy(22);
        gridBagConstraints.insets = new Insets(20, 20, 20, 20);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 10;
        this.myFrame.getContentPane().add((Component)jScrollPane, gridBagConstraints);
        JPanel jPanel9 = new JPanel();
        jPanel9.setLayout(new GridBagLayout());
        gridBagConstraints4 = new GridBagConstraints();
        this.muteButton = new JCheckBox("Mute");
        this.muteButton.setToolTipText("Mutes radio volume");
        this.muteButton.setEnabled(false);
        this.muteButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MainWindow.this.muteClicked();
            }
        });
        gridBagConstraints4.gridy = 0;
        gridBagConstraints4.gridx = 0;
        gridBagConstraints4.weightx = 0.0;
        gridBagConstraints4.weighty = 0.0;
        gridBagConstraints4.anchor = 21;
        gridBagConstraints4.fill = 2;
        gridBagConstraints4.insets = new Insets(0, 20, 0, 0);
        jPanel9.add((Component)this.muteButton, gridBagConstraints4);
        this.smartMuteButton = new JCheckBox("Smart Mute");
        this.smartMuteButton.setToolTipText("Mutes radio volume until Artist/Title changes");
        this.smartMuteButton.setEnabled(false);
        this.smartMuteButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MainWindow.this.smartMuteClicked();
            }
        });
        gridBagConstraints4.gridy = 1;
        gridBagConstraints4.insets = new Insets(0, 20, 20, 0);
        jPanel9.add((Component)this.smartMuteButton, gridBagConstraints4);
        this.powerCheckBox = new JCheckBox("Power");
        this.powerCheckBox.setToolTipText("Turns radio on and off");
        this.powerCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MainWindow.this.powerToggle();
            }
        });
        gridBagConstraints4.insets = new Insets(0, 20, 20, 10);
        gridBagConstraints4.gridx = 1;
        gridBagConstraints4.gridy = 0;
        gridBagConstraints4.gridheight = 2;
        gridBagConstraints4.weightx = 0.0;
        gridBagConstraints4.anchor = 22;
        jPanel9.add((Component)this.powerCheckBox, gridBagConstraints4);
        this.sleepButton = new JButton("Sleep");
        this.sleepButton.setToolTipText("Mute radio after a specified time");
        this.sleepButton.setIcon(this.nullIcon);
        this.sleepButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                int n;
                MainWindow.this.sleepButtonBlink(false);
                for (n = sleepSettings.length - 1; n >= 0 && MainWindow.this.sleepTime < sleepSettings[n]; --n) {
                }
                if (n == sleepSettings.length - 1) {
                    MainWindow.this.sleepTime = -1;
                } else {
                    MainWindow.this.sleepTime = sleepSettings[n + 1];
                }
                if (MainWindow.this.sleepTime < 0) {
                    MainWindow.this.sleepButton.setText("Sleep");
                } else {
                    MainWindow.this.sleepButton.setText(Integer.toString(MainWindow.this.sleepTime) + " min");
                }
            }
        });
        this.sleepButton.setEnabled(false);
        this.sleepButton.setPreferredSize(new Dimension(75, (int)this.sleepButton.getMinimumSize().getHeight()));
        gridBagConstraints4.gridx = 2;
        gridBagConstraints4.gridy = 0;
        gridBagConstraints4.gridheight = 2;
        gridBagConstraints4.weightx = 0.1;
        gridBagConstraints4.ipadx = 2;
        gridBagConstraints4.ipady = 2;
        gridBagConstraints4.anchor = 10;
        jPanel9.add((Component)this.sleepButton, gridBagConstraints4);
        jLabel = new JLabel("Satellite: ");
        jLabel.setToolTipText("Signal strength from XM Satellites");
        jLabel.setHorizontalAlignment(11);
        gridBagConstraints4.gridx = 3;
        gridBagConstraints4.gridy = 0;
        gridBagConstraints4.ipadx = 0;
        gridBagConstraints4.ipady = 0;
        gridBagConstraints4.weightx = 0.75;
        gridBagConstraints4.gridheight = 1;
        gridBagConstraints4.insets = new Insets(0, 0, 0, 0);
        gridBagConstraints4.anchor = 22;
        jPanel9.add((Component)jLabel, gridBagConstraints4);
        jLabel = new JLabel("Terrestrial: ");
        jLabel.setToolTipText("Signal strength from local ground-based repeaters");
        jLabel.setHorizontalAlignment(11);
        gridBagConstraints4.gridy = 1;
        gridBagConstraints4.insets = new Insets(0, 0, 20, 0);
        jPanel9.add((Component)jLabel, gridBagConstraints4);
        this.satelliteMeter = new SignalProgressBar(0, 100);
        this.satelliteMeter.setToolTipText("Signal strength from XM Satellites");
        gridBagConstraints4.gridx = 4;
        gridBagConstraints4.gridy = 0;
        gridBagConstraints4.weightx = 0.25;
        gridBagConstraints4.insets = new Insets(0, 0, 0, 20);
        gridBagConstraints4.anchor = 21;
        jPanel9.add((Component)this.satelliteMeter, gridBagConstraints4);
        this.terrestrialMeter = new SignalProgressBar(0, 100);
        this.terrestrialMeter.setToolTipText("Signal strength from local ground-based repeaters");
        gridBagConstraints4.gridy = 1;
        gridBagConstraints4.insets = new Insets(0, 0, 20, 20);
        jPanel9.add((Component)this.terrestrialMeter, gridBagConstraints4);
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 20;
        this.myFrame.getContentPane().add((Component)jPanel9, gridBagConstraints);
        this.myFrame.pack();
        this.myFrame.setResizable(true);
        this.compactView = new CompactViewPanel();
        this.myFrame.setVisible(true);
        java.util.Timer timer = new java.util.Timer();
        timer.schedule(new TimerTask(){

            public void run() {
                double[] dArray;
                if (!RadioCommander.theRadio().isOn()) {
                    return;
                }
                try {
                    dArray = RadioCommander.theRadio().getSignalStrength();
                }
                catch (RadioException radioException) {
                    MainWindow.this.handleError(radioException);
                    return;
                }
                Calendar calendar = Calendar.getInstance();
                calendar.setTime(new Date());
                int n = calendar.get(12);
                final boolean bl = MainWindow.this.lastMinute != n;
                MainWindow.this.lastMinute = n;
                final boolean bl2 = MainWindow.this.sleepTime == 0;
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        if (bl2) {
                            MainWindow.this.sleepButtonBlink(true);
                        }
                        if (bl) {
                            MainWindow.this.sleepTimerTick();
                        }
                        MainWindow.this.satelliteMeter.setValue((int)dArray[0]);
                        MainWindow.this.terrestrialMeter.setValue((int)dArray[1]);
                    }
                });
                if (MainWindow.this.currentChannelInfo == null) {
                    return;
                }
                Integer n2 = new Integer(MainWindow.this.currentChannelInfo.getServiceID());
                Integer n3 = (Integer)MainWindow.this.tickList.get(n2);
                if (n3 == null) {
                    n3 = new Integer(0);
                }
                n3 = new Integer(n3 + 1);
                MainWindow.this.tickList.put(n2, n3);
                if (MainWindow.this.sortField == 5) {
                    MainWindow.this.rebuildSortedChannelList();
                    MainWindow.this.selectCurrentChannel();
                } else {
                    MainWindow.this.firePercentChanges();
                }
            }
        }, 1000L, 1000L);
        this.loadFavorites();
        this.loadTickList();
        this.memoryPanel = new MemoryPanel(this);
        int n2 = -1;
        String[] stringArray2 = JXM.getCommandLine();
        if (stringArray2.length >= 1) {
            try {
                n2 = Integer.parseInt(stringArray2[0]);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if ((string = this.preferences.getDevice()) != null) {
            this.turnPowerOn(n2);
        }
        new java.util.Timer().schedule(new TimerTask(){

            public void run() {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        MainWindow.this.aboutDialog.startupCheck();
                    }
                });
            }
        }, 2500L);
    }

    private void firePercentChanges() {
        Iterator iterator = this.tickList.keySet().iterator();
        while (iterator.hasNext()) {
            Integer n = (Integer)iterator.next();
            int n2 = this.rowForSID(n);
            if (n2 < 0) continue;
            this.channelTableModel.fireTableRowsUpdated(n2, n2);
        }
    }

    private void surfToChannel(int n) {
        if (this.currentChannelInfo == null) {
            return;
        }
        this.bookmarkSurf(this.channelMark, this.currentChannelInfo);
    }

    private Icon findLogo(String string) {
        URL uRL;
        if (this.logoJar == null) {
            uRL = this.getClass().getResource("/logos/" + string);
        } else {
            try {
                uRL = new URL("jar:" + this.logoJar.toString() + "!/" + string);
            }
            catch (MalformedURLException malformedURLException) {
                return null;
            }
        }
        if (uRL == null) {
            return null;
        }
        ImageIcon imageIcon = new ImageIcon(uRL);
        if (imageIcon.getImageLoadStatus() != 8) {
            return null;
        }
        return imageIcon;
    }

    private void setChannelLogo(int n) {
        Icon icon = this.findLogo(n + ".png");
        if (icon == null) {
            icon = this.findLogo("default.gif");
        }
        this.channelLogo.setIcon(icon);
    }

    private void toggleCompactView() {
        if (this.compactView.isVisible()) {
            this.compactView.setVisible(false);
            this.myFrame.setVisible(true);
        } else {
            this.myFrame.setVisible(false);
            this.compactView.setVisible(true);
        }
    }

    public void forceNormalView() {
        if (this.compactView.isVisible()) {
            this.toggleCompactView();
        }
    }

    private void muteClicked() {
        boolean bl = RadioCommander.theRadio().isMuted();
        if (!bl || this.smartMuteInfo == null) {
            bl = !bl;
        }
        this.smartMuteInfo = null;
        try {
            RadioCommander.theRadio().setMute(bl);
        }
        catch (RadioException radioException) {
            this.handleError(radioException);
            return;
        }
    }

    private void smartMuteClicked() {
        boolean bl = RadioCommander.theRadio().isMuted();
        if (!bl || this.smartMuteInfo != null) {
            bl = !bl;
        }
        try {
            this.smartMuteInfo = bl ? RadioCommander.theRadio().getChannelInfo() : null;
            RadioCommander.theRadio().setMute(bl);
        }
        catch (RadioException radioException) {
            this.handleError(radioException);
            return;
        }
    }

    public void platformNotify(int n, Object object) {
        switch (n) {
            case 0: {
                this.prefs();
                break;
            }
            case 1: {
                this.about();
                break;
            }
            case 2: {
                this.quit();
                break;
            }
            case 3: {
                this.smartMuteClicked();
                break;
            }
            case 4: {
                this.muteClicked();
                break;
            }
            case 5: {
                this.setChannel((Integer)object);
                break;
            }
            case 6: {
                this.memorize((ChannelInfo)object);
                break;
            }
            default: {
                throw new IllegalArgumentException("Which platform callback type??");
            }
        }
    }

    public boolean radioIsOn() {
        return RadioCommander.theRadio().isOn();
    }

    public int getMuteState() {
        if (!RadioCommander.theRadio().isMuted()) {
            return 0;
        }
        if (this.smartMuteInfo != null) {
            return 2;
        }
        return 1;
    }

    public ChannelInfo getChannelInfo() {
        return this.currentChannelInfo;
    }

    public Favorite[] getFavorites() {
        ArrayList<Favorite> arrayList = new ArrayList<Favorite>();
        Iterator iterator = this.favoriteList.iterator();
        while (iterator.hasNext()) {
            Integer n = (Integer)iterator.next();
            ChannelInfo channelInfo = (ChannelInfo)this.channelList.get(n);
            if (channelInfo == null) continue;
            arrayList.add(new Favorite(channelInfo.getChannelNumber(), Integer.toString(channelInfo.getChannelNumber()) + " - " + channelInfo.getChannelName()));
        }
        Collections.sort(arrayList, new Comparator(){

            public int compare(Object object, Object object2) {
                Favorite favorite = (Favorite)object;
                Favorite favorite2 = (Favorite)object2;
                return new Integer(favorite.getChannelNumber()).compareTo(new Integer(favorite2.getChannelNumber()));
            }
        });
        return arrayList.toArray(new Favorite[0]);
    }

    public Bookmark[] getBookmarks() {
        return this.bookmarks;
    }

    public void notify(RadioCommander radioCommander, final int n, final Object object) {
        if (n == 1) {
            this.poweredDown();
            return;
        }
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                switch (n) {
                    case 0: {
                        MainWindow.this.poweredUp();
                        break;
                    }
                    case 8: {
                        MainWindow.this.deleteChannel((Integer)object);
                        break;
                    }
                    case 6: {
                        MainWindow.this.update((ChannelInfo)object);
                        break;
                    }
                    case 4: {
                        MainWindow.this.handleError((Exception)object);
                        break;
                    }
                    case 2: {
                        MainWindow.this.channelChanged();
                        break;
                    }
                    case 3: {
                        MainWindow.this.muteChanged();
                        break;
                    }
                    case 7: {
                        MainWindow.this.channelSongTime((RadioCommander.SongTiming)object);
                        break;
                    }
                    case 5: {
                        MainWindow.this.handleActivation((Boolean)object);
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Which kind of notification?");
                    }
                }
            }
        });
    }

    private void handleActivation(boolean bl) {
        if (bl) {
            if (this.activationDialog != null) {
                this.activationDialog.setVisible(false);
                this.activationDialog = null;
            }
            JOptionPane.showMessageDialog(this.myFrame, "Your XMPCR has been activated.\nThe channel grid will fill in shortly.", "Activation successful", 1);
        } else {
            String string;
            try {
                string = RadioCommander.theRadio().getRadioID();
            }
            catch (RadioException radioException) {
                this.handleError(radioException);
                return;
            }
            this.activationDialog = new ActivationDialog(this.myFrame, string);
            this.activationDialog.setVisible(true);
        }
    }

    private void setChannel(int n) {
        this.doNotSelectChannelsUntil = n;
        try {
            RadioCommander.theRadio().setChannel(n);
        }
        catch (RadioException radioException) {
            this.handleError(radioException);
        }
    }

    public JFrame getFrame() {
        return this.myFrame;
    }

    private void turnPowerOff() {
        try {
            RadioCommander.theRadio().turnOff();
        }
        catch (RadioException radioException) {
            this.handleError(radioException);
        }
    }

    private void powerToggle() {
        if (!RadioCommander.theRadio().isOn()) {
            this.turnPowerOn();
        } else {
            this.turnPowerOff();
        }
    }

    private void turnPowerOn() {
        this.turnPowerOn(-1);
    }

    private void turnPowerOn(int n) {
        String string = this.preferences.getDevice();
        if (string == null) {
            this.powerCheckBox.setSelected(false);
            JOptionPane.showMessageDialog(this.myFrame, "Please pick a device before powering up.", "No device selected", 0);
            this.preferences.showTab(0);
            return;
        }
        boolean bl = this.preferences.isDeviceXmDirect();
        try {
            RadioCommander.theRadio().registerEventHandler(this);
            RadioCommander.theRadio().turnOn(string, n, bl);
        }
        catch (RadioException radioException) {
            RadioCommander.theRadio().unregisterEventHandler(this);
            this.powerCheckBox.setSelected(false);
            this.handleError(radioException);
            return;
        }
    }

    private void poweredUp() {
        this.loadChannelList();
        this.rebuildSortedChannelList();
        this.compactView.refreshSpinnerModel();
        this.muteButton.setEnabled(true);
        this.smartMuteButton.setEnabled(true);
        this.memoryButton.setEnabled(true);
        this.muteButton.setSelected(false);
        this.smartMuteButton.setSelected(false);
        this.smartMuteInfo = null;
        this.powerCheckBox.setSelected(true);
        this.rebuildFavoritesMenu();
        this.favoriteCheckbox.setEnabled(true);
        this.filterMenu.setEnabled(this.filterMenu.getItemCount() > 1);
        this.searchField.setEnabled(true);
        this.searchFieldClear.setEnabled(true);
        this.compactMenuItem.setEnabled(true);
        this.preferences.saveDevice();
        this.bookmarkMenu.setEnabled(true);
        this.powerCheckBox.setSelected(true);
        this.powerMenuItem.setText("Turn Radio Off");
        this.sleepButton.setEnabled(true);
        this.channelChanged();
        try {
            String string = RadioCommander.theRadio().getRadioID();
            this.preferences.turnOn(string);
            this.updateUniqueUserID(string);
        }
        catch (RadioException radioException) {
            this.handleError(radioException);
        }
    }

    private void poweredDown() {
        RadioCommander.theRadio().unregisterEventHandler(this);
        try {
            XMTracker.theTracker().turnOff();
        }
        catch (TrackerException trackerException) {
            this.handleTrackerError(trackerException);
        }
        this.updateRatingSlider(null);
        if (this.channelList.size() != 0) {
            this.saveChannelList();
        }
        SwingUtilities.invokeLater(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                MainWindow.this.searchSystem.update(null);
                MainWindow.this.channelList.clear();
                MainWindow.access$202(MainWindow.this, new ChannelInfo[0]);
                MainWindow.this.channelTableModel.fireTableDataChanged();
                MainWindow.this.nowPlayingPanel.setChannelInfo(null);
                MainWindow.this.compactView.setChannelInfo(null);
                MainWindow.this.nowPlayingPanel.setSongTime(null, null);
                MainWindow.this.powerCheckBox.setSelected(false);
                MainWindow.this.searchFieldClear.setEnabled(false);
                MainWindow.this.muteButton.setEnabled(false);
                MainWindow.this.smartMuteButton.setEnabled(false);
                MainWindow.this.filterMenu.setEnabled(false);
                MainWindow.this.compactMenuItem.setEnabled(false);
                MainWindow.this.forceNormalView();
                MainWindow.this.powerCheckBox.setSelected(false);
                MainWindow.this.powerMenuItem.setText("Turn Radio On");
                MainWindow.this.searchField.setEnabled(false);
                MainWindow.this.memoryButton.setEnabled(false);
                MainWindow.this.muteButton.setSelected(false);
                MainWindow.this.smartMuteButton.setSelected(false);
                MainWindow.this.satelliteMeter.setValue(0);
                MainWindow.this.terrestrialMeter.setValue(0);
                MainWindow.this.setChannelLogo(-1);
                MainWindow.this.favoriteMenu.setEnabled(false);
                MainWindow.this.ignoreFavoriteMenu = true;
                try {
                    MainWindow.this.favoriteMenu.setSelectedIndex(0);
                }
                finally {
                    MainWindow.this.ignoreFavoriteMenu = false;
                }
                MainWindow.this.favoriteCheckbox.setEnabled(false);
                MainWindow.this.bookmarkMenu.setEnabled(false);
                MainWindow.this.sleepButton.setEnabled(false);
                MainWindow.this.sleepButton.setText("Sleep");
                MainWindow.this.sleepButtonBlink(false);
                MainWindow.this.sleepTime = -1;
                MainWindow.this.preferences.turnOff();
            }
        });
    }

    private void sleepTimerTick() {
        if (this.sleepTime < 0) {
            return;
        }
        --this.sleepTime;
        if (this.sleepTime < 0) {
            switch (this.preferences.getSleepAction()) {
                case 0: {
                    this.smartMuteInfo = null;
                    try {
                        RadioCommander.theRadio().setMute(true);
                    }
                    catch (RadioException radioException) {
                        this.handleError(radioException);
                    }
                    break;
                }
                case 1: {
                    this.turnPowerOff();
                    break;
                }
                case 2: {
                    this.quit();
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Sleep timer expired, but action unknown");
                }
            }
            this.sleepButton.setText("Sleep");
            this.sleepButtonBlink(false);
        } else if (this.sleepTime == 0) {
            this.sleepButton.setText("< 1 min");
            this.sleepButtonBlink(true);
        } else {
            this.sleepButton.setText(Integer.toString(this.sleepTime) + " min");
            this.sleepButtonBlink(false);
        }
    }

    private void sleepButtonBlink(boolean bl) {
        if (!bl) {
            if (this.savedSleepButtonForeground != null) {
                this.sleepButton.setForeground(this.savedSleepButtonForeground);
            }
            this.sleepButton.setFont(this.sleepButton.getFont().deriveFont(0));
            this.sleepButton.setIcon(this.nullIcon);
            return;
        }
        this.sleepButton.setFont(this.sleepButton.getFont().deriveFont(1));
        if (this.savedSleepButtonForeground == null) {
            this.savedSleepButtonForeground = this.sleepButton.getForeground();
        }
        this.sleepButton.setForeground(Color.RED);
        this.blinkCycle = !this.blinkCycle;
        this.sleepButton.setIcon(this.blinkCycle ? this.blinkIcon : this.blankIcon);
    }

    private void handleTrackerError(final Exception exception) {
        XMTracker.theTracker().Disable();
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                JOptionPane.showMessageDialog(MainWindow.this.myFrame, exception.getMessage(), "XM Tracker error", 0);
            }
        });
    }

    private void handleError(final Exception exception) {
        RadioCommander.theRadio().unregisterEventHandler(this);
        RadioCommander.theRadio().Dispose();
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                MainWindow.this.poweredDown();
                try {
                    JOptionPane.showMessageDialog(MainWindow.this.myFrame, exception.getMessage(), "Error communicating with radio", 0);
                }
                catch (HeadlessException headlessException) {
                    System.err.println("Error communicating with radio: " + headlessException.getMessage());
                }
            }
        });
    }

    private void muteChanged() {
        if (RadioCommander.theRadio().isMuted()) {
            this.muteButton.setSelected(this.smartMuteInfo == null);
            this.smartMuteButton.setSelected(this.smartMuteInfo != null);
        } else {
            this.muteButton.setSelected(false);
            this.smartMuteButton.setSelected(false);
        }
    }

    private void channelSongTime(RadioCommander.SongTiming songTiming) {
        this.nowPlayingPanel.setSongTime(songTiming.start(), songTiming.end());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void channelChanged() {
        int n = RadioCommander.theRadio().getChannel();
        this.setChannelLogo(n);
        Integer n2 = new Integer(this.sidForChannel(n));
        this.currentChannelInfo = (ChannelInfo)this.channelList.get(n2);
        this.updateRatingSlider(this.currentChannelInfo);
        this.nowPlayingPanel.setChannelInfo(this.currentChannelInfo);
        this.compactView.setChannelInfo(this.currentChannelInfo);
        this.nowPlayingPanel.setSongTime(null, null);
        boolean bl = this.favoriteList.contains(n2);
        this.favoriteCheckbox.setSelected(bl);
        this.ignoreFavoriteMenu = true;
        try {
            if (bl) {
                this.favoriteMenu.setSelectedItem(n2);
            } else {
                this.favoriteMenu.setSelectedIndex(0);
            }
        }
        finally {
            this.ignoreFavoriteMenu = false;
        }
        this.scrollToCurrentChannel();
        this.scheduleTrackerUpdate();
    }

    private void deleteChannel(int n) {
        Iterator iterator = this.channelList.values().iterator();
        while (iterator.hasNext()) {
            ChannelInfo channelInfo = (ChannelInfo)iterator.next();
            if (channelInfo.getChannelNumber() != n) continue;
            iterator.remove();
            if (!this.favoriteList.contains(new Integer(channelInfo.getServiceID()))) continue;
            this.rebuildFavoritesMenu();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void selectCurrentChannel() {
        if (!RadioCommander.theRadio().isOn()) {
            return;
        }
        if (this.disallowSelectionChange) {
            return;
        }
        if (this.doNotSelectChannelsUntil >= 0 && this.doNotSelectChannelsUntil != this.currentChannelInfo.getChannelNumber()) {
            return;
        }
        this.doNotSelectChannelsUntil = -1;
        this.ignoreSelectionChange = true;
        try {
            if (this.currentChannelInfo == null) {
                return;
            }
            int n = this.rowForSID(this.currentChannelInfo.getServiceID());
            if (n < 0) {
                this.channelTable.clearSelection();
            } else {
                this.channelTable.addRowSelectionInterval(n, n);
            }
        }
        finally {
            this.ignoreSelectionChange = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void rebuildFavoritesMenu() {
        ArrayList<ChannelInfo> arrayList = new ArrayList<ChannelInfo>();
        Iterator iterator = this.favoriteList.iterator();
        while (iterator.hasNext()) {
            Integer n = (Integer)iterator.next();
            ChannelInfo channelInfo = (ChannelInfo)this.channelList.get(n);
            if (channelInfo == null) continue;
            arrayList.add(channelInfo);
        }
        Collections.sort(arrayList, new Comparator(){

            public int compare(Object object, Object object2) {
                ChannelInfo channelInfo = (ChannelInfo)object;
                ChannelInfo channelInfo2 = (ChannelInfo)object2;
                return new Integer(channelInfo.getChannelNumber()).compareTo(new Integer(channelInfo2.getChannelNumber()));
            }
        });
        this.ignoreFavoriteMenu = true;
        try {
            this.favoriteMenu.removeAllItems();
            this.favoriteMenu.addItem("Favorites");
            this.favoriteMenu.setSelectedIndex(0);
            if (arrayList.isEmpty()) {
                this.favoriteMenu.setEnabled(false);
            } else {
                this.favoriteMenu.setEnabled(true);
                for (int i = 0; i < arrayList.size(); ++i) {
                    this.favoriteMenu.addItem(new Integer(((ChannelInfo)arrayList.get(i)).getServiceID()));
                }
            }
            if (this.currentChannelInfo == null || !RadioCommander.theRadio().isOn()) {
                return;
            }
            Integer n = new Integer(this.currentChannelInfo.getServiceID());
            if (this.favoriteList.contains(n)) {
                this.favoriteMenu.setSelectedItem(n);
            } else {
                this.favoriteMenu.setSelectedIndex(0);
            }
        }
        finally {
            this.ignoreFavoriteMenu = false;
        }
    }

    private void loadFavorites() {
        this.favoriteList.clear();
        byte[] byArray = JXM.myUserNode().getByteArray(FAVORITE_LIST, new byte[0]);
        for (int i = 0; i < byArray.length; ++i) {
            this.favoriteList.add(new Integer(byArray[i] & 0xFF));
        }
    }

    private void saveFavorites() {
        byte[] byArray = new byte[this.favoriteList.size()];
        int n = 0;
        Iterator iterator = this.favoriteList.iterator();
        while (iterator.hasNext()) {
            byArray[n++] = (byte)((Integer)iterator.next()).intValue();
        }
        JXM.myUserNode().putByteArray(FAVORITE_LIST, byArray);
    }

    private void saveChannelList() {
        Preferences preferences = JXM.myUserNode().node(GRID_NODE);
        try {
            preferences.clear();
        }
        catch (BackingStoreException backingStoreException) {
            return;
        }
        Iterator iterator = this.channelList.values().iterator();
        while (iterator.hasNext()) {
            ChannelInfo channelInfo = (ChannelInfo)iterator.next();
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(channelInfo.getChannelNumber());
            stringBuffer.append(':');
            stringBuffer.append(channelInfo.getServiceID());
            stringBuffer.append(':');
            try {
                stringBuffer.append(URLEncoder.encode(channelInfo.getChannelGenre(), "US-ASCII"));
                stringBuffer.append(':');
                stringBuffer.append(URLEncoder.encode(channelInfo.getChannelName(), "US-ASCII"));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                return;
            }
            preferences.put(Integer.toString(channelInfo.getServiceID()), stringBuffer.toString());
        }
    }

    private void saveTickList() {
        Preferences preferences = JXM.myUserNode().node(TICK_NODE);
        try {
            preferences.clear();
        }
        catch (BackingStoreException backingStoreException) {
            return;
        }
        if (this.tickList == null) {
            return;
        }
        Iterator iterator = this.tickList.keySet().iterator();
        while (iterator.hasNext()) {
            Integer n = (Integer)iterator.next();
            int n2 = (Integer)this.tickList.get(n);
            preferences.putInt(n.toString(), n2);
        }
    }

    private void loadChannelList() {
        Object object;
        String[] stringArray;
        this.channelList.clear();
        Preferences preferences = JXM.myUserNode().node(GRID_NODE);
        try {
            stringArray = preferences.keys();
        }
        catch (BackingStoreException backingStoreException) {
            return;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            ChannelInfo channelInfo;
            String[] stringArray2;
            object = preferences.get(stringArray[i], null);
            if (object == null || (stringArray2 = ((String)object).split(":", -1)).length != 4) continue;
            try {
                int n = Integer.parseInt(stringArray2[0]);
                int n2 = Integer.parseInt(stringArray2[1]);
                String string = URLDecoder.decode(stringArray2[2], "US-ASCII");
                String string2 = URLDecoder.decode(stringArray2[3], "US-ASCII");
                channelInfo = new ChannelInfo(n, n2, string, string2, "", "");
            }
            catch (Exception exception) {
                continue;
            }
            this.channelList.put(new Integer(channelInfo.getServiceID()), channelInfo);
        }
        int[] nArray = new int[this.channelList.size()];
        object = this.channelList.values().iterator();
        int n = 0;
        while (object.hasNext()) {
            nArray[n++] = ((ChannelInfo)object.next()).getChannelNumber();
        }
        RadioCommander.theRadio().setChannelList(nArray);
    }

    private void loadTickList() {
        String[] stringArray;
        Preferences preferences = JXM.myUserNode().node(TICK_NODE);
        try {
            stringArray = preferences.keys();
        }
        catch (BackingStoreException backingStoreException) {
            return;
        }
        this.tickList.clear();
        for (int i = 0; i < stringArray.length; ++i) {
            try {
                Integer n = new Integer(Integer.parseInt(stringArray[i]));
                int n2 = preferences.getInt(stringArray[i], 0);
                this.tickList.put(n, new Integer(n2));
                continue;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }

    private void updateRatingSlider(ChannelInfo channelInfo) {
        int n;
        final ChannelInfo channelInfo2 = this.ratingChannelInfo;
        boolean bl = false;
        if (channelInfo != null) {
            if (channelInfo.equals(this.ratingChannelInfo)) {
                return;
            }
            bl = channelInfo.getChannelArtist().length() == 0 || channelInfo.getChannelTitle().length() == 0;
        } else {
            bl = true;
        }
        this.ratingChannelInfo = channelInfo;
        if (channelInfo2 != null && (n = this.ratingSlider.getValue()) != 0) {
            new Thread(){

                public void run() {
                    try {
                        MainWindow.this.rateSong(channelInfo2, n);
                    }
                    catch (Exception exception) {
                        SwingUtilities.invokeLater(new Runnable(){

                            public void run() {
                                JOptionPane.showMessageDialog(MainWindow.this.myFrame, exception.getMessage(), "Error while rating song", 0);
                            }
                        });
                    }
                }
            }.start();
        }
        this.ratingSlider.setValue(0);
        this.ratingSlider.setEnabled(!bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateUniqueUserID(String string) {
        byte[] byArray;
        Object object = myDigestMaker;
        synchronized (object) {
            myDigestMaker.reset();
            myDigestMaker.update(string.getBytes());
            byArray = myDigestMaker.digest();
        }
        object = new StringBuffer();
        for (int i = 0; i < byArray.length; ++i) {
            String string2 = Integer.toString(byArray[i] & 0xFF, 16);
            if (string2.length() == 1) {
                ((StringBuffer)object).append('0');
            }
            ((StringBuffer)object).append(string2);
        }
        this.lastRecordedUserID = ((StringBuffer)object).toString();
        this.aboutDialog.updateUserID(this.lastRecordedUserID);
    }

    private void rateSong(ChannelInfo channelInfo, int n) throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("channel=");
        stringBuffer.append(channelInfo.getChannelNumber());
        stringBuffer.append("&title=");
        stringBuffer.append(URLEncoder.encode(channelInfo.getChannelTitle(), "US-ASCII"));
        stringBuffer.append("&artist=");
        stringBuffer.append(URLEncoder.encode(channelInfo.getChannelArtist(), "US-ASCII"));
        stringBuffer.append("&rating=");
        stringBuffer.append(n);
        stringBuffer.append("&user=");
        stringBuffer.append(this.lastRecordedUserID);
        URL uRL = new URL("http://xmpcr.kfu.com/rate");
        URLConnection uRLConnection = uRL.openConnection();
        uRLConnection.setDoOutput(true);
        uRLConnection.setRequestProperty("User-Agent", JXM.userAgentString());
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter(uRLConnection.getOutputStream());
        outputStreamWriter.write(stringBuffer.toString());
        outputStreamWriter.close();
        uRLConnection.getContent();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void update(ChannelInfo channelInfo) {
        Object object;
        Object object2;
        if (!RadioCommander.theRadio().isOn()) {
            return;
        }
        if (channelInfo.getChannelName().length() == 0 && (object2 = (ChannelInfo)this.channelList.get(new Integer(channelInfo.getServiceID()))) != null) {
            channelInfo.setChannelName(((ChannelInfo)object2).getChannelName());
        }
        if (channelInfo.getChannelGenre().length() == 0 && (object2 = (ChannelInfo)this.channelList.get(new Integer(channelInfo.getServiceID()))) != null) {
            channelInfo.setChannelGenre(((ChannelInfo)object2).getChannelGenre());
        }
        if (channelInfo.equals(this.channelList.get(new Integer(channelInfo.getServiceID())))) {
            return;
        }
        object2 = this.channelList.values().iterator();
        while (object2.hasNext()) {
            object = (ChannelInfo)object2.next();
            if (channelInfo.getServiceID() == ((ChannelInfo)object).getServiceID() || channelInfo.getChannelNumber() != ((ChannelInfo)object).getChannelNumber()) continue;
            object2.remove();
        }
        this.searchSystem.update(channelInfo);
        boolean bl = !this.channelList.containsKey(new Integer(channelInfo.getServiceID())) && this.favoriteList.contains(new Integer(channelInfo.getServiceID()));
        this.channelList.put(new Integer(channelInfo.getServiceID()), channelInfo);
        if (bl) {
            this.rebuildFavoritesMenu();
        }
        this.rebuildSortedChannelList();
        this.selectCurrentChannel();
        if (RadioCommander.theRadio().getChannel() == channelInfo.getChannelNumber()) {
            this.currentChannelInfo = channelInfo;
            object = new Integer(channelInfo.getServiceID());
            boolean bl2 = this.favoriteList.contains(object);
            this.favoriteCheckbox.setSelected(bl2);
            this.ignoreFavoriteMenu = true;
            try {
                if (bl2) {
                    this.favoriteMenu.setSelectedItem(object);
                } else {
                    this.favoriteMenu.setSelectedIndex(0);
                }
            }
            finally {
                this.ignoreFavoriteMenu = false;
            }
            this.updateRatingSlider(channelInfo);
            this.nowPlayingPanel.setChannelInfo(channelInfo);
            this.compactView.setChannelInfo(channelInfo);
            if (this.smartMuteInfo != null && !channelInfo.equals(this.smartMuteInfo)) {
                this.smartMuteClicked();
            }
            this.scheduleTrackerUpdate();
        }
    }

    private void scheduleTrackerUpdate() {
        final ChannelInfo channelInfo = this.currentChannelInfo;
        new Thread(){

            public void run() {
                try {
                    XMTracker.theTracker().update(channelInfo);
                }
                catch (TrackerException trackerException) {
                    MainWindow.this.handleTrackerError(trackerException);
                }
            }
        }.start();
    }

    private void scrollToCurrentChannel() {
        int n = this.rowForSID(RadioCommander.theRadio().getServiceID());
        if (n < 0) {
            return;
        }
        Rectangle rectangle = this.channelTable.getCellRect(n, 0, true);
        this.channelTable.scrollRectToVisible(rectangle);
    }

    double getSearchAccuracy() {
        return this.preferences.getSearchAccuracy();
    }

    static /* synthetic */ ChannelInfo[] access$202(MainWindow mainWindow, ChannelInfo[] channelInfoArray) {
        mainWindow.sortedChannelList = channelInfoArray;
        return channelInfoArray;
    }

    static {
        try {
            myDigestMaker = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            myDigestMaker = null;
        }
    }

    class BlinkingIcon
    implements Icon {
        private int which;
        private int moonFactor = 4;

        public BlinkingIcon(int n) {
            this.which = n;
        }

        public int getIconHeight() {
            return this.which == 2 ? 0 : 10;
        }

        public int getIconWidth() {
            return this.getIconHeight();
        }

        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            graphics.translate(n, n2);
            graphics.setColor(new Color(0, 0, 0, 0));
            graphics.fillRect(0, 0, this.getIconWidth() - 1, this.getIconHeight() - 1);
            if (this.which != 0 && this.which == 1) {
                graphics.setColor(component.getForeground());
                graphics.fillArc(0, 0, this.getIconWidth(), this.getIconHeight(), 0, 360);
            }
            graphics.translate(-n, -n2);
        }
    }

    private class ActivationDialog
    extends JDialog {
        private final String radioID;
        private JFrame frame;

        public ActivationDialog(JFrame jFrame, String string) {
            super((Frame)jFrame, "Your XMPCR is not activated");
            this.radioID = string;
            this.frame = jFrame;
            JTabbedPane jTabbedPane = new JTabbedPane();
            JPanel jPanel = new JPanel();
            jPanel.setLayout(new GridBagLayout());
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.insets = new Insets(10, 10, 10, 10);
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.gridwidth = 2;
            JLabel jLabel = new JLabel("<html>Clicking \"Activate Now\" will take you to<br>XM Radio's radio activation web site. Your<br>Radio ID will be copied into the clipboard<br>for you. When the activation procedure asks<br>for your radio ID, you may simply paste it<br>into the form.</html>");
            jPanel.add((Component)jLabel, gridBagConstraints);
            JButton jButton = new JButton("Activate later");
            jButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    ActivationDialog.this.setVisible(false);
                }
            });
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.gridx = 1;
            gridBagConstraints.anchor = 21;
            jPanel.add((Component)jButton, gridBagConstraints);
            jButton = new JButton("Activate Now");
            jButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    StringSelection stringSelection = new StringSelection(ActivationDialog.this.radioID);
                    Toolkit.getDefaultToolkit().getSystemClipboard().setContents(stringSelection, stringSelection);
                    ActivationDialog.this.setVisible(false);
                    try {
                        PlatformFactory.ourPlatform().openURL("http://www.xmradio.com/activation/");
                    }
                    catch (IOException iOException) {
                        JOptionPane.showMessageDialog(ActivationDialog.this.frame, iOException.getMessage(), "Could not open XM activation page", 0);
                    }
                }
            });
            gridBagConstraints.gridy = 1;
            gridBagConstraints.anchor = 22;
            jPanel.add((Component)jButton, gridBagConstraints);
            jTabbedPane.addTab("Activate Online", jPanel);
            jPanel = new JPanel();
            jPanel.setLayout(new GridBagLayout());
            gridBagConstraints = new GridBagConstraints();
            jLabel = new JLabel("<html>To activate your XMPCR by phone, call 1-800-852-9696.<br>They will ask for your Radio ID.</html>");
            gridBagConstraints.insets = new Insets(10, 10, 10, 10);
            gridBagConstraints.gridy = 0;
            gridBagConstraints.gridx = 0;
            jPanel.add((Component)jLabel, gridBagConstraints);
            jLabel = new JLabel(this.radioID);
            jLabel.setHorizontalAlignment(0);
            jLabel.setFont(new Font("Monospaced", 1, 18));
            jLabel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.BLACK), "Your Radio ID"));
            jLabel.setPreferredSize(new Dimension(150, (int)jLabel.getPreferredSize().getHeight() + 10));
            gridBagConstraints.gridy = 1;
            jPanel.add((Component)jLabel, gridBagConstraints);
            jButton = new JButton("Done");
            jButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    ActivationDialog.this.setVisible(false);
                }
            });
            gridBagConstraints.gridy = 2;
            jPanel.add((Component)jButton, gridBagConstraints);
            jTabbedPane.addTab("Activate by phone", jPanel);
            this.getContentPane().add(jTabbedPane);
            this.pack();
        }
    }

    private class ArrowIcon
    implements Icon,
    SwingConstants {
        private int dir;
        private int width = 9;
        private int height = 12;

        public ArrowIcon(int n) {
            if (n != 1 && n != 5) {
                throw new IllegalArgumentException("Arrow must point NORTH or SOUTH");
            }
            this.dir = n;
        }

        public int getIconHeight() {
            return this.height;
        }

        public int getIconWidth() {
            return this.width;
        }

        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            if (component.isEnabled()) {
                graphics.setColor(component.getForeground());
            } else {
                graphics.setColor(Color.GRAY);
            }
            graphics.translate(n, n2);
            Polygon polygon = new Polygon();
            switch (this.dir) {
                case 1: {
                    polygon.addPoint(0, this.height / 2);
                    polygon.addPoint(this.width - 1, this.height / 2);
                    polygon.addPoint(this.width / 2, 1);
                    polygon.addPoint(0, this.height / 2);
                    break;
                }
                case 5: {
                    polygon.addPoint(0, this.height / 2);
                    polygon.addPoint(this.width - 1, this.height / 2);
                    polygon.addPoint(this.width / 2, this.height - 2);
                    polygon.addPoint(0, this.height / 2);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("How did this happen?!");
                }
            }
            graphics.fillPolygon(polygon);
            graphics.translate(-n, -n2);
        }
    }

    private class XIcon
    implements Icon {
        private XIcon() {
        }

        public int getIconHeight() {
            return 17;
        }

        public int getIconWidth() {
            return this.getIconHeight();
        }

        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            Graphics2D graphics2D = (Graphics2D)graphics;
            if (component.isEnabled()) {
                graphics2D.setColor(component.getForeground());
            } else {
                graphics2D.setColor(Color.GRAY);
            }
            graphics2D.translate(n, n2);
            graphics2D.fillArc(0, 0, this.getIconWidth() - 1, this.getIconHeight() - 1, 0, 360);
            graphics2D.setColor(component.getBackground());
            int n3 = this.getIconWidth() / 2;
            int n4 = this.getIconHeight() / 2;
            int n5 = this.getIconHeight() * 2 / 10;
            graphics2D.setStroke(new BasicStroke(1.3f, 1, 1));
            graphics2D.drawLine(n3 - n5, n4 - n5, n3 + n5, n4 + n5);
            graphics2D.drawLine(n3 + n5, n4 - n5, n3 - n5, n4 + n5);
            graphics2D.translate(-n, -n2);
        }
    }

    private class ChannelTableModel
    extends AbstractTableModel {
        private ChannelTableModel() {
        }

        public int getRowCount() {
            return MainWindow.this.sortedChannelList.length;
        }

        public int getColumnCount() {
            return 6;
        }

        public Object getValueAt(int n, int n2) {
            ChannelInfo channelInfo = MainWindow.this.sortedChannelList[n];
            switch (n2) {
                case 0: {
                    return new Integer(channelInfo.getChannelNumber());
                }
                case 1: {
                    return channelInfo.getChannelGenre();
                }
                case 2: {
                    return channelInfo.getChannelName();
                }
                case 3: {
                    return channelInfo.getChannelArtist();
                }
                case 4: {
                    return channelInfo.getChannelTitle();
                }
                case 5: {
                    return MainWindow.this.inUseForSID(channelInfo.getServiceID());
                }
            }
            throw new IllegalArgumentException("Which column?");
        }
    }

    public class ChannelPopupMenu
    extends JPopupMenu {
        ChannelInfo channelInfo;

        public ChannelPopupMenu(ChannelInfo channelInfo) {
            this(channelInfo, 0);
        }

        public ChannelPopupMenu(ChannelInfo channelInfo, int n) {
            this.channelInfo = channelInfo;
            JMenuItem jMenuItem = new JMenuItem("Tune to channel");
            if (n == 2 || !RadioCommander.theRadio().isOn()) {
                jMenuItem.setEnabled(false);
            } else {
                jMenuItem.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        MainWindow.this.setChannel(ChannelPopupMenu.this.channelInfo.getChannelNumber());
                    }
                });
            }
            this.add(jMenuItem);
            jMenuItem = new JMenuItem("Add to notebook");
            if (n == 1) {
                jMenuItem.setEnabled(false);
            } else {
                jMenuItem.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        MainWindow.this.memorize(ChannelPopupMenu.this.channelInfo);
                    }
                });
            }
            this.add(jMenuItem);
            this.add(new BookmarkMenu(this.channelInfo));
            jMenuItem = new JMenuItem("New search entry for this song");
            jMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    MainWindow.this.preferences.addNewSongSearch(ChannelPopupMenu.this.channelInfo);
                }
            });
            this.add(jMenuItem);
        }
    }

    private class BookmarkMenu
    extends JMenu {
        private ChannelInfo info;

        public BookmarkMenu(ChannelInfo channelInfo) {
            super("Web Bookmarks");
            this.info = channelInfo;
            for (int i = 0; i < MainWindow.this.bookmarks.length; ++i) {
                final Bookmark bookmark = MainWindow.this.bookmarks[i];
                JMenuItem jMenuItem = new JMenuItem(bookmark.getName());
                jMenuItem.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        MainWindow.this.bookmarkSurf(bookmark, BookmarkMenu.this.info);
                    }
                });
                this.add(jMenuItem);
            }
        }
    }

    public static class ChannelInfoPanel
    extends JPanel {
        public static final Font chNumFont = new Font(null, 1, 16);
        public static final Font chGenreFont = new Font(null, 0, 12);
        public static final Font chNameFont = new Font(null, 0, 14);
        public static final Font chArtistFont = new Font(null, 1, 18);
        public static final Font chTitleFont = new Font(null, 1, 18);
        private JLabel channelNumberLabel;
        private JLabel channelGenreLabel;
        private JLabel channelNameLabel;
        private JLabel channelArtistLabel;
        private JLabel channelTitleLabel;
        private JProgressBar songTimeBar;
        private Date songStart;
        private Date songEnd;
        private Timer songTimeTimer;

        public ChannelInfoPanel() {
            this.setLayout(new GridBagLayout());
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.fill = 1;
            this.channelNumberLabel = new JLabel();
            this.channelNumberLabel.setHorizontalAlignment(0);
            this.channelNumberLabel.setFont(chNumFont);
            gridBagConstraints.weightx = 0.25;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            this.add((Component)this.channelNumberLabel, gridBagConstraints);
            this.channelNameLabel = new JLabel();
            this.channelNameLabel.setHorizontalAlignment(0);
            this.channelNameLabel.setFont(chNameFont);
            gridBagConstraints.gridy = 1;
            this.add((Component)this.channelNameLabel, gridBagConstraints);
            this.channelGenreLabel = new JLabel();
            this.channelGenreLabel.setHorizontalAlignment(0);
            this.channelGenreLabel.setFont(chGenreFont);
            gridBagConstraints.gridy = 2;
            this.add((Component)this.channelGenreLabel, gridBagConstraints);
            this.channelArtistLabel = new JLabel();
            this.channelArtistLabel.setHorizontalAlignment(0);
            this.channelArtistLabel.setFont(chArtistFont);
            gridBagConstraints.gridx = 1;
            gridBagConstraints.weightx = 0.75;
            gridBagConstraints.gridwidth = 2;
            gridBagConstraints.gridy = 0;
            this.add((Component)this.channelArtistLabel, gridBagConstraints);
            this.channelTitleLabel = new JLabel();
            this.channelTitleLabel.setHorizontalAlignment(0);
            this.channelTitleLabel.setFont(chTitleFont);
            gridBagConstraints.gridy = 1;
            this.add((Component)this.channelTitleLabel, gridBagConstraints);
            this.songTimeBar = new SongTimeProgressBar();
            this.songTimeBar.setVisible(false);
            this.songTimeBar.setMinimum(0);
            this.songTimeBar.setMaximum(1000);
            this.songTimeBar.setBorderPainted(true);
            this.songTimeBar.setBackground(this.channelTitleLabel.getBackground());
            this.songTimeBar.setForeground(this.channelTitleLabel.getForeground());
            this.songTimeBar.setPreferredSize(new Dimension((int)this.getPreferredSize().getWidth(), 10));
            gridBagConstraints.gridy = 2;
            gridBagConstraints.fill = 2;
            gridBagConstraints.insets = new Insets(5, 20, 0, 20);
            this.add((Component)this.songTimeBar, gridBagConstraints);
            this.songTimeTimer = new Timer(50, new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    ChannelInfoPanel.this.timerTick();
                }
            });
            this.songTimeTimer.stop();
        }

        public void timerTick() {
            if (this.songStart == null || this.songEnd == null) {
                return;
            }
            long l = this.songEnd.getTime() - this.songStart.getTime();
            long l2 = new Date().getTime() - this.songStart.getTime();
            float f = (float)l2 / (float)l * 1000.0f;
            int n = f < 0.0f ? 0 : (f >= 1000.0f ? 1000 : (int)f);
            this.songTimeBar.setValue(n);
            if (n == 1000) {
                this.songTimeBar.setVisible(false);
                this.songTimeTimer.stop();
            }
            this.songTimeBar.repaint();
        }

        public void setSongTime(Date date, Date date2) {
            if (date == null || date2 == null) {
                this.songStart = null;
                this.songEnd = null;
                this.songTimeTimer.stop();
                this.songTimeBar.setVisible(false);
            } else {
                this.songStart = date;
                this.songEnd = date2;
                this.songTimeTimer.start();
                this.songTimeBar.setVisible(true);
            }
        }

        public void setChannelInfo(ChannelInfo channelInfo) {
            if (channelInfo != null) {
                this.channelNumberLabel.setText(Integer.toString(channelInfo.getChannelNumber()));
                this.channelGenreLabel.setText(channelInfo.getChannelGenre());
                this.channelNameLabel.setText(channelInfo.getChannelName());
                this.channelArtistLabel.setText(channelInfo.getChannelArtist());
                this.channelTitleLabel.setText(channelInfo.getChannelTitle());
            } else {
                this.channelNumberLabel.setText("");
                this.channelGenreLabel.setText("");
                this.channelNameLabel.setText("");
                this.channelArtistLabel.setText("");
                this.channelTitleLabel.setText("");
            }
        }

        private class SongTimeProgressBar
        extends JProgressBar {
            public void paintBorder(Graphics graphics) {
                graphics.setColor(this.getForeground());
                graphics.drawRect(0, 0, this.getWidth() - 1, this.getHeight() - 1);
            }

            public void paint(Graphics graphics) {
                Rectangle rectangle = this.getBounds();
                graphics.setColor(this.getBackground());
                graphics.fillRect(0, 0, (int)rectangle.getWidth() - 1, (int)rectangle.getHeight() - 1);
                this.paintBorder(graphics);
                int n = this.getMaximum() - this.getMinimum();
                int n2 = this.getValue() - this.getMinimum();
                int n3 = (int)((float)n2 * (float)rectangle.getWidth() / (float)n);
                int n4 = (int)(rectangle.getHeight() * (double)0.1f);
                Polygon polygon = new Polygon();
                polygon.addPoint(n3, n4);
                polygon.addPoint(n3 + (((int)rectangle.getHeight() - 1) / 2 - n4), (int)rectangle.getHeight() / 2);
                polygon.addPoint(n3, (int)rectangle.getHeight() - n4 - 1);
                polygon.addPoint(n3 - (((int)rectangle.getHeight() - 1) / 2 - n4), (int)rectangle.getHeight() / 2);
                polygon.addPoint(n3, n4);
                graphics.setColor(this.getForeground());
                graphics.fillPolygon(polygon);
            }
        }
    }

    private class CompactViewPanel
    extends JWindow {
        private SpinnerListModel compactSpinnerModel;
        private JSpinner theSpinner;
        private JLabel compactViewName;
        private JLabel compactViewArtist;
        private JLabel compactViewTitle;
        private boolean timerIgnore = false;
        private boolean changeInProgress = false;
        private java.util.Timer changeTimer = null;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void refreshSpinnerModel() {
            this.timerIgnore = true;
            try {
                ArrayList<Integer> arrayList = new ArrayList<Integer>();
                ChannelInfo[] channelInfoArray = MainWindow.this.sortedChannelList;
                for (int i = 0; i < channelInfoArray.length; ++i) {
                    arrayList.add(new Integer(channelInfoArray[i].getChannelNumber()));
                }
                Collections.sort(arrayList);
                if (arrayList.size() != 0) {
                    this.compactSpinnerModel.setList(arrayList);
                }
            }
            finally {
                this.timerIgnore = false;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setVisible(boolean bl) {
            this.refreshSpinnerModel();
            this.timerIgnore = true;
            try {
                this.compactSpinnerModel.setValue(new Integer(MainWindow.this.currentChannelInfo.getChannelNumber()));
            }
            finally {
                this.timerIgnore = false;
            }
            super.setVisible(bl);
            this.setChannelInfo(MainWindow.this.currentChannelInfo);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized void setTimerOff(final int n) {
            this.changeTimer.cancel();
            this.changeTimer = null;
            this.timerIgnore = true;
            try {
                if (!RadioCommander.theRadio().isOn()) {
                    return;
                }
                if (n == RadioCommander.theRadio().getChannel()) {
                    return;
                }
                SwingUtilities.invokeAndWait(new Runnable(){

                    public void run() {
                        CompactViewPanel.this.theSpinner.setEnabled(false);
                    }
                });
                SwingUtilities.invokeAndWait(new Runnable(){

                    public void run() {
                        MainWindow.this.setChannel(n);
                    }
                });
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        CompactViewPanel.this.theSpinner.setEnabled(true);
                    }
                });
            }
            catch (InterruptedException interruptedException) {
            }
            catch (InvocationTargetException invocationTargetException) {
            }
            finally {
                this.timerIgnore = false;
                this.changeInProgress = false;
            }
        }

        public CompactViewPanel() {
            JPanel jPanel = new JPanel();
            FlowLayout flowLayout = new FlowLayout();
            flowLayout.setHgap(10);
            jPanel.setLayout(flowLayout);
            WindowMover windowMover = new WindowMover(this);
            this.addMouseMotionListener(windowMover);
            this.addMouseListener(windowMover);
            this.compactSpinnerModel = new SpinnerListModel();
            this.theSpinner = new JSpinner(this.compactSpinnerModel);
            this.theSpinner.setPreferredSize(new Dimension(60, (int)this.theSpinner.getPreferredSize().getHeight()));
            this.theSpinner.addChangeListener(new ChangeListener(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void stateChanged(ChangeEvent changeEvent) {
                    CompactViewPanel compactViewPanel = CompactViewPanel.this;
                    synchronized (compactViewPanel) {
                        ChannelInfo channelInfo;
                        if (CompactViewPanel.this.timerIgnore) {
                            return;
                        }
                        CompactViewPanel.this.changeInProgress = true;
                        final int n = (Integer)CompactViewPanel.this.compactSpinnerModel.getValue();
                        int n2 = MainWindow.this.sidForChannel(n);
                        if (n2 >= 0 && (channelInfo = (ChannelInfo)MainWindow.this.channelList.get(new Integer(n2))) != null) {
                            CompactViewPanel.this.compactViewName.setText(channelInfo.getChannelName());
                            CompactViewPanel.this.compactViewArtist.setText(channelInfo.getChannelArtist());
                            CompactViewPanel.this.compactViewTitle.setText(channelInfo.getChannelTitle());
                        }
                        if (CompactViewPanel.this.changeTimer != null) {
                            CompactViewPanel.this.changeTimer.cancel();
                        }
                        CompactViewPanel.this.changeTimer = new java.util.Timer();
                        CompactViewPanel.this.changeTimer.schedule(new TimerTask(){

                            public void run() {
                                CompactViewPanel.this.setTimerOff(n);
                            }
                        }, 1000L);
                    }
                }
            });
            jPanel.add(this.theSpinner);
            this.compactViewName = new JLabel(" ");
            this.compactViewName.setPreferredSize(new Dimension(150, (int)this.compactViewName.getPreferredSize().getHeight()));
            jPanel.add(this.compactViewName);
            this.compactViewArtist = new JLabel(" ");
            this.compactViewArtist.setPreferredSize(new Dimension(150, (int)this.compactViewArtist.getPreferredSize().getHeight()));
            this.compactViewArtist.setHorizontalAlignment(0);
            jPanel.add(this.compactViewArtist);
            this.compactViewTitle = new JLabel(" ");
            this.compactViewTitle.setPreferredSize(new Dimension(150, (int)this.compactViewTitle.getPreferredSize().getHeight()));
            this.compactViewTitle.setHorizontalAlignment(0);
            jPanel.add(this.compactViewArtist);
            jPanel.add(this.compactViewTitle);
            JButton jButton = new JButton("Restore");
            jButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    MainWindow.this.toggleCompactView();
                }
            });
            jPanel.add(jButton);
            jPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createBevelBorder(0), BorderFactory.createBevelBorder(0)));
            this.getContentPane().add(jPanel);
            this.pack();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setChannelInfo(ChannelInfo channelInfo) {
            if (!this.isVisible()) {
                return;
            }
            if (this.changeInProgress && channelInfo != null) {
                return;
            }
            if (channelInfo == null) {
                this.compactViewName.setText("");
                this.compactViewArtist.setText("");
                this.compactViewTitle.setText("");
            } else {
                this.timerIgnore = true;
                try {
                    this.compactSpinnerModel.setValue(new Integer(channelInfo.getChannelNumber()));
                }
                finally {
                    this.timerIgnore = false;
                }
                this.compactViewName.setText(channelInfo.getChannelName());
                this.compactViewArtist.setText(channelInfo.getChannelArtist());
                this.compactViewTitle.setText(channelInfo.getChannelTitle());
            }
        }

        class WindowMover
        extends MouseInputAdapter {
            private Container window;
            int originX;
            int originY;

            public WindowMover(Container container) {
                this.window = container;
            }

            public void mousePressed(MouseEvent mouseEvent) {
                this.originX = mouseEvent.getX();
                this.originY = mouseEvent.getY();
            }

            public void mouseDragged(MouseEvent mouseEvent) {
                Point point = MainWindow.this.compactView.getLocation();
                MainWindow.this.compactView.setLocation(point.x + mouseEvent.getX() - this.originX, point.y + mouseEvent.getY() - this.originY);
            }
        }
    }

    private class SignalProgressBar
    extends JProgressBar {
        public SignalProgressBar(int n, int n2) {
            super(n, n2);
        }

        private float scale(float f) {
            if ((double)f > 0.5) {
                return 1.0f;
            }
            return (float)Math.sin((double)(f *= 2.0f) * Math.PI / 2.0);
        }

        public void paint(Graphics graphics) {
            Rectangle rectangle = this.getBounds();
            graphics.setColor(this.getBackground());
            graphics.fillRect(0, 0, (int)rectangle.getWidth(), (int)rectangle.getHeight());
            int n = this.getMaximum() - this.getMinimum();
            int n2 = this.getValue() - this.getMinimum();
            int n3 = (int)((float)n2 * (float)rectangle.getWidth() / (float)n);
            for (int i = 0; i < n3; i += 4) {
                float f = (float)n * ((float)i / (float)rectangle.getWidth()) / (float)n;
                graphics.setColor(new Color(this.scale(1.0f - f), this.scale(f), 0.0f, 1.0f));
                graphics.fillRect(i, 0, 2, (int)rectangle.getHeight() - 1);
            }
        }
    }
}

