/*
 * Decompiled with CFR 0.152.
 */
package com.kfu.Platform;

import com.ice.jni.registry.RegStringValue;
import com.ice.jni.registry.Registry;
import com.ice.jni.registry.RegistryKey;
import com.jeans.trayicon.SwingTrayPopup;
import com.jeans.trayicon.WindowsTrayIcon;
import com.kfu.JXM.Bookmark;
import com.kfu.JXM.Favorite;
import com.kfu.JXM.IPlatformCallbackHandler;
import com.kfu.JXM.IPlatformHandler;
import com.kfu.xm.ChannelInfo;
import edu.stanford.ejalbert.BrowserLauncher;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import javax.swing.AbstractButton;
import javax.swing.ImageIcon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuItem;

public class Win32
implements IPlatformHandler {
    private IPlatformCallbackHandler cb;
    private ArrayList ftdiDevices;
    private boolean crappyWindowsVersion;
    private WindowsTrayIcon trayIcon;

    public boolean useMacMenus() {
        return false;
    }

    public boolean needsBrowserPath() {
        return false;
    }

    public void setBrowserPath(String string) {
        throw new IllegalArgumentException("We don't care");
    }

    public void openURL(String string) throws IOException {
        BrowserLauncher.openURL(string);
    }

    public boolean devicesAreFiltered() {
        return !this.crappyWindowsVersion;
    }

    public boolean isDeviceValid(String string) {
        if (this.crappyWindowsVersion) {
            return true;
        }
        if (this.ftdiDevices == null) {
            this.getFTDIlist();
        }
        return this.ftdiDevices.contains(string);
    }

    public void registerCallbackHandler(IPlatformCallbackHandler iPlatformCallbackHandler) {
        this.cb = iPlatformCallbackHandler;
    }

    public Win32() throws Exception {
        String string = System.getProperty("os.name").toLowerCase();
        if (!string.startsWith("windows")) {
            throw new Exception("We're not using Windows! Yay!");
        }
        this.crappyWindowsVersion = string.indexOf("9") >= 0 || string.indexOf("me") >= 0;
        WindowsTrayIcon.initTrayIcon((String)"JXM");
        ImageIcon imageIcon = new ImageIcon(this.getClass().getResource("/images/trayicon.png"));
        this.trayIcon = new WindowsTrayIcon(imageIcon.getImage(), 16, 16);
        this.trayIcon.setVisible(true);
        new TrayIconMenu().setTrayIcon(this.trayIcon);
    }

    private void getFTDIlist() {
        if (this.crappyWindowsVersion) {
            throw new IllegalStateException("Can't do device filtering on win9x/winME");
        }
        this.ftdiDevices = new ArrayList();
        try {
            RegistryKey registryKey = Registry.HKEY_LOCAL_MACHINE.openSubKey("System\\CurrentControlSet");
            RegistryKey registryKey2 = registryKey.openSubKey("Services\\serenum\\Enum");
            Enumeration enumeration = registryKey2.valueElements();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                try {
                    Integer.parseInt(string);
                }
                catch (NumberFormatException numberFormatException) {
                    continue;
                }
                String string2 = ((RegStringValue)registryKey2.getValue(string)).getData();
                RegistryKey registryKey3 = registryKey.openSubKey("Enum\\" + string2);
                String string3 = ((RegStringValue)registryKey3.getValue("Mfg")).getData();
                if (!string3.equals("FTDI")) continue;
                registryKey3 = registryKey3.openSubKey("Device Parameters");
                String string4 = ((RegStringValue)registryKey3.getValue("PortName")).getData();
                this.ftdiDevices.add(string4);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void quit() {
        WindowsTrayIcon.cleanUp();
    }

    private class TrayIconMenu
    extends SwingTrayPopup {
        private JMenuItem chanItem = new JMenuItem("");
        private JMenuItem artistItem;
        private JMenuItem titleItem;
        private JMenuItem memoryItem;
        private JCheckBoxMenuItem muteItem;
        private JCheckBoxMenuItem smartMuteItem;
        private JMenu bookmarkMenu;
        private JMenu favoriteMenu;
        private ChannelInfo menuInfo;

        public void showMenu(int n, int n2) {
            this.rebuild();
            super.showMenu(n, n2);
        }

        private void rebuild() {
            Object object;
            if (!Win32.this.cb.radioIsOn() || (this.menuInfo = Win32.this.cb.getChannelInfo()) == null) {
                this.chanItem.setText("");
                this.artistItem.setText("");
                this.titleItem.setText("");
                this.setEnabled(false);
                this.muteItem.setEnabled(false);
                this.muteItem.setState(false);
                this.smartMuteItem.setEnabled(false);
                this.smartMuteItem.setState(false);
                this.memoryItem.setEnabled(false);
                this.bookmarkMenu.removeAll();
                this.favoriteMenu.removeAll();
                return;
            }
            this.chanItem.setText(Integer.toString(this.menuInfo.getChannelNumber()) + " - " + this.menuInfo.getChannelName());
            this.artistItem.setText(this.menuInfo.getChannelArtist());
            this.titleItem.setText(this.menuInfo.getChannelTitle());
            this.setEnabled(true);
            int n = Win32.this.cb.getMuteState();
            this.muteItem.setState(n == 1);
            this.smartMuteItem.setState(n == 2);
            this.muteItem.setEnabled(true);
            this.smartMuteItem.setEnabled(true);
            this.memoryItem.setEnabled(true);
            Bookmark[] bookmarkArray = Win32.this.cb.getBookmarks();
            this.bookmarkMenu.removeAll();
            for (int i = 0; i < bookmarkArray.length; ++i) {
                final Bookmark bookmark = bookmarkArray[i];
                object = new JMenuItem(bookmark.getName());
                ((AbstractButton)object).addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        try {
                            bookmark.surf(TrayIconMenu.this.menuInfo);
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                });
                this.bookmarkMenu.add((JMenuItem)object);
            }
            Favorite[] favoriteArray = Win32.this.cb.getFavorites();
            this.favoriteMenu.removeAll();
            for (int i = 0; i < favoriteArray.length; ++i) {
                object = favoriteArray[i];
                JMenuItem jMenuItem = new JMenuItem(((Favorite)object).getMenuString());
                jMenuItem.addActionListener(new ActionListener((Favorite)object){
                    private final /* synthetic */ Favorite val$fav;
                    {
                        this.val$fav = favorite;
                    }

                    public void actionPerformed(ActionEvent actionEvent) {
                        Win32.this.cb.platformNotify(5, new Integer(this.val$fav.getChannelNumber()));
                    }
                });
                this.favoriteMenu.add(jMenuItem);
            }
        }

        public TrayIconMenu() {
            this.chanItem.setEnabled(false);
            this.add(this.chanItem);
            this.artistItem = new JMenuItem("");
            this.artistItem.setEnabled(false);
            this.add(this.artistItem);
            this.titleItem = new JMenuItem("");
            this.titleItem.setEnabled(false);
            this.add(this.titleItem);
            this.addSeparator();
            this.bookmarkMenu = new JMenu("Bookmarks");
            this.add(this.bookmarkMenu);
            this.addSeparator();
            this.favoriteMenu = new JMenu("Favorites");
            this.add(this.favoriteMenu);
            this.addSeparator();
            this.memoryItem = new JMenuItem("Add to notebook");
            this.memoryItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    Win32.this.cb.platformNotify(6, TrayIconMenu.this.menuInfo);
                }
            });
            this.memoryItem.setEnabled(false);
            this.add(this.memoryItem);
            this.addSeparator();
            this.muteItem = new JCheckBoxMenuItem("Mute");
            this.muteItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    Win32.this.cb.platformNotify(4, null);
                }
            });
            this.add(this.muteItem);
            this.smartMuteItem = new JCheckBoxMenuItem("Smart Mute");
            this.smartMuteItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    Win32.this.cb.platformNotify(3, null);
                }
            });
            this.add(this.smartMuteItem);
            this.setEnabled(false);
        }
    }
}

