/*
 * Decompiled with CFR 0.152.
 */
package com.kfu.xm;

import com.kfu.xm.ChannelInfo;
import com.kfu.xm.IAsyncExceptionHandler;
import com.kfu.xm.IDebugLog;
import com.kfu.xm.RadioEventHandler;
import com.kfu.xm.RadioException;
import com.kfu.xm.RadioTimeoutException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import javax.comm.CommPortIdentifier;
import javax.comm.SerialPort;

public class RadioCommander
implements IAsyncExceptionHandler {
    public static final int POWERED_ON = 0;
    public static final int POWERED_OFF = 1;
    public static final int CHANNEL_CHANGED = 2;
    public static final int MUTE_CHANGED = 3;
    public static final int EXCEPTION = 4;
    public static final int ACTIVATION_CHANGED = 5;
    public static final int CHANNEL_INFO_UPDATE = 6;
    public static final int SONG_TIME_UPDATE = 7;
    public static final int CHANNEL_DELETE = 8;
    private InputStream myDeviceIn = null;
    private OutputStream myDeviceOut = null;
    private SerialPort mySerialPort = null;
    private static RadioCommander theSingleton;
    private ArrayList replyQueue;
    private static final int TIMEOUT = 5000;
    private replyWatcher myReplyWatcher = null;
    private static IDebugLog myLogger;
    private HashSet handlers = new HashSet();
    private int activated;
    private static final int UNKNOWN = 0;
    private static final int ACTIVATED = 1;
    private static final int UNACTIVATED = -1;
    private boolean disposing = false;
    private boolean powerChanging = false;
    private Date currentSongStarted;
    private Date currentSongEnds;
    private int currentChannel = -1;
    private ChannelInfo currentChannelInfo = new ChannelInfo();
    private boolean mutestate = false;
    public static final int SIGNAL_STRENGTH_SAT = 0;
    public static final int SIGNAL_STRENGTH_TER = 1;
    int lastChannel;
    HashSet channelList = new HashSet();
    Timer theSurfer;

    private Response makeResponse(byte[] byArray) {
        Response response = null;
        switch (byArray[0]) {
            case -128: {
                response = new respPoweredOn(byArray);
                break;
            }
            case -127: {
                response = new respPoweredOff(byArray);
                break;
            }
            case -112: {
                response = new respChannelChanged(byArray);
                break;
            }
            case -109: {
                response = new respMuteSet(byArray);
                break;
            }
            case -94: {
                response = new respExtendedChannelInfo(byArray);
                break;
            }
            case -91: {
                response = new respChannelInfo(byArray);
                break;
            }
            case -79: {
                response = new respRadioID(byArray);
                break;
            }
            case -61: {
                response = new respExtendedSignalQuality(byArray);
                break;
            }
            case -48: {
                response = new respLabelChangeMonitored(byArray);
                break;
            }
            case -47: {
                response = new respMonitorChannelName(byArray);
                break;
            }
            case -46: {
                response = new respMonitorChannelGenre(byArray);
                break;
            }
            case -45: {
                response = new respMonitorArtistTitle(byArray);
                break;
            }
            case -44: {
                response = new respMonitorExtendedArtist(byArray);
                break;
            }
            case -43: {
                response = new respMonitorExtendedTitle(byArray);
                break;
            }
            case -42: {
                response = new respMonitorSongTime(byArray);
                break;
            }
            case -32: {
                response = new respActivationIndicated(byArray);
                break;
            }
            case -31: {
                response = new respDeactivationIndicated(byArray);
                break;
            }
            case -28: {
                response = new respMagicXMDirect(byArray);
                break;
            }
            case -14: {
                response = new respMagicXMDirectIgnore(byArray);
                break;
            }
            case -1: {
                response = new respFatalError(byArray);
                break;
            }
            default: {
                RadioCommander.Log("Got unknown response: " + RadioCommander.hexify(byArray));
                response = null;
            }
        }
        return response;
    }

    private static String hexify(byte[] byArray) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < byArray.length; ++i) {
            stringBuffer.append(RadioCommander.hexify(byArray[i]));
            if (i == byArray.length - 1) continue;
            stringBuffer.append(' ');
        }
        return stringBuffer.toString();
    }

    private static String hexify(byte by) {
        int n = by & 0xFF;
        String string = Integer.toString(n, 16);
        return string.length() == 2 ? string : "0" + string;
    }

    public static String[] getPotentialDevices() {
        ArrayList<String> arrayList = new ArrayList<String>();
        Enumeration enumeration = CommPortIdentifier.getPortIdentifiers();
        while (enumeration.hasMoreElements()) {
            CommPortIdentifier commPortIdentifier = (CommPortIdentifier)enumeration.nextElement();
            if (commPortIdentifier.getPortType() != 1) continue;
            arrayList.add(commPortIdentifier.getName());
        }
        return arrayList.toArray(new String[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static RadioCommander theRadio() {
        Class clazz = RadioCommander.class;
        synchronized (clazz) {
            if (theSingleton == null) {
                theSingleton = new RadioCommander();
            }
        }
        return theSingleton;
    }

    private RadioCommander() {
    }

    private synchronized Response performCommand(Command command, Class clazz) throws RadioException {
        for (int i = 0; i < 3; ++i) {
            try {
                if (this.myDeviceIn == null) {
                    throw new RadioException("Radio turned off unexpectedly.");
                }
                this.sendCommand(command.getData());
                if (clazz != null) {
                    return this.waitForReply(clazz);
                }
                try {
                    Thread.sleep(250L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                return null;
            }
            catch (RadioTimeoutException radioTimeoutException) {
                RadioCommander.Log("Timeout #" + Integer.toString(i + 1) + " waiting for " + clazz.toString());
                continue;
            }
            catch (IllegalStateException illegalStateException) {
                throw new RadioException("Radio reset while processing command.");
            }
        }
        this.Dispose();
        throw new RadioException("Command processing failed after 3 retries");
    }

    private void sendCommand(byte[] byArray) throws RadioException {
        OutputStream outputStream = this.myDeviceOut;
        if (outputStream == null) {
            this.Dispose();
            throw new RadioException("Cannot talk to radio while it's off");
        }
        try {
            outputStream.write(byArray);
            outputStream.flush();
        }
        catch (IOException iOException) {
            this.Dispose();
            throw new RadioException("Cannot write to device: " + iOException.getMessage());
        }
    }

    private Response waitForReply(Class clazz) throws RadioException {
        ArrayList arrayList = this.replyQueue;
        synchronized (arrayList) {
            while (true) {
                Response response;
                if (this.myDeviceIn == null) {
                    throw new RadioTimeoutException("Radio powered off while waiting for reply");
                }
                if (this.replyQueue.size() == 0) {
                    try {
                        this.replyQueue.wait(5000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    if (this.replyQueue.size() == 0) {
                        throw new RadioTimeoutException("Timeout waiting for " + clazz.getName());
                    }
                }
                if (clazz.isInstance(response = (Response)this.replyQueue.remove(0))) {
                    return response;
                }
                RadioCommander.Log("Throwing away " + response.getClass().getName() + " while waiting for " + clazz.getName());
            }
        }
    }

    private static void Log(String string) {
        if (myLogger != null) {
            myLogger.log(string);
        }
    }

    public static void setDebugLog(IDebugLog iDebugLog) {
        myLogger = iDebugLog;
    }

    public void registerEventHandler(RadioEventHandler radioEventHandler) {
        this.handlers.add(radioEventHandler);
    }

    public void unregisterEventHandler(RadioEventHandler radioEventHandler) {
        this.handlers.remove(radioEventHandler);
    }

    private void notifyGUI(int n) {
        this.notifyGUI(n, null);
    }

    private void notifyGUI(int n, Object object) {
        Iterator iterator = this.handlers.iterator();
        while (iterator.hasNext()) {
            RadioEventHandler radioEventHandler = (RadioEventHandler)iterator.next();
            try {
                radioEventHandler.notify(this, n, object);
            }
            catch (Throwable throwable) {
                System.err.println(throwable.getMessage());
                throwable.printStackTrace();
            }
        }
    }

    public void turnOn(String string) throws RadioException {
        this.turnOn(string, -1, false);
    }

    public void turnOn(String string, boolean bl) throws RadioException {
        this.turnOn(string, -1, bl);
    }

    public void turnOn(String string, int n) throws RadioException {
        this.turnOn(string, n, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void turnOn(String string, int n, boolean bl) throws RadioException {
        if (this.myDeviceIn != null || this.myDeviceOut != null) {
            throw new IllegalStateException("Radio is already on");
        }
        this.powerChanging = true;
        try {
            Object object;
            Object object2;
            Object object3;
            try {
                object3 = CommPortIdentifier.getPortIdentifier((String)string);
                if (object3.getPortType() != 1) {
                    throw new RadioException("Port is not a PORT_SERIAL");
                }
                object2 = (SerialPort)object3.open("com.kfu.xm.RadioCommander", 0);
                object2.setSerialPortParams(9600, 8, 1, 0);
                object2.setFlowControlMode(0);
                object2.disableReceiveThreshold();
                object2.enableReceiveTimeout(1000);
                this.myDeviceOut = object2.getOutputStream();
                this.myDeviceIn = object2.getInputStream();
                this.mySerialPort = object2;
            }
            catch (Throwable throwable) {
                this.Dispose();
                throw new RadioException("Cannot open device: " + throwable.getMessage());
            }
            RadioCommander.Log("Opened file");
            try {
                while (this.myDeviceIn.available() > 0) {
                    this.myDeviceIn.read();
                }
            }
            catch (IOException iOException) {
                this.Dispose();
                throw new RadioException(iOException.getMessage());
            }
            this.replyQueue = new ArrayList();
            this.myReplyWatcher = new replyWatcher();
            this.myReplyWatcher.start();
            if (bl) {
                RadioCommander.Log("Sending special XM Direct commands");
                this.performCommand(new cmdMagicXMDirect(0), respMagicXMDirect.class);
                this.performCommand(new cmdMagicXMDirect(1), respMagicXMDirect.class);
                this.performCommand(new cmdMagicXMDirect(2), null);
            }
            RadioCommander.Log("Sending power-up");
            object3 = (respPoweredOn)this.performCommand(new cmdPowerUp(), respPoweredOn.class);
            RadioCommander.Log("Got power-up reply");
            object2 = ((respPoweredOn)object3).getHardwareVersionData();
            Iterator iterator = object2.keySet().iterator();
            while (iterator.hasNext()) {
                object = (String)iterator.next();
                String string2 = (String)object2.get(object);
                RadioCommander.Log((String)object + ": " + string2);
            }
            RadioCommander.Log("Radio ID: " + ((respPoweredOn)object3).getRadioID());
            this.activated = 0;
            if (((Response)object3).getStatusCode() == 3) {
                RadioCommander.theRadio().setActivated(false);
            }
            this.mutestate = false;
            this.currentChannel = -1;
            try {
                Thread.sleep(250L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (this.myDeviceIn == null || this.myDeviceOut == null) {
                return;
            }
            object = this.channelList;
            synchronized (object) {
                this.channelList.clear();
            }
            this.notifyGUI(0);
            int n2 = this.getChannelInfoByServiceID(((respPoweredOn)object3).getLastAudioService()).getChannelNumber();
            if (n2 < 0) {
                n2 = 1;
            }
            if (n >= 1 && n <= 255) {
                n2 = n;
            }
            this.setChannel(n2);
            if (this.currentChannel == -1) {
                this.setChannel(1);
            }
            this.lastChannel = 0;
            this.theSurfer = new Timer();
            this.theSurfer.schedule(new TimerTask(){

                public void run() {
                    RadioCommander.this.timerJob();
                }
            }, 100L, 100L);
            this.currentSongEnds = null;
            this.currentSongStarted = null;
        }
        finally {
            this.powerChanging = false;
        }
    }

    public void handleException(Exception exception) {
        this.Dispose();
        this.notifyGUI(4, exception);
    }

    private void checkDisposed() throws RadioException {
        if (this.myDeviceIn == null || this.myDeviceOut == null) {
            throw new RadioException("Cannot talk to radio when it's off.");
        }
    }

    public boolean isOn() {
        if (this.powerChanging) {
            return false;
        }
        return this.myDeviceIn != null;
    }

    void setActivated(boolean bl) {
        int n = this.activated;
        int n2 = bl ? 1 : -1;
        if (n == n2) {
            return;
        }
        this.activated = n2;
        if (n == 0 && n2 == 1) {
            return;
        }
        this.notifyGUI(5, new Boolean(bl));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void Dispose() {
        if (this.disposing) {
            return;
        }
        this.disposing = true;
        try {
            if (this.theSurfer != null) {
                this.theSurfer.cancel();
            }
            this.theSurfer = null;
            InputStream inputStream = this.myDeviceIn;
            this.myDeviceIn = null;
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (IOException iOException) {
                RadioCommander.Log("Could not close device input: " + iOException.getMessage());
            }
            OutputStream outputStream = this.myDeviceOut;
            this.myDeviceOut = null;
            try {
                if (outputStream != null) {
                    outputStream.close();
                }
            }
            catch (IOException iOException) {
                RadioCommander.Log("Could not close device output: " + iOException.getMessage());
            }
            if (this.mySerialPort != null) {
                this.mySerialPort.close();
            }
            this.mySerialPort = null;
            this.myReplyWatcher = null;
        }
        finally {
            this.disposing = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void turnOff() throws RadioException {
        this.checkDisposed();
        this.powerChanging = true;
        try {
            this.theSurfer.cancel();
            this.theSurfer = null;
            RadioCommander.Log("Sending power-off");
            this.performCommand(new cmdPowerDown(), respPoweredOff.class);
            RadioCommander.Log("Got power-off reply");
            this.Dispose();
            this.notifyGUI(1);
        }
        finally {
            this.powerChanging = false;
        }
    }

    public int getChannel() {
        return this.currentChannel;
    }

    public int getServiceID() {
        return this.currentChannelInfo.getServiceID();
    }

    public void setChannel(int n) throws RadioException {
        respLabelChangeMonitored respLabelChangeMonitored2;
        this.checkDisposed();
        if (this.currentChannel > 0) {
            respLabelChangeMonitored2 = (respLabelChangeMonitored)this.performCommand(new cmdMonitorLabelChange(this.currentChannel, false, false, false, false), respLabelChangeMonitored.class);
        }
        RadioCommander.Log("Sending channel-set to " + Integer.toString(n));
        respChannelChanged respChannelChanged2 = (respChannelChanged)this.performCommand(new cmdChangeChannel(n), respChannelChanged.class);
        RadioCommander.Log("Got set-channel reply");
        if (respChannelChanged2.getStatusCode() != 1) {
            return;
        }
        this.currentSongEnds = null;
        this.currentSongStarted = null;
        this.currentChannel = n;
        this.notifyGUI(2);
        this.currentChannelInfo = this.getChannelInfo();
        this.updateChannelInfo();
        respLabelChangeMonitored2 = (respLabelChangeMonitored)this.performCommand(new cmdMonitorLabelChange(n, true, true, true, true), respLabelChangeMonitored.class);
    }

    private void updateChannelInfo() {
        this.updateChannelInfo(this.currentChannelInfo);
    }

    private void updateChannelInfo(ChannelInfo channelInfo) {
        this.notifyGUI(6, new ChannelInfo(channelInfo));
    }

    public String getRadioID() throws RadioException {
        this.checkDisposed();
        RadioCommander.Log("Sent radio id request");
        respRadioID respRadioID2 = (respRadioID)this.performCommand(new cmdGetRadioID(), respRadioID.class);
        RadioCommander.Log("Got radio id reply");
        return respRadioID2.getRadioID();
    }

    public boolean isMuted() {
        return this.mutestate;
    }

    public void setMute(boolean bl) throws RadioException {
        this.checkDisposed();
        this.performCommand(new cmdSetMute(bl), respMuteSet.class);
        this.mutestate = bl;
        this.notifyGUI(3);
    }

    public ExtendedSignalData getExtendedSignalData() throws RadioException {
        this.checkDisposed();
        respExtendedSignalQuality respExtendedSignalQuality2 = (respExtendedSignalQuality)this.performCommand(new cmdGetExtendedSignalQuality(), respExtendedSignalQuality.class);
        return new ExtendedSignalData(respExtendedSignalQuality2);
    }

    public double[] getSignalStrength() throws RadioException {
        this.checkDisposed();
        respExtendedSignalQuality respExtendedSignalQuality2 = (respExtendedSignalQuality)this.performCommand(new cmdGetExtendedSignalQuality(), respExtendedSignalQuality.class);
        return new double[]{respExtendedSignalQuality2.getSatSigPercent(), respExtendedSignalQuality2.getTerSigPercent()};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setChannelList(int[] nArray) {
        HashSet hashSet = this.channelList;
        synchronized (hashSet) {
            this.channelList.clear();
            for (int i = 0; i < nArray.length; ++i) {
                this.channelList.add(new Integer(nArray[i]));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void timerJob() {
        ChannelInfo channelInfo;
        try {
            channelInfo = this.getNextChannelInfo(this.lastChannel);
        }
        catch (RadioException radioException) {
            if (this.myDeviceIn != null) {
                this.handleException(radioException);
            }
            return;
        }
        if (this.myDeviceIn == null) {
            return;
        }
        if (channelInfo == null) {
            HashSet hashSet = this.channelList;
            synchronized (hashSet) {
                Iterator iterator = this.channelList.iterator();
                while (iterator.hasNext()) {
                    int n = (Integer)iterator.next();
                    if (n <= this.lastChannel) continue;
                    iterator.remove();
                    this.notifyGUI(8, new Integer(n));
                }
            }
            this.lastChannel = 0;
            return;
        }
        this.updateChannelInfo(channelInfo);
        HashSet hashSet = this.channelList;
        synchronized (hashSet) {
            Iterator iterator = this.channelList.iterator();
            while (iterator.hasNext()) {
                int n = (Integer)iterator.next();
                if (n <= this.lastChannel || n >= channelInfo.getChannelNumber()) continue;
                iterator.remove();
                this.notifyGUI(8, new Integer(n));
            }
        }
        this.lastChannel = channelInfo.getChannelNumber();
    }

    private ChannelInfo getNextChannelInfo(int n) throws RadioException {
        this.checkDisposed();
        respChannelInfo respChannelInfo2 = (respChannelInfo)this.performCommand(new cmdNextChannelInfo(n), respChannelInfo.class);
        ChannelInfo channelInfo = respChannelInfo2.getChannelInfo();
        if (channelInfo.getChannelNumber() == 0) {
            return null;
        }
        return channelInfo;
    }

    private void tryToExtendChannelInfo(ChannelInfo channelInfo) throws RadioException {
        String string;
        respExtendedChannelInfo respExtendedChannelInfo2 = (respExtendedChannelInfo)this.performCommand(new cmdExtendedChannelInfo(channelInfo.getChannelNumber()), respExtendedChannelInfo.class);
        String string2 = respExtendedChannelInfo2.getArtist();
        if (string2 != null) {
            channelInfo.setChannelArtist(string2);
        }
        if ((string = respExtendedChannelInfo2.getTitle()) != null) {
            channelInfo.setChannelTitle(string);
        }
    }

    public ChannelInfo getChannelInfo() throws RadioException {
        return this.getChannelInfo(this.getChannel());
    }

    public ChannelInfo getChannelInfoByServiceID(int n) throws RadioException {
        respChannelInfo respChannelInfo2 = (respChannelInfo)this.performCommand(new cmdThisChannelInfoBySID(n), respChannelInfo.class);
        ChannelInfo channelInfo = respChannelInfo2.getChannelInfo();
        if (channelInfo.getChannelNumber() == this.getChannel()) {
            this.tryToExtendChannelInfo(channelInfo);
        }
        this.updateChannelInfo(channelInfo);
        return channelInfo;
    }

    public ChannelInfo getChannelInfo(int n) throws RadioException {
        this.checkDisposed();
        respChannelInfo respChannelInfo2 = (respChannelInfo)this.performCommand(new cmdThisChannelInfo(n), respChannelInfo.class);
        ChannelInfo channelInfo = respChannelInfo2.getChannelInfo();
        if (this.getChannel() == n) {
            this.tryToExtendChannelInfo(channelInfo);
        }
        this.updateChannelInfo(channelInfo);
        return channelInfo;
    }

    static {
        myLogger = null;
    }

    private class replyWatcher
    extends Thread {
        private replyWatcher() {
        }

        private byte getNextChar() throws IOException, ThreadMustExitException {
            InputStream inputStream;
            int n;
            do {
                if ((inputStream = RadioCommander.this.myDeviceIn) != null) continue;
                throw new ThreadMustExitException();
            } while ((n = inputStream.read()) < 0);
            return (byte)(n & 0xFF);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            while (true) {
                try {
                    while (true) {
                        Response response;
                        if (this.getNextChar() != 90) {
                            continue;
                        }
                        if (this.getNextChar() != -91) {
                            throw new RadioException("Mismatch waiting for second flag");
                        }
                        int n = this.getNextChar() & 0xFF;
                        n <<= 8;
                        byte[] byArray = new byte[n += this.getNextChar() & 0xFF];
                        for (int i = 0; i < n; ++i) {
                            byArray[i] = this.getNextChar();
                        }
                        if (byArray[0] != -28) {
                            this.getNextChar();
                            this.getNextChar();
                        }
                        if ((response = RadioCommander.this.makeResponse(byArray)) == null) continue;
                        if (response.isInternal()) {
                            response.handle();
                            continue;
                        }
                        ArrayList arrayList = RadioCommander.this.replyQueue;
                        synchronized (arrayList) {
                            RadioCommander.this.replyQueue.add(response);
                            RadioCommander.this.replyQueue.notify();
                        }
                    }
                }
                catch (IOException iOException) {
                    boolean bl = RadioCommander.this.myDeviceIn == null;
                    RadioCommander.this.Dispose();
                    if (bl) continue;
                    RadioCommander.this.notifyGUI(4, iOException);
                    continue;
                }
                catch (RadioException radioException) {
                    RadioCommander.this.Dispose();
                    RadioCommander.this.notifyGUI(4, radioException);
                    continue;
                }
                break;
            }
            catch (ThreadMustExitException threadMustExitException) {
                return;
            }
        }

        private class ThreadMustExitException
        extends Exception {
            private ThreadMustExitException() {
            }
        }
    }

    private class respFatalError
    extends Response {
        public respFatalError(byte[] byArray) {
            super(byArray);
        }

        public boolean isInternal() {
            return true;
        }

        public void handle() {
            RadioCommander.Log("Received fatal error response: " + RadioCommander.hexify(this.getStatusCode()) + " " + RadioCommander.hexify(this.getStatusDetail()));
            RadioException radioException = new RadioException("Radio indicated fatal error: " + RadioCommander.hexify(this.getStatusCode()) + "/" + RadioCommander.hexify(this.getStatusDetail()) + ".");
            RadioCommander.this.handleException(radioException);
        }
    }

    private class respMagicXMDirect
    extends Response {
        public respMagicXMDirect(byte[] byArray) {
            super(byArray);
        }
    }

    private class respMagicXMDirectIgnore
    extends Response {
        public respMagicXMDirectIgnore(byte[] byArray) {
            super(byArray);
        }

        public boolean isInternal() {
            return true;
        }

        public void handle() {
        }
    }

    private class respMonitorSongTime
    extends Response {
        public respMonitorSongTime(byte[] byArray) {
            super(byArray);
        }

        public boolean isInternal() {
            return true;
        }

        public void handle() {
            Date date = new Date();
            int n = this.getProgressTime();
            if (n < 0) {
                RadioCommander.this.currentSongStarted = null;
            } else {
                RadioCommander.this.currentSongStarted = new Date(date.getTime() - (long)(n * 1000));
            }
            int n2 = this.getDurationTime();
            if (n2 < 0) {
                RadioCommander.this.currentSongEnds = null;
            } else {
                RadioCommander.this.currentSongEnds = new Date(date.getTime() + (long)((n2 - n) * 1000));
            }
            RadioCommander.Log("Got song time update message");
            RadioCommander.Log("  Started: " + RadioCommander.this.currentSongStarted);
            RadioCommander.Log("  Now:     " + date);
            RadioCommander.Log("  Ends:    " + RadioCommander.this.currentSongEnds);
            SongTiming songTiming = new SongTiming(RadioCommander.this.currentSongStarted, RadioCommander.this.currentSongEnds);
            RadioCommander.this.notifyGUI(7, songTiming);
        }

        public int getChannel() {
            return this.getByte(0) & 0xFF;
        }

        public int getFormat() {
            return this.getByte(1) & 0xFF;
        }

        public int getProgressTime() {
            if (this.getByte(3) == 0) {
                return -1;
            }
            int n = this.getByte(6) & 0xFF;
            n <<= 8;
            return n += this.getByte(7) & 0xFF;
        }

        public int getDurationTime() {
            if (this.getByte(2) == 0) {
                return -1;
            }
            int n = this.getByte(4) & 0xFF;
            n <<= 8;
            return n += this.getByte(5) & 0xFF;
        }
    }

    private class respMonitorExtendedTitle
    extends Response {
        public respMonitorExtendedTitle(byte[] byArray) {
            super(byArray);
        }

        public boolean isInternal() {
            return true;
        }

        public void handle() {
            RadioCommander.Log("Got channel extended title response: ch=" + Integer.toString(this.getChannel()) + " -> " + this.getChannelTitle());
            RadioCommander.this.currentChannelInfo.setChannelTitle(this.getChannelTitle());
            RadioCommander.this.updateChannelInfo();
        }

        public int getChannel() {
            return this.getByte(0) & 0xFF;
        }

        public String getChannelTitle() {
            if (this.getByte(1) == 0) {
                return null;
            }
            return this.extractString(2, 32);
        }
    }

    private class respMonitorExtendedArtist
    extends Response {
        public respMonitorExtendedArtist(byte[] byArray) {
            super(byArray);
        }

        public boolean isInternal() {
            return true;
        }

        public void handle() {
            RadioCommander.Log("Got channel extended artist response: ch=" + Integer.toString(this.getChannel()) + " -> " + this.getChannelArtist());
            RadioCommander.this.currentChannelInfo.setChannelArtist(this.getChannelArtist());
            RadioCommander.this.updateChannelInfo();
        }

        public int getChannel() {
            return this.getByte(0) & 0xFF;
        }

        public String getChannelArtist() {
            if (this.getByte(1) == 0) {
                return null;
            }
            return this.extractString(2, 32);
        }
    }

    private class respMonitorArtistTitle
    extends Response {
        public respMonitorArtistTitle(byte[] byArray) {
            super(byArray);
        }

        public boolean isInternal() {
            return true;
        }

        public void handle() {
            RadioCommander.Log("Got channel name artist / title response: ch=" + Integer.toString(this.getChannel()) + " -> " + this.getChannelArtist() + " / " + this.getChannelTitle());
            RadioCommander.this.currentChannelInfo.setChannelTitle(this.getChannelTitle());
            RadioCommander.this.currentChannelInfo.setChannelArtist(this.getChannelArtist());
            RadioCommander.this.updateChannelInfo();
        }

        public int getChannel() {
            return this.getByte(0) & 0xFF;
        }

        public String getChannelArtist() {
            if (this.getByte(1) == 0) {
                return null;
            }
            return this.extractString(2, 16);
        }

        public String getChannelTitle() {
            if (this.getByte(1) == 0) {
                return null;
            }
            return this.extractString(18, 16);
        }
    }

    private class respMonitorChannelGenre
    extends Response {
        public respMonitorChannelGenre(byte[] byArray) {
            super(byArray);
        }

        public boolean isInternal() {
            return true;
        }

        public void handle() {
            RadioCommander.Log("Got channel genre monitor response: ch=" + Integer.toString(this.getChannel()) + " -> " + this.getChannelGenre());
            RadioCommander.this.currentChannelInfo.setChannelGenre(this.getChannelGenre());
            RadioCommander.this.updateChannelInfo();
        }

        public int getChannel() {
            return this.getByte(0) & 0xFF;
        }

        public String getChannelGenre() {
            if (this.getByte(2) == 0) {
                return null;
            }
            return this.extractString(3, 16);
        }
    }

    private class respMonitorChannelName
    extends Response {
        public respMonitorChannelName(byte[] byArray) {
            super(byArray);
        }

        public boolean isInternal() {
            return true;
        }

        public void handle() {
            RadioCommander.Log("Got channel name monitor response: ch=" + Integer.toString(this.getChannel()) + " -> " + this.getChannelName());
            RadioCommander.this.currentChannelInfo.setChannelName(this.getChannelName());
            RadioCommander.this.updateChannelInfo();
        }

        public int getChannel() {
            return this.getByte(0) & 0xFF;
        }

        public String getChannelName() {
            if (this.getByte(1) == 0) {
                return null;
            }
            return this.extractString(2, 16);
        }
    }

    private class respLabelChangeMonitored
    extends Response {
        public respLabelChangeMonitored(byte[] byArray) {
            super(byArray);
        }

        public int getChannel() {
            return this.getByte(2) & 0xFF;
        }
    }

    private class respExtendedChannelInfo
    extends Response {
        public respExtendedChannelInfo(byte[] byArray) {
            super(byArray);
        }

        public String getArtist() {
            if (this.getByte(3) == 0) {
                return null;
            }
            return this.extractString(4, 32);
        }

        public String getTitle() {
            if (this.getByte(40) == 0) {
                return null;
            }
            return this.extractString(41, 32);
        }
    }

    private class respDeactivationIndicated
    extends Response {
        protected respDeactivationIndicated(byte[] byArray) {
            super(byArray);
        }

        protected boolean isInternal() {
            return true;
        }

        protected void handle() {
            RadioCommander.theRadio().setActivated(false);
        }

        public byte getStatusCode() {
            return -1;
        }

        public byte getStatusDetail() {
            return -1;
        }
    }

    private class respActivationIndicated
    extends Response {
        public respActivationIndicated(byte[] byArray) {
            super(byArray);
        }

        protected boolean isInternal() {
            return true;
        }

        protected void handle() {
            RadioCommander.theRadio().setActivated(true);
        }

        public byte getStatusCode() {
            return -1;
        }

        public byte getStatusDetail() {
            return -1;
        }
    }

    private class respExtendedSignalQuality
    extends Response {
        public respExtendedSignalQuality(byte[] byArray) {
            super(byArray);
        }

        int internalGetByte(int n) {
            return this.getByte(n) & 0xFF;
        }

        public double getSatSigPercent() {
            double d;
            double d2 = this.satCNtoPercent(this.getByte(23) & 0xFF);
            return d2 > (d = this.satCNtoPercent(this.getByte(24) & 0xFF)) ? d2 : d;
        }

        private double satCNtoPercent(int n) {
            int n2;
            if ((n -= 6) < 0) {
                n = 0;
            }
            double d = (n2 = n / 4) < 12 ? (double)(n * 80 / 12 / 4) : (n2 < 16 ? 80.0 + (double)((n - 48) * 20 / 4 / 4) : 99.9);
            return d;
        }

        public double getTerSigPercent() {
            int n = this.getByte(15) & 0xFF;
            n <<= 8;
            double d = (double)(n += this.getByte(16) & 0xFF) / 68.0;
            d *= 10.0;
            if ((d = 100.0 - d) <= 0.0) {
                return 0.0;
            }
            if (d >= 100.0) {
                return 99.9;
            }
            return d;
        }
    }

    private class respRadioID
    extends Response {
        public respRadioID(byte[] byArray) {
            super(byArray);
        }

        public String getRadioID() {
            return this.extractString(3, this.getByte(2));
        }
    }

    private class respChannelInfo
    extends Response {
        public respChannelInfo(byte[] byArray) {
            super(byArray);
        }

        public ChannelInfo getChannelInfo() {
            String string;
            String string2;
            int n = this.getByte(2) & 0xFF;
            int n2 = this.getByte(3) & 0xFF;
            String string3 = this.getByte(4) != 0 ? this.extractString(5, 16) : "";
            String string4 = this.getByte(21) != 0 ? this.extractString(23, 16) : "";
            if (this.getByte(39) != 0) {
                string2 = this.extractString(40, 16);
                string = this.extractString(56, 16);
            } else {
                string = "";
                string2 = "";
            }
            return new ChannelInfo(n, n2, string4, string3, string2, string);
        }
    }

    private class respMuteSet
    extends Response {
        public respMuteSet(byte[] byArray) {
            super(byArray);
        }
    }

    private class respChannelChanged
    extends Response {
        public respChannelChanged(byte[] byArray) {
            super(byArray);
        }
    }

    private class respPoweredOn
    extends Response {
        public respPoweredOn(byte[] byArray) {
            super(byArray);
        }

        public Map getHardwareVersionData() {
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.put("RX version", Integer.toString(this.getByte(3) & 0xFF));
            hashMap.put("RX date", this.getDate(4));
            hashMap.put("CBM version", Integer.toString(this.getByte(12) & 0xFF));
            hashMap.put("CBM date", this.getDate(13));
            return hashMap;
        }

        public String getRadioID() {
            return this.extractString(18, this.getByte(17));
        }

        private String byte_to_bcd(int n) {
            int n2 = this.getByte(n) & 0xFF;
            String string = Integer.toString(n2, 16);
            if (string.length() == 1) {
                return "0" + string;
            }
            return string;
        }

        private String getDate(int n) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(this.byte_to_bcd(n + 2));
            stringBuffer.append(this.byte_to_bcd(n + 3));
            stringBuffer.append('-');
            stringBuffer.append(this.byte_to_bcd(n));
            stringBuffer.append('-');
            stringBuffer.append(this.byte_to_bcd(n + 1));
            return stringBuffer.toString();
        }

        private int getLastAudioService() {
            if (this.getByte(9) == 0) {
                return this.getByte(8) & 0xFF;
            }
            if (this.getByte(11) == 0) {
                return this.getByte(10) & 0xFF;
            }
            return 0;
        }
    }

    private class respPoweredOff
    extends Response {
        public respPoweredOff(byte[] byArray) {
            super(byArray);
        }
    }

    abstract class Response {
        private byte[] data;

        protected Response(byte[] byArray) {
            this.data = byArray;
        }

        protected boolean isInternal() {
            return false;
        }

        protected void handle() {
            throw new IllegalArgumentException("Can't call handle on non-internal response.");
        }

        public byte getStatusCode() {
            return this.getByte(0);
        }

        public byte getStatusDetail() {
            return this.getByte(1);
        }

        protected byte getByte(int n) {
            return this.data[n + 1];
        }

        protected String extractString(int n, int n2) {
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = 0; i < n2; ++i) {
                byte by = this.getByte(n + i);
                if (by <= 32 || by >= 127) {
                    stringBuffer.append(' ');
                    continue;
                }
                stringBuffer.append((char)by);
            }
            return stringBuffer.toString().trim();
        }
    }

    private class cmdMagicXMDirect
    extends Command {
        public cmdMagicXMDirect(int n) {
            super((byte)116, n == 1 ? 3 : 2, (byte)116, (byte)13);
            switch (n) {
                case 0: {
                    this.setByte(0, (byte)0);
                    this.setByte(1, (byte)1);
                    break;
                }
                case 1: {
                    this.setByte(0, (byte)2);
                    this.setByte(1, (byte)1);
                    this.setByte(2, (byte)1);
                    break;
                }
                case 2: {
                    this.setByte(0, (byte)11);
                    this.setByte(1, (byte)0);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Bad magic command");
                }
            }
        }
    }

    private class cmdMonitorLabelChange
    extends Command {
        public cmdMonitorLabelChange(int n, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
            super((byte)80, 5);
            this.setByte(0, (byte)n);
            this.setByte(1, (byte)(bl ? 1 : 0));
            this.setByte(2, (byte)(bl2 ? 1 : 0));
            this.setByte(3, (byte)(bl3 ? 1 : 0));
            this.setByte(4, (byte)(bl4 ? 1 : 0));
        }
    }

    private class cmdExtendedChannelInfo
    extends Command {
        public cmdExtendedChannelInfo(int n) {
            super((byte)34, 1);
            this.setByte(0, (byte)n);
        }
    }

    private class cmdNextChannelInfo
    extends Command {
        public cmdNextChannelInfo(int n) {
            super((byte)37, 3);
            this.setByte(0, (byte)9);
            this.setByte(1, (byte)n);
            this.setByte(2, (byte)0);
        }
    }

    private class cmdThisChannelInfoBySID
    extends Command {
        public cmdThisChannelInfoBySID(int n) {
            super((byte)37, 3);
            this.setByte(0, (byte)7);
            this.setByte(1, (byte)n);
            this.setByte(2, (byte)0);
        }
    }

    private class cmdThisChannelInfo
    extends Command {
        public cmdThisChannelInfo(int n) {
            super((byte)37, 3);
            this.setByte(0, (byte)8);
            this.setByte(1, (byte)n);
            this.setByte(2, (byte)0);
        }
    }

    private class cmdSetMute
    extends Command {
        public cmdSetMute(boolean bl) {
            super((byte)19, 1);
            this.setByte(0, (byte)(bl ? 1 : 0));
        }
    }

    private class cmdChangeChannel
    extends Command {
        public cmdChangeChannel(int n) {
            super((byte)16, 5);
            this.setByte(0, (byte)2);
            this.setByte(1, (byte)n);
            this.setByte(2, (byte)0);
            this.setByte(3, (byte)0);
            this.setByte(4, (byte)1);
        }
    }

    private class cmdGetRadioID
    extends Command {
        public cmdGetRadioID() {
            super((byte)49, 0);
        }
    }

    private class cmdGetExtendedSignalQuality
    extends Command {
        public cmdGetExtendedSignalQuality() {
            super((byte)67, 0);
        }
    }

    private class cmdPowerDown
    extends Command {
        public cmdPowerDown(boolean bl) {
            super((byte)1, 1);
            this.setByte(0, (byte)(bl ? 1 : 0));
        }

        public cmdPowerDown() {
            this(false);
        }
    }

    private class cmdPowerUp
    extends Command {
        public cmdPowerUp() {
            super((byte)0, 4);
            this.setByte(0, (byte)16);
            this.setByte(1, (byte)16);
            this.setByte(2, (byte)36);
            this.setByte(3, (byte)1);
        }
    }

    private abstract class Command {
        private byte[] buf;

        protected Command(byte by, int n) {
            this.buf = new byte[n + 7];
            this.buf[0] = 90;
            this.buf[1] = -91;
            this.buf[2] = (byte)(++n >> 8);
            this.buf[3] = (byte)(n & 0xFF);
            this.buf[4] = by;
            this.buf[this.buf.length - 2] = -19;
            this.buf[this.buf.length - 1] = -19;
        }

        protected Command(byte by, int n, byte by2, byte by3) {
            this(by, n);
            this.buf[this.buf.length - 2] = by2;
            this.buf[this.buf.length - 1] = by3;
        }

        protected void setByte(int n, byte by) {
            this.buf[n + 5] = by;
        }

        public byte[] getData() {
            return this.buf;
        }
    }

    public static class ExtendedSignalData {
        respExtendedSignalQuality response;

        ExtendedSignalData(respExtendedSignalQuality respExtendedSignalQuality2) {
            this.response = respExtendedSignalQuality2;
        }

        private float cnIntToFloat(int n) {
            return (float)n / 4.0f;
        }

        private float berIntToFloat(int n) {
            float f = (float)n / 68.0f;
            if (f >= 100.0f) {
                f = 100.0f;
            }
            return f;
        }

        public boolean sat1QPSK() {
            return this.response.internalGetByte(5) != 0;
        }

        public boolean sat1TDM() {
            return this.response.internalGetByte(8) != 0;
        }

        public float satAGC() {
            return this.response.internalGetByte(21);
        }

        public float sat1BER() {
            int n = this.response.internalGetByte(11);
            n <<= 8;
            return this.berIntToFloat(n += this.response.internalGetByte(12));
        }

        public float sat1CN() {
            return this.cnIntToFloat(this.response.internalGetByte(23));
        }

        public boolean sat2QPSK() {
            return this.response.internalGetByte(6) != 0;
        }

        public boolean sat2TDM() {
            return this.response.internalGetByte(9) != 0;
        }

        public float sat2BER() {
            int n = this.response.internalGetByte(13);
            n <<= 8;
            return this.berIntToFloat(n += this.response.internalGetByte(14));
        }

        public float sat2CN() {
            return this.cnIntToFloat(this.response.internalGetByte(24));
        }

        public boolean terMCM() {
            return this.response.internalGetByte(7) != 0;
        }

        public boolean terTDM() {
            return this.response.internalGetByte(10) != 0;
        }

        public float terBER() {
            int n = this.response.internalGetByte(15);
            n <<= 8;
            return this.berIntToFloat(n += this.response.internalGetByte(16));
        }

        public float terAGC() {
            return this.response.internalGetByte(22);
        }

        public int miscAntStat() {
            return this.response.internalGetByte(3);
        }

        public int miscSigStat() {
            return this.response.internalGetByte(2);
        }

        public int miscTunerStat() {
            return this.response.internalGetByte(4);
        }
    }

    public static class SongTiming {
        public Date start;
        public Date end;

        public SongTiming(Date date, Date date2) {
            this.start = date;
            this.end = date2;
        }

        public Date start() {
            return this.start;
        }

        public Date end() {
            return this.end;
        }
    }
}

