/*
 * Decompiled with CFR 0.152.
 */
package com.wcohen.secondstring;

import com.wcohen.secondstring.AbstractStringDistance;
import com.wcohen.secondstring.CharMatchScore;
import com.wcohen.secondstring.MemoMatrix;
import com.wcohen.secondstring.StringWrapper;

public class AffineGap
extends AbstractStringDistance {
    private CharMatchScore charMatchScore;
    private double openGapScore;
    private double extendGapScore;
    private double lowerBound;

    public AffineGap() {
        this(CharMatchScore.DIST_21, 2.0, 1.0, -1.7976931348623157E308);
    }

    public AffineGap(CharMatchScore charMatchScore, double d, double d2, double d3) {
        this.charMatchScore = charMatchScore;
        this.openGapScore = d;
        this.extendGapScore = d2;
        this.lowerBound = d3;
    }

    public double score(StringWrapper stringWrapper, StringWrapper stringWrapper2) {
        MatrixTrio matrixTrio = new MatrixTrio(stringWrapper, stringWrapper2);
        return this.score(stringWrapper, stringWrapper2, matrixTrio);
    }

    private double score(StringWrapper stringWrapper, StringWrapper stringWrapper2, MatrixTrio matrixTrio) {
        double d = -1.7976931348623157E308;
        int n = 0;
        while (n <= stringWrapper.length()) {
            int n2 = 0;
            while (n2 <= stringWrapper2.length()) {
                d = Math.max(d, matrixTrio.get(n, n2));
                ++n2;
            }
            ++n;
        }
        return d;
    }

    public String explainScore(StringWrapper stringWrapper, StringWrapper stringWrapper2) {
        MatrixTrio matrixTrio = new MatrixTrio(stringWrapper, stringWrapper2);
        double d = this.score(stringWrapper, stringWrapper2, matrixTrio);
        return matrixTrio.toString() + "\nScore = " + d;
    }

    public static void main(String[] stringArray) {
        AbstractStringDistance.doMain(new AffineGap(), stringArray);
    }

    protected class MatrixTrio
    extends MemoMatrix {
        protected MemoMatrix m;
        protected InsertSMatrix is;
        protected InsertTMatrix it;

        public MatrixTrio(StringWrapper stringWrapper, StringWrapper stringWrapper2) {
            super(stringWrapper, stringWrapper2);
            this.is = new InsertSMatrix(stringWrapper, stringWrapper2);
            this.it = new InsertTMatrix(stringWrapper, stringWrapper2);
            this.m = this;
        }

        public double compute(int n, int n2) {
            if (n == 0 || n2 == 0) {
                return 0.0;
            }
            double d = AffineGap.this.charMatchScore.matchScore(this.sAt(n), this.tAt(n2));
            double d2 = this.m.get(n - 1, n2 - 1) + d;
            double d3 = this.is.get(n - 1, n2 - 1) + d;
            n = 1;
            return MemoMatrix.max4(AffineGap.this.lowerBound, d2, d3, this.it.get(1, n2 - 1) + d);
        }

        protected class InsertTMatrix
        extends MemoMatrix {
            public InsertTMatrix(StringWrapper stringWrapper, StringWrapper stringWrapper2) {
                super(stringWrapper, stringWrapper2);
            }

            public double compute(int n, int n2) {
                if (n == 0 || n2 == 0) {
                    return 0.0;
                }
                return MemoMatrix.max3(AffineGap.this.lowerBound, MatrixTrio.this.m.get(n, n2 - 1) + AffineGap.this.openGapScore, MatrixTrio.this.it.get(n, n2 - 1) + AffineGap.this.extendGapScore);
            }
        }

        protected class InsertSMatrix
        extends MemoMatrix {
            public InsertSMatrix(StringWrapper stringWrapper, StringWrapper stringWrapper2) {
                super(stringWrapper, stringWrapper2);
            }

            public double compute(int n, int n2) {
                if (n == 0 || n2 == 0) {
                    return 0.0;
                }
                return MemoMatrix.max3(AffineGap.this.lowerBound, MatrixTrio.this.m.get(n - 1, n2) + AffineGap.this.openGapScore, MatrixTrio.this.is.get(n - 1, n2) + AffineGap.this.extendGapScore);
            }
        }
    }
}

