/*
 * Decompiled with CFR 0.152.
 */
package com.wcohen.secondstring;

import com.wcohen.secondstring.AbstractStringDistance;
import com.wcohen.secondstring.BagOfTokens;
import com.wcohen.secondstring.StringWrapper;
import com.wcohen.secondstring.tokens.SimpleTokenizer;
import com.wcohen.secondstring.tokens.Token;
import com.wcohen.secondstring.tokens.Tokenizer;
import java.util.Iterator;

public class Jaccard
extends AbstractStringDistance {
    private Tokenizer tokenizer;

    public Jaccard(Tokenizer tokenizer) {
        this.tokenizer = tokenizer;
    }

    public Jaccard() {
        this(SimpleTokenizer.DEFAULT_TOKENIZER);
    }

    public double score(StringWrapper stringWrapper, StringWrapper stringWrapper2) {
        BagOfTokens bagOfTokens = (BagOfTokens)stringWrapper;
        BagOfTokens bagOfTokens2 = (BagOfTokens)stringWrapper2;
        double d = 0.0;
        Iterator iterator = bagOfTokens.tokenIterator();
        while (iterator.hasNext()) {
            Token token = (Token)iterator.next();
            if (!bagOfTokens2.contains(token)) continue;
            d += 1.0;
        }
        return d / ((double)(bagOfTokens.size() + bagOfTokens2.size()) - d);
    }

    public StringWrapper prepare(String string) {
        return new BagOfTokens(string, this.tokenizer.tokenize(string));
    }

    public String explainScore(StringWrapper stringWrapper, StringWrapper stringWrapper2) {
        Object object;
        BagOfTokens bagOfTokens = (BagOfTokens)stringWrapper;
        BagOfTokens bagOfTokens2 = (BagOfTokens)stringWrapper2;
        StringBuffer stringBuffer = new StringBuffer("");
        stringBuffer.append("S: ");
        Iterator iterator = bagOfTokens.tokenIterator();
        while (iterator.hasNext()) {
            object = (Token)iterator.next();
            stringBuffer.append(" " + ((Token)object).getValue());
            if (!bagOfTokens2.contains((Token)object)) continue;
            stringBuffer.append("*");
        }
        stringBuffer.append("\nT: ");
        object = bagOfTokens2.tokenIterator();
        while (object.hasNext()) {
            Token token = (Token)object.next();
            stringBuffer.append(" " + token.getValue());
            if (!bagOfTokens.contains(token)) continue;
            stringBuffer.append("*");
        }
        stringBuffer.append("\nscore = " + this.score(stringWrapper, stringWrapper2));
        return stringBuffer.toString();
    }

    public String toString() {
        return "[Jaccard]";
    }

    public static void main(String[] stringArray) {
        AbstractStringDistance.doMain(new Jaccard(), stringArray);
    }
}

